/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.dnd;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.cdo.core.util.CDOFunctions;
import org.eclipse.papyrus.cdo.core.util.CDOPredicates;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.ui.handlers.ExportModelHandler;
import org.eclipse.papyrus.cdo.internal.ui.views.DIModel;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class ResourceDropAdapterAssistant
extends CommonDropAdapterAssistant {
    private static final IStatus INVALID_DROP = new Status(4, "org.eclipse.papyrus.cdo.ui", "Invalid drop.");
    private static final IStatus VALID_DROP = Status.OK_STATUS;

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        IStructuredSelection sel;
        IStatus result = INVALID_DROP;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType) && CDOPredicates.adaptsTo(IContainer.class).apply(target) && (sel = (IStructuredSelection)CDOUtils.tryCast((Object)LocalSelectionTransfer.getTransfer().getSelection(), IStructuredSelection.class)) != null && !sel.isEmpty() && Iterables.all((Iterable)sel.toList(), (Predicate)CDOPredicates.adaptsTo(DIModel.class))) {
            result = VALID_DROP;
        }
        return result;
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        IContainer container;
        IStatus result = INVALID_DROP;
        IStructuredSelection sel = (IStructuredSelection)CDOUtils.tryCast((Object)LocalSelectionTransfer.getTransfer().getSelection(), IStructuredSelection.class);
        if (sel != null && !sel.isEmpty() && (container = (IContainer)CDOUtils.adapt((Object)aTarget, IContainer.class)) != null) {
            Function uriFunction = Functions.compose((Function)new Function<DIModel, URI>(){

                public URI apply(DIModel input) {
                    return input.getResource().getURI();
                }
            }, (Function)CDOFunctions.adapt(DIModel.class));
            ArrayList uris = Lists.newArrayList((Iterable)Iterables.transform((Iterable)sel.toList(), (Function)uriFunction));
            ExportModelHandler.exportModels(container, uris);
            result = VALID_DROP;
        }
        return result;
    }

    public static final class DummyContent
    implements ICommonContentProvider {
        private static final Object[] NOTHING = new Object[0];

        public Object[] getElements(Object inputElement) {
            return NOTHING;
        }

        public Object[] getChildren(Object parentElement) {
            return NOTHING;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void restoreState(IMemento aMemento) {
        }

        public void saveState(IMemento aMemento) {
        }

        public void init(ICommonContentExtensionSite aConfig) {
        }
    }

    public static final class DummyLabels
    extends LabelProvider
    implements ICommonLabelProvider {
        public void restoreState(IMemento aMemento) {
        }

        public void saveState(IMemento aMemento) {
        }

        public String getDescription(Object anElement) {
            return null;
        }

        public void init(ICommonContentExtensionSite aConfig) {
        }
    }
}

