/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.uml.search.internal.ui.query;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.collection.Triplet;
import org.eclipse.papyrus.cdo.core.resource.CDOAwareModelSet;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.uml.search.internal.ui.Activator;
import org.eclipse.papyrus.cdo.uml.search.internal.ui.open.CDOOpenElementService;
import org.eclipse.papyrus.cdo.uml.search.internal.ui.query.AttributeMatchStrategy;
import org.eclipse.papyrus.cdo.uml.search.internal.ui.query.CDOPapyrusQuery;
import org.eclipse.papyrus.cdo.uml.search.internal.ui.query.PatternUtil;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.services.openelement.service.OpenElementService;
import org.eclipse.papyrus.uml.search.ui.providers.ParticipantTypeAttribute;
import org.eclipse.papyrus.uml.search.ui.query.AbstractPapyrusQuery;
import org.eclipse.papyrus.uml.search.ui.query.CompositePapyrusQuery;
import org.eclipse.papyrus.uml.search.ui.query.IPapyrusQueryProvider;
import org.eclipse.papyrus.uml.search.ui.query.QueryInfo;
import org.eclipse.papyrus.views.search.utils.DefaultServiceRegistryTracker;
import org.eclipse.uml2.uml.UMLPackage;

public class CDOSearchQueryProvider
implements IPapyrusQueryProvider {
    public boolean canProvideFor(URI scope) {
        return CDOUtils.isCDOURI((URI)scope);
    }

    public AbstractPapyrusQuery createSimpleSearchQuery(QueryInfo queryInfo) {
        Pair<String, Boolean> _searchPattern = this.getSearchPattern(queryInfo);
        final String searchPattern = (String)_searchPattern.getElement1();
        final boolean isRegexMatch = (Boolean)_searchPattern.getElement2();
        return this.createOCLSearchQuery(queryInfo, AttributeMatchStrategy.create(queryInfo), new Function<Triplet<QueryInfo, CDOView, Collection<URI>>, CDOQuery>(){

            public CDOQuery apply(Triplet<QueryInfo, CDOView, Collection<URI>> input) {
                HashMap parameters = Maps.newHashMap();
                String ocl = CDOSearchQueryProvider.this.createOCLExpression(searchPattern, isRegexMatch, ((QueryInfo)input.getElement1()).isSearchAllStringAttributes(), (Collection<URI>)((Collection)input.getElement3()), (Map<String, Object>)parameters);
                CDOQuery result = ((CDOView)input.getElement2()).createQuery("ocl", ocl, (Object)UMLPackage.Literals.NAMED_ELEMENT);
                for (Map.Entry next : parameters.entrySet()) {
                    result.setParameter((String)next.getKey(), next.getValue());
                }
                return result;
            }
        });
    }

    public AbstractPapyrusQuery createAdvancedSearchQuery(QueryInfo queryInfo) {
        Pair<String, Boolean> _searchPattern = this.getSearchPattern(queryInfo);
        final String searchPattern = (String)_searchPattern.getElement1();
        final boolean isRegexMatch = (Boolean)_searchPattern.getElement2();
        ArrayListMultimap attributes = ArrayListMultimap.create();
        for (ParticipantTypeAttribute next : Iterables.filter((Iterable)queryInfo.getParticipantTypes(), ParticipantTypeAttribute.class)) {
            if (!(next.getParent().getElement() instanceof EClass)) continue;
            EAttribute attr = (EAttribute)next.getElement();
            attributes.put((Object)((EClass)next.getParent().getElement()), (Object)attr);
        }
        for (ParticipantTypeAttribute next : Iterables.filter((Iterable)queryInfo.getParticipantTypes(), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(ParticipantTypeAttribute.class)))) {
            EClass eclass;
            if (!(next.getElement() instanceof EClass) || attributes.containsKey((Object)(eclass = (EClass)next.getElement())) || eclass.getEAllAttributes().isEmpty()) continue;
            attributes.putAll((Object)eclass, (Iterable)eclass.getEAllAttributes());
        }
        return this.createOCLSearchQuery(queryInfo, AttributeMatchStrategy.create(queryInfo, (Multimap<EClass, EAttribute>)attributes), new Function<Triplet<QueryInfo, CDOView, Collection<URI>>, CDOQuery>((Multimap)attributes){
            private final /* synthetic */ Multimap val$attributes;
            {
                this.val$attributes = multimap;
            }

            public CDOQuery apply(Triplet<QueryInfo, CDOView, Collection<URI>> input) {
                HashMap parameters = Maps.newHashMap();
                String ocl = CDOSearchQueryProvider.this.createOCLExpression(searchPattern, isRegexMatch, (Multimap<EClass, EAttribute>)this.val$attributes, (Collection<URI>)((Collection)input.getElement3()), (Map<String, Object>)parameters);
                CDOQuery result = ((CDOView)input.getElement2()).createQuery("ocl", ocl, (Object)UMLPackage.Literals.NAMED_ELEMENT);
                for (Map.Entry next : parameters.entrySet()) {
                    result.setParameter((String)next.getKey(), next.getValue());
                }
                return result;
            }
        });
    }

    protected Pair<String, Boolean> getSearchPattern(QueryInfo queryInfo) {
        boolean isRegexMatch;
        String searchPattern = PatternUtil.wrap(queryInfo.getQueryText(), queryInfo.isCaseSensitive(), queryInfo.isRegularExpression(), queryInfo.isSearchAllStringAttributes());
        boolean bl = isRegexMatch = searchPattern != null;
        if (!isRegexMatch) {
            searchPattern = queryInfo.getQueryText();
        }
        return Pair.create((Object)searchPattern, (Object)isRegexMatch);
    }

    protected AbstractPapyrusQuery createOCLSearchQuery(QueryInfo queryInfo, AttributeMatchStrategy attributeMatcheStrategy, Function<Triplet<QueryInfo, CDOView, Collection<URI>>, CDOQuery> queryFunction) {
        DefaultServiceRegistryTracker tracker = new DefaultServiceRegistryTracker();
        Multimap<CDOView, URI> views = this.getViews(queryInfo.getScope());
        ArrayList result = Lists.newArrayListWithCapacity((int)views.keySet().size());
        for (CDOView view : views.keySet()) {
            CDOQuery query = (CDOQuery)queryFunction.apply((Object)new Triplet((Object)queryInfo, (Object)view, (Object)views.get((Object)view)));
            query.setParameter("cdoImplicitRootClass", (Object)EcorePackage.Literals.EOBJECT);
            CDOPapyrusQuery searchQuery = new CDOPapyrusQuery(queryInfo.getQueryText(), view, query, attributeMatcheStrategy);
            result.add(searchQuery);
            try {
                tracker.track((Object)searchQuery, ServiceUtilsForResourceSet.getInstance().getServiceRegistry(view.getResourceSet()));
            }
            catch (ServiceException e) {
                Activator.log.error("Cannot track services registry for automatic clean-up.", (Throwable)e);
            }
        }
        return CompositePapyrusQuery.compose((Iterable)result);
    }

    protected Multimap<CDOView, URI> getViews(Collection<URI> scope) {
        HashMultimap result = HashMultimap.create();
        HashMap views = Maps.newHashMap();
        try {
            for (URI uri : scope) {
                CDOCheckout checkout = CDOExplorerUtil.getCheckout((Object)uri);
                if (checkout == null || !checkout.isOpen()) continue;
                CDOView view = (CDOView)views.get(checkout);
                if (view == null) {
                    ServicesRegistry services = new ServicesRegistry();
                    services.add(LabelProviderService.class, 10, (IService)new LabelProviderServiceImpl());
                    services.add(OpenElementService.class, 10, (IService)new CDOOpenElementService());
                    services.add(ModelSet.class, 10, (Object)new CDOAwareModelSet());
                    services.startRegistry();
                    view = checkout.openTransaction((ResourceSet)ServiceUtils.getInstance().getModelSet((Object)services));
                    views.put(checkout, view);
                }
                result.put((Object)view, (Object)uri);
            }
        }
        catch (ServiceException e) {
            Activator.log.error("Failed to initialize service registry for CDO search query.", (Throwable)e);
        }
        return result;
    }

    protected String createOCLExpression(String searchPattern, boolean isRegexMatch, boolean isAllStringAttributes, Collection<URI> scope, Map<String, Object> parameters) {
        StringBuilder result = new StringBuilder();
        parameters.put("searchPattern", searchPattern);
        StringBuilder scopeClause = this.getScopeClause(scope);
        if (scopeClause.length() == 0) {
            result.append("NamedElement.allInstances()");
        } else {
            result.append("eresource::CDOResource.allInstances()->select(r | ");
            result.append((CharSequence)scopeClause);
            result.append(")");
            result.append("->collect(r | r.cdoAllProperContents(NamedElement))");
        }
        if (isAllStringAttributes) {
            result.append("->select(e | e.cdoMatches(searchPattern))");
        } else {
            result.append("->select(e | not e.name.oclIsUndefined() and e.name.");
            if (isRegexMatch) {
                result.append("matches(searchPattern)");
            } else {
                result.append("indexOf(searchPattern) > 0");
            }
            result.append(")");
        }
        return result.toString();
    }

    protected StringBuilder getScopeClause(Iterable<URI> scope) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (URI uri : scope) {
            String path = CDOURIUtil.extractResourcePath((URI)uri);
            if (uri.hasTrailingPathSeparator() && !path.endsWith("/")) {
                path = String.valueOf(path) + "/";
            }
            if (path.length() <= 1 && (path.startsWith("/") || path.length() <= 0)) continue;
            if (first) {
                first = false;
            } else {
                result.append(" or ");
            }
            result.append("r.path.startsWith('");
            result.append(CDOSearchQueryProvider.oclQuoteString(path));
            result.append("')");
        }
        return result;
    }

    protected String createOCLExpression(String searchPattern, boolean isRegexMatch, Multimap<EClass, EAttribute> attributes, Collection<URI> scope, Map<String, Object> parameters) {
        StringBuilder result = new StringBuilder();
        parameters.put("searchPattern", searchPattern);
        StringBuilder scopeClause = this.getScopeClause(scope);
        if (scopeClause.length() == 0) {
            result.append("NamedElement.allInstances()");
        } else {
            result.append("eresource::CDOResource.allInstances()->select(r | ");
            result.append((CharSequence)scopeClause);
            result.append(")");
            result.append("->collect(r | r.cdoAllProperContents(NamedElement))");
        }
        result.append("->select(e | ");
        boolean firstEClass = true;
        for (EClass next : attributes.keySet()) {
            if (firstEClass) {
                firstEClass = false;
            } else {
                result.append(" or ");
            }
            result.append("e.oclIsKindOf(").append(next.getName()).append(") and (");
            result.append("let s : ").append(next.getName()).append(" = e.oclAsType(").append(next.getName()).append(") in ");
            boolean firstAttr = true;
            for (EAttribute attr : attributes.get((Object)next)) {
                if (firstAttr) {
                    firstAttr = false;
                } else {
                    result.append(" or ");
                }
                if (CDOSearchQueryProvider.isString((ETypedElement)attr)) {
                    if (attr.isMany()) {
                        result.append("s.").append(attr.getName()).append("->excluding(null)->exists(v | v");
                    } else {
                        result.append("(not s.").append(attr.getName()).append(".oclIsUndefined() and s.").append(attr.getName());
                    }
                    if (isRegexMatch) {
                        result.append(".matches(searchPattern)");
                    } else {
                        result.append(".indexOf(searchPattern) > 0");
                    }
                    result.append(")");
                    continue;
                }
                result.append("s.").append(attr.getName()).append("->excluding(null).toString()->excluding(null)->exists(v | v");
                if (isRegexMatch) {
                    result.append(".matches(searchPattern)");
                } else {
                    result.append(".indexOf(searchPattern) > 0");
                }
                result.append(")");
            }
            result.append(")");
        }
        result.append(")");
        return result.toString();
    }

    static String oclQuoteString(String s) {
        return s.replace("'", "\\'").replace("\\", "\\\\");
    }

    static boolean isString(ETypedElement element) {
        EClassifier type = element.getEType();
        return type != null && type.getInstanceClass() == String.class;
    }
}

