/**
 * Copyright (c) 2013 CEA LIST.
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 * 
 *  SPDX-License-Identifier: EPL-2.0
 * 
 *  Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxis.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattablestyle.impl.StyledElementImpl;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.OperationAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.OperationIdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.OperationIdTreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.OperationLabelProviderConfiguration;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Operation Id Tree Item Axis</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxis.impl.OperationIdTreeItemAxisImpl#getManager <em>Manager</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxis.impl.OperationIdTreeItemAxisImpl#getAlias <em>Alias</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxis.impl.OperationIdTreeItemAxisImpl#getParent <em>Parent</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxis.impl.OperationIdTreeItemAxisImpl#isExpanded <em>Expanded</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxis.impl.OperationIdTreeItemAxisImpl#getChildren <em>Children</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxis.impl.OperationIdTreeItemAxisImpl#getElement <em>Element</em>}</li>
 *   <li>{@link org.eclipse.papyrus.infra.nattable.model.cdo.nattable.nattableaxis.impl.OperationIdTreeItemAxisImpl#getLocalLabelConfiguration <em>Local Label Configuration</em>}</li>
 * </ul>
 *
 * @generated
 */
public class OperationIdTreeItemAxisImpl extends StyledElementImpl implements OperationIdTreeItemAxis {
	/**
	 * The default value of the '{@link #getAlias() <em>Alias</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAlias()
	 * @generated
	 * @ordered
	 */
	protected static final String ALIAS_EDEFAULT = null;

	/**
	 * The default value of the '{@link #isExpanded() <em>Expanded</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isExpanded()
	 * @generated
	 * @ordered
	 */
	protected static final boolean EXPANDED_EDEFAULT = false;

	/**
	 * The default value of the '{@link #getElement() <em>Element</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getElement()
	 * @generated
	 * @ordered
	 */
	protected static final String ELEMENT_EDEFAULT = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OperationIdTreeItemAxisImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return NattableaxisPackage.Literals.OPERATION_ID_TREE_ITEM_AXIS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AxisManagerRepresentation getManager() {
		return (AxisManagerRepresentation)eDynamicGet(NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__MANAGER - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.IAXIS__MANAGER, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AxisManagerRepresentation basicGetManager() {
		return (AxisManagerRepresentation)eDynamicGet(NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__MANAGER - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.IAXIS__MANAGER, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setManager(AxisManagerRepresentation newManager) {
		eDynamicSet(NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__MANAGER - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.IAXIS__MANAGER, newManager);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getAlias() {
		return (String)eDynamicGet(NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__ALIAS - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.IAXIS__ALIAS, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAlias(String newAlias) {
		eDynamicSet(NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__ALIAS - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.IAXIS__ALIAS, newAlias);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ITreeItemAxis getParent() {
		return (ITreeItemAxis)eDynamicGet(NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__PARENT - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.ITREE_ITEM_AXIS__PARENT, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ITreeItemAxis basicGetParent() {
		return (ITreeItemAxis)eDynamicGet(NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__PARENT - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.ITREE_ITEM_AXIS__PARENT, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetParent(ITreeItemAxis newParent, NotificationChain msgs) {
		msgs = eDynamicInverseAdd((InternalEObject)newParent, NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__PARENT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParent(ITreeItemAxis newParent) {
		eDynamicSet(NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__PARENT - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.ITREE_ITEM_AXIS__PARENT, newParent);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isExpanded() {
		return (Boolean)eDynamicGet(NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__EXPANDED - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.ITREE_ITEM_AXIS__EXPANDED, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExpanded(boolean newExpanded) {
		eDynamicSet(NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__EXPANDED - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.ITREE_ITEM_AXIS__EXPANDED, newExpanded);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	public EList<ITreeItemAxis> getChildren() {
		return (EList<ITreeItemAxis>)eDynamicGet(NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__CHILDREN - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.ITREE_ITEM_AXIS__CHILDREN, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getElement() {
		return (String)eDynamicGet(NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__ELEMENT - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.ID_AXIS__ELEMENT, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setElement(String newElement) {
		eDynamicSet(NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__ELEMENT - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.ID_AXIS__ELEMENT, newElement);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OperationLabelProviderConfiguration getLocalLabelConfiguration() {
		return (OperationLabelProviderConfiguration)eDynamicGet(NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__LOCAL_LABEL_CONFIGURATION - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.OPERATION_AXIS__LOCAL_LABEL_CONFIGURATION, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLocalLabelConfiguration(OperationLabelProviderConfiguration newLocalLabelConfiguration, NotificationChain msgs) {
		msgs = eDynamicInverseAdd((InternalEObject)newLocalLabelConfiguration, NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__LOCAL_LABEL_CONFIGURATION, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLocalLabelConfiguration(OperationLabelProviderConfiguration newLocalLabelConfiguration) {
		eDynamicSet(NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__LOCAL_LABEL_CONFIGURATION - ESTATIC_FEATURE_COUNT, NattableaxisPackage.Literals.OPERATION_AXIS__LOCAL_LABEL_CONFIGURATION, newLocalLabelConfiguration);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__PARENT:
				ITreeItemAxis parent = basicGetParent();
				if (parent != null)
					msgs = ((InternalEObject)parent).eInverseRemove(this, NattableaxisPackage.ITREE_ITEM_AXIS__CHILDREN, ITreeItemAxis.class, msgs);
				return basicSetParent((ITreeItemAxis)otherEnd, msgs);
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__CHILDREN:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getChildren()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__PARENT:
				return basicSetParent(null, msgs);
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__CHILDREN:
				return ((InternalEList<?>)getChildren()).basicRemove(otherEnd, msgs);
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__LOCAL_LABEL_CONFIGURATION:
				return basicSetLocalLabelConfiguration(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__MANAGER:
				if (resolve) return getManager();
				return basicGetManager();
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__ALIAS:
				return getAlias();
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__PARENT:
				if (resolve) return getParent();
				return basicGetParent();
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__EXPANDED:
				return isExpanded();
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__CHILDREN:
				return getChildren();
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__ELEMENT:
				return getElement();
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__LOCAL_LABEL_CONFIGURATION:
				return getLocalLabelConfiguration();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__MANAGER:
				setManager((AxisManagerRepresentation)newValue);
				return;
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__ALIAS:
				setAlias((String)newValue);
				return;
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__PARENT:
				setParent((ITreeItemAxis)newValue);
				return;
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__EXPANDED:
				setExpanded((Boolean)newValue);
				return;
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__CHILDREN:
				getChildren().clear();
				getChildren().addAll((Collection<? extends ITreeItemAxis>)newValue);
				return;
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__ELEMENT:
				setElement((String)newValue);
				return;
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__LOCAL_LABEL_CONFIGURATION:
				setLocalLabelConfiguration((OperationLabelProviderConfiguration)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__MANAGER:
				setManager((AxisManagerRepresentation)null);
				return;
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__ALIAS:
				setAlias(ALIAS_EDEFAULT);
				return;
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__PARENT:
				setParent((ITreeItemAxis)null);
				return;
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__EXPANDED:
				setExpanded(EXPANDED_EDEFAULT);
				return;
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__CHILDREN:
				getChildren().clear();
				return;
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__ELEMENT:
				setElement(ELEMENT_EDEFAULT);
				return;
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__LOCAL_LABEL_CONFIGURATION:
				setLocalLabelConfiguration((OperationLabelProviderConfiguration)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__MANAGER:
				return basicGetManager() != null;
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__ALIAS:
				return ALIAS_EDEFAULT == null ? getAlias() != null : !ALIAS_EDEFAULT.equals(getAlias());
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__PARENT:
				return basicGetParent() != null;
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__EXPANDED:
				return isExpanded() != EXPANDED_EDEFAULT;
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__CHILDREN:
				return !getChildren().isEmpty();
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__ELEMENT:
				return ELEMENT_EDEFAULT == null ? getElement() != null : !ELEMENT_EDEFAULT.equals(getElement());
			case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__LOCAL_LABEL_CONFIGURATION:
				return getLocalLabelConfiguration() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == IdAxis.class) {
			switch (derivedFeatureID) {
				case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__ELEMENT: return NattableaxisPackage.ID_AXIS__ELEMENT;
				default: return -1;
			}
		}
		if (baseClass == OperationAxis.class) {
			switch (derivedFeatureID) {
				case NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__LOCAL_LABEL_CONFIGURATION: return NattableaxisPackage.OPERATION_AXIS__LOCAL_LABEL_CONFIGURATION;
				default: return -1;
			}
		}
		if (baseClass == OperationIdAxis.class) {
			switch (derivedFeatureID) {
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == IdAxis.class) {
			switch (baseFeatureID) {
				case NattableaxisPackage.ID_AXIS__ELEMENT: return NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__ELEMENT;
				default: return -1;
			}
		}
		if (baseClass == OperationAxis.class) {
			switch (baseFeatureID) {
				case NattableaxisPackage.OPERATION_AXIS__LOCAL_LABEL_CONFIGURATION: return NattableaxisPackage.OPERATION_ID_TREE_ITEM_AXIS__LOCAL_LABEL_CONFIGURATION;
				default: return -1;
			}
		}
		if (baseClass == OperationIdAxis.class) {
			switch (baseFeatureID) {
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

} //OperationIdTreeItemAxisImpl
