/*
 * Copyright (c) 2005, 2018 IBM Corporation, CEA, and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *   IBM - initial API and implementation
 *   Kenn Hussey (CEA) - 327039, 418466, 451350, 485756
 *   Kenn Hussey - 535301
 *
 */
package org.eclipse.uml2.uml.cdo.internal.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.StringExpression;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Call Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.CallEventImpl#getOperation <em>Operation</em>}</li>
 * </ul>
 *
 * @generated
 */
public class CallEventImpl
		extends MessageEventImpl
		implements CallEvent {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CallEventImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return UMLPackage.Literals.CALL_EVENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Operation getOperation() {
		return (Operation) eDynamicGet(UMLPackage.CALL_EVENT__OPERATION - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.CALL_EVENT__OPERATION, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Operation basicGetOperation() {
		return (Operation) eDynamicGet(UMLPackage.CALL_EVENT__OPERATION - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.CALL_EVENT__OPERATION, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperation(Operation newOperation) {
		eDynamicSet(UMLPackage.CALL_EVENT__OPERATION - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.CALL_EVENT__OPERATION, newOperation);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case UMLPackage.CALL_EVENT__EANNOTATIONS:
			return getEAnnotations();
		case UMLPackage.CALL_EVENT__OWNED_COMMENT:
			return getOwnedComments();
		case UMLPackage.CALL_EVENT__OWNED_ELEMENT:
			return getOwnedElements();
		case UMLPackage.CALL_EVENT__OWNER:
			if (resolve)
				return getOwner();
			return basicGetOwner();
		case UMLPackage.CALL_EVENT__CLIENT_DEPENDENCY:
			return getClientDependencies();
		case UMLPackage.CALL_EVENT__NAME:
			return getName();
		case UMLPackage.CALL_EVENT__NAME_EXPRESSION:
			if (resolve)
				return getNameExpression();
			return basicGetNameExpression();
		case UMLPackage.CALL_EVENT__NAMESPACE:
			if (resolve)
				return getNamespace();
			return basicGetNamespace();
		case UMLPackage.CALL_EVENT__QUALIFIED_NAME:
			return getQualifiedName();
		case UMLPackage.CALL_EVENT__VISIBILITY:
			return getVisibility();
		case UMLPackage.CALL_EVENT__OWNING_TEMPLATE_PARAMETER:
			if (resolve)
				return getOwningTemplateParameter();
			return basicGetOwningTemplateParameter();
		case UMLPackage.CALL_EVENT__TEMPLATE_PARAMETER:
			if (resolve)
				return getTemplateParameter();
			return basicGetTemplateParameter();
		case UMLPackage.CALL_EVENT__OPERATION:
			if (resolve)
				return getOperation();
			return basicGetOperation();
		}
		return eDynamicGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case UMLPackage.CALL_EVENT__EANNOTATIONS:
			getEAnnotations().clear();
			getEAnnotations().addAll((Collection<? extends EAnnotation>) newValue);
			return;
		case UMLPackage.CALL_EVENT__OWNED_COMMENT:
			getOwnedComments().clear();
			getOwnedComments().addAll((Collection<? extends Comment>) newValue);
			return;
		case UMLPackage.CALL_EVENT__NAME:
			setName((String) newValue);
			return;
		case UMLPackage.CALL_EVENT__NAME_EXPRESSION:
			setNameExpression((StringExpression) newValue);
			return;
		case UMLPackage.CALL_EVENT__VISIBILITY:
			setVisibility((VisibilityKind) newValue);
			return;
		case UMLPackage.CALL_EVENT__OWNING_TEMPLATE_PARAMETER:
			setOwningTemplateParameter((TemplateParameter) newValue);
			return;
		case UMLPackage.CALL_EVENT__TEMPLATE_PARAMETER:
			setTemplateParameter((TemplateParameter) newValue);
			return;
		case UMLPackage.CALL_EVENT__OPERATION:
			setOperation((Operation) newValue);
			return;
		}
		eDynamicSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case UMLPackage.CALL_EVENT__EANNOTATIONS:
			getEAnnotations().clear();
			return;
		case UMLPackage.CALL_EVENT__OWNED_COMMENT:
			getOwnedComments().clear();
			return;
		case UMLPackage.CALL_EVENT__NAME:
			unsetName();
			return;
		case UMLPackage.CALL_EVENT__NAME_EXPRESSION:
			setNameExpression((StringExpression) null);
			return;
		case UMLPackage.CALL_EVENT__VISIBILITY:
			unsetVisibility();
			return;
		case UMLPackage.CALL_EVENT__OWNING_TEMPLATE_PARAMETER:
			setOwningTemplateParameter((TemplateParameter) null);
			return;
		case UMLPackage.CALL_EVENT__TEMPLATE_PARAMETER:
			setTemplateParameter((TemplateParameter) null);
			return;
		case UMLPackage.CALL_EVENT__OPERATION:
			setOperation((Operation) null);
			return;
		}
		eDynamicUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case UMLPackage.CALL_EVENT__EANNOTATIONS:
			return !getEAnnotations().isEmpty();
		case UMLPackage.CALL_EVENT__OWNED_COMMENT:
			return !getOwnedComments().isEmpty();
		case UMLPackage.CALL_EVENT__OWNED_ELEMENT:
			return isSetOwnedElements();
		case UMLPackage.CALL_EVENT__OWNER:
			return isSetOwner();
		case UMLPackage.CALL_EVENT__CLIENT_DEPENDENCY:
			return !getClientDependencies().isEmpty();
		case UMLPackage.CALL_EVENT__NAME:
			return isSetName();
		case UMLPackage.CALL_EVENT__NAME_EXPRESSION:
			return basicGetNameExpression() != null;
		case UMLPackage.CALL_EVENT__NAMESPACE:
			return isSetNamespace();
		case UMLPackage.CALL_EVENT__QUALIFIED_NAME:
			return QUALIFIED_NAME_EDEFAULT == null ? getQualifiedName() != null : !QUALIFIED_NAME_EDEFAULT.equals(getQualifiedName());
		case UMLPackage.CALL_EVENT__VISIBILITY:
			return isSetVisibility();
		case UMLPackage.CALL_EVENT__OWNING_TEMPLATE_PARAMETER:
			return basicGetOwningTemplateParameter() != null;
		case UMLPackage.CALL_EVENT__TEMPLATE_PARAMETER:
			return basicGetTemplateParameter() != null;
		case UMLPackage.CALL_EVENT__OPERATION:
			return basicGetOperation() != null;
		}
		return eDynamicIsSet(featureID);
	}

} //CallEventImpl
