/*
 * Copyright (c) 2005, 2018 IBM Corporation, CEA, and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *   IBM - initial API and implementation
 *   Kenn Hussey - 286329, 323181, 535301
 *   Kenn Hussey (CEA) - 327039, 351774, 418466, 451350, 485756
 *
 */
package org.eclipse.uml2.uml.cdo.internal.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.DiagnosticChain;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ExtensionPoint;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StringExpression;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UseCase;
import org.eclipse.uml2.uml.VisibilityKind;

import org.eclipse.uml2.uml.internal.operations.ExtensionPointOperations;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Extension Point</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.ExtensionPointImpl#getNamespace <em>Namespace</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.ExtensionPointImpl#getUseCase <em>Use Case</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ExtensionPointImpl
		extends RedefinableElementImpl
		implements ExtensionPoint {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExtensionPointImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return UMLPackage.Literals.EXTENSION_POINT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Namespace getNamespace() {
		Namespace namespace = basicGetNamespace();
		return namespace != null && namespace.eIsProxy() ? (Namespace) eResolveProxy((InternalEObject) namespace) : namespace;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Namespace basicGetNamespace() {
		UseCase useCase = basicGetUseCase();
		if (useCase != null) {
			return useCase;
		}
		return super.basicGetNamespace();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UseCase getUseCase() {
		return (UseCase) eDynamicGet(UMLPackage.EXTENSION_POINT__USE_CASE - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.EXTENSION_POINT__USE_CASE, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UseCase basicGetUseCase() {
		return (UseCase) eDynamicGet(UMLPackage.EXTENSION_POINT__USE_CASE - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.EXTENSION_POINT__USE_CASE, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetUseCase(UseCase newUseCase,
			NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject) newUseCase, UMLPackage.EXTENSION_POINT__USE_CASE, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUseCase(UseCase newUseCase) {
		eDynamicSet(UMLPackage.EXTENSION_POINT__USE_CASE - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.EXTENSION_POINT__USE_CASE, newUseCase);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateMustHaveName(DiagnosticChain diagnostics,
			Map<Object, Object> context) {
		return ExtensionPointOperations.validateMustHaveName(this, diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case UMLPackage.EXTENSION_POINT__EANNOTATIONS:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getEAnnotations()).basicAdd(otherEnd, msgs);
		case UMLPackage.EXTENSION_POINT__USE_CASE:
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			return basicSetUseCase((UseCase) otherEnd, msgs);
		}
		return eDynamicInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case UMLPackage.EXTENSION_POINT__EANNOTATIONS:
			return ((InternalEList<?>) getEAnnotations()).basicRemove(otherEnd, msgs);
		case UMLPackage.EXTENSION_POINT__OWNED_COMMENT:
			return ((InternalEList<?>) getOwnedComments()).basicRemove(otherEnd, msgs);
		case UMLPackage.EXTENSION_POINT__NAME_EXPRESSION:
			return basicSetNameExpression(null, msgs);
		case UMLPackage.EXTENSION_POINT__USE_CASE:
			return basicSetUseCase(null, msgs);
		}
		return eDynamicInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(
			NotificationChain msgs) {
		switch (eContainerFeatureID()) {
		case UMLPackage.EXTENSION_POINT__USE_CASE:
			return eInternalContainer().eInverseRemove(this, UMLPackage.USE_CASE__EXTENSION_POINT, UseCase.class, msgs);
		}
		return eDynamicBasicRemoveFromContainer(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case UMLPackage.EXTENSION_POINT__EANNOTATIONS:
			return getEAnnotations();
		case UMLPackage.EXTENSION_POINT__OWNED_COMMENT:
			return getOwnedComments();
		case UMLPackage.EXTENSION_POINT__OWNED_ELEMENT:
			return getOwnedElements();
		case UMLPackage.EXTENSION_POINT__OWNER:
			if (resolve)
				return getOwner();
			return basicGetOwner();
		case UMLPackage.EXTENSION_POINT__CLIENT_DEPENDENCY:
			return getClientDependencies();
		case UMLPackage.EXTENSION_POINT__NAME:
			return getName();
		case UMLPackage.EXTENSION_POINT__NAME_EXPRESSION:
			if (resolve)
				return getNameExpression();
			return basicGetNameExpression();
		case UMLPackage.EXTENSION_POINT__NAMESPACE:
			if (resolve)
				return getNamespace();
			return basicGetNamespace();
		case UMLPackage.EXTENSION_POINT__QUALIFIED_NAME:
			return getQualifiedName();
		case UMLPackage.EXTENSION_POINT__VISIBILITY:
			return getVisibility();
		case UMLPackage.EXTENSION_POINT__IS_LEAF:
			return isLeaf();
		case UMLPackage.EXTENSION_POINT__REDEFINED_ELEMENT:
			return getRedefinedElements();
		case UMLPackage.EXTENSION_POINT__REDEFINITION_CONTEXT:
			return getRedefinitionContexts();
		case UMLPackage.EXTENSION_POINT__USE_CASE:
			if (resolve)
				return getUseCase();
			return basicGetUseCase();
		}
		return eDynamicGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case UMLPackage.EXTENSION_POINT__EANNOTATIONS:
			getEAnnotations().clear();
			getEAnnotations().addAll((Collection<? extends EAnnotation>) newValue);
			return;
		case UMLPackage.EXTENSION_POINT__OWNED_COMMENT:
			getOwnedComments().clear();
			getOwnedComments().addAll((Collection<? extends Comment>) newValue);
			return;
		case UMLPackage.EXTENSION_POINT__NAME:
			setName((String) newValue);
			return;
		case UMLPackage.EXTENSION_POINT__NAME_EXPRESSION:
			setNameExpression((StringExpression) newValue);
			return;
		case UMLPackage.EXTENSION_POINT__VISIBILITY:
			setVisibility((VisibilityKind) newValue);
			return;
		case UMLPackage.EXTENSION_POINT__IS_LEAF:
			setIsLeaf((Boolean) newValue);
			return;
		case UMLPackage.EXTENSION_POINT__USE_CASE:
			setUseCase((UseCase) newValue);
			return;
		}
		eDynamicSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case UMLPackage.EXTENSION_POINT__EANNOTATIONS:
			getEAnnotations().clear();
			return;
		case UMLPackage.EXTENSION_POINT__OWNED_COMMENT:
			getOwnedComments().clear();
			return;
		case UMLPackage.EXTENSION_POINT__NAME:
			unsetName();
			return;
		case UMLPackage.EXTENSION_POINT__NAME_EXPRESSION:
			setNameExpression((StringExpression) null);
			return;
		case UMLPackage.EXTENSION_POINT__VISIBILITY:
			unsetVisibility();
			return;
		case UMLPackage.EXTENSION_POINT__IS_LEAF:
			setIsLeaf(IS_LEAF_EDEFAULT);
			return;
		case UMLPackage.EXTENSION_POINT__USE_CASE:
			setUseCase((UseCase) null);
			return;
		}
		eDynamicUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case UMLPackage.EXTENSION_POINT__EANNOTATIONS:
			return !getEAnnotations().isEmpty();
		case UMLPackage.EXTENSION_POINT__OWNED_COMMENT:
			return !getOwnedComments().isEmpty();
		case UMLPackage.EXTENSION_POINT__OWNED_ELEMENT:
			return isSetOwnedElements();
		case UMLPackage.EXTENSION_POINT__OWNER:
			return isSetOwner();
		case UMLPackage.EXTENSION_POINT__CLIENT_DEPENDENCY:
			return !getClientDependencies().isEmpty();
		case UMLPackage.EXTENSION_POINT__NAME:
			return isSetName();
		case UMLPackage.EXTENSION_POINT__NAME_EXPRESSION:
			return basicGetNameExpression() != null;
		case UMLPackage.EXTENSION_POINT__NAMESPACE:
			return isSetNamespace();
		case UMLPackage.EXTENSION_POINT__QUALIFIED_NAME:
			return QUALIFIED_NAME_EDEFAULT == null ? getQualifiedName() != null : !QUALIFIED_NAME_EDEFAULT.equals(getQualifiedName());
		case UMLPackage.EXTENSION_POINT__VISIBILITY:
			return isSetVisibility();
		case UMLPackage.EXTENSION_POINT__IS_LEAF:
			return isLeaf() != IS_LEAF_EDEFAULT;
		case UMLPackage.EXTENSION_POINT__REDEFINED_ELEMENT:
			return isSetRedefinedElements();
		case UMLPackage.EXTENSION_POINT__REDEFINITION_CONTEXT:
			return isSetRedefinitionContexts();
		case UMLPackage.EXTENSION_POINT__USE_CASE:
			return basicGetUseCase() != null;
		}
		return eDynamicIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	@SuppressWarnings("unchecked")
	public Object eInvoke(int operationID, EList<?> arguments)
			throws InvocationTargetException {
		switch (operationID) {
		case UMLPackage.EXTENSION_POINT___GET_EANNOTATION__STRING:
			return getEAnnotation((String) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___VALIDATE_HAS_OWNER__DIAGNOSTICCHAIN_MAP:
			return validateHasOwner((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.EXTENSION_POINT___VALIDATE_NOT_OWN_SELF__DIAGNOSTICCHAIN_MAP:
			return validateNotOwnSelf((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.EXTENSION_POINT___ADD_KEYWORD__STRING:
			return addKeyword((String) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___APPLY_STEREOTYPE__STEREOTYPE:
			return applyStereotype((Stereotype) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___CREATE_EANNOTATION__STRING:
			return createEAnnotation((String) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___DESTROY:
			destroy();
			return null;
		case UMLPackage.EXTENSION_POINT___GET_KEYWORDS:
			return getKeywords();
		case UMLPackage.EXTENSION_POINT___GET_APPLICABLE_STEREOTYPE__STRING:
			return getApplicableStereotype((String) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___GET_APPLICABLE_STEREOTYPES:
			return getApplicableStereotypes();
		case UMLPackage.EXTENSION_POINT___GET_APPLIED_STEREOTYPE__STRING:
			return getAppliedStereotype((String) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___GET_APPLIED_STEREOTYPES:
			return getAppliedStereotypes();
		case UMLPackage.EXTENSION_POINT___GET_APPLIED_SUBSTEREOTYPE__STEREOTYPE_STRING:
			return getAppliedSubstereotype((Stereotype) arguments.get(0), (String) arguments.get(1));
		case UMLPackage.EXTENSION_POINT___GET_APPLIED_SUBSTEREOTYPES__STEREOTYPE:
			return getAppliedSubstereotypes((Stereotype) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___GET_MODEL:
			return getModel();
		case UMLPackage.EXTENSION_POINT___GET_NEAREST_PACKAGE:
			return getNearestPackage();
		case UMLPackage.EXTENSION_POINT___GET_RELATIONSHIPS:
			return getRelationships();
		case UMLPackage.EXTENSION_POINT___GET_RELATIONSHIPS__ECLASS:
			return getRelationships((EClass) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___GET_REQUIRED_STEREOTYPE__STRING:
			return getRequiredStereotype((String) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___GET_REQUIRED_STEREOTYPES:
			return getRequiredStereotypes();
		case UMLPackage.EXTENSION_POINT___GET_SOURCE_DIRECTED_RELATIONSHIPS:
			return getSourceDirectedRelationships();
		case UMLPackage.EXTENSION_POINT___GET_SOURCE_DIRECTED_RELATIONSHIPS__ECLASS:
			return getSourceDirectedRelationships((EClass) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___GET_STEREOTYPE_APPLICATION__STEREOTYPE:
			return getStereotypeApplication((Stereotype) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___GET_STEREOTYPE_APPLICATIONS:
			return getStereotypeApplications();
		case UMLPackage.EXTENSION_POINT___GET_TARGET_DIRECTED_RELATIONSHIPS:
			return getTargetDirectedRelationships();
		case UMLPackage.EXTENSION_POINT___GET_TARGET_DIRECTED_RELATIONSHIPS__ECLASS:
			return getTargetDirectedRelationships((EClass) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___GET_VALUE__STEREOTYPE_STRING:
			return getValue((Stereotype) arguments.get(0), (String) arguments.get(1));
		case UMLPackage.EXTENSION_POINT___HAS_KEYWORD__STRING:
			return hasKeyword((String) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___HAS_VALUE__STEREOTYPE_STRING:
			return hasValue((Stereotype) arguments.get(0), (String) arguments.get(1));
		case UMLPackage.EXTENSION_POINT___IS_STEREOTYPE_APPLICABLE__STEREOTYPE:
			return isStereotypeApplicable((Stereotype) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___IS_STEREOTYPE_APPLIED__STEREOTYPE:
			return isStereotypeApplied((Stereotype) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___IS_STEREOTYPE_REQUIRED__STEREOTYPE:
			return isStereotypeRequired((Stereotype) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___REMOVE_KEYWORD__STRING:
			return removeKeyword((String) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___SET_VALUE__STEREOTYPE_STRING_OBJECT:
			setValue((Stereotype) arguments.get(0), (String) arguments.get(1), arguments.get(2));
			return null;
		case UMLPackage.EXTENSION_POINT___UNAPPLY_STEREOTYPE__STEREOTYPE:
			return unapplyStereotype((Stereotype) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___ALL_OWNED_ELEMENTS:
			return allOwnedElements();
		case UMLPackage.EXTENSION_POINT___MUST_BE_OWNED:
			return mustBeOwned();
		case UMLPackage.EXTENSION_POINT___VALIDATE_VISIBILITY_NEEDS_OWNERSHIP__DIAGNOSTICCHAIN_MAP:
			return validateVisibilityNeedsOwnership((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.EXTENSION_POINT___VALIDATE_HAS_QUALIFIED_NAME__DIAGNOSTICCHAIN_MAP:
			return validateHasQualifiedName((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.EXTENSION_POINT___VALIDATE_HAS_NO_QUALIFIED_NAME__DIAGNOSTICCHAIN_MAP:
			return validateHasNoQualifiedName((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.EXTENSION_POINT___CREATE_DEPENDENCY__NAMEDELEMENT:
			return createDependency((NamedElement) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___CREATE_USAGE__NAMEDELEMENT:
			return createUsage((NamedElement) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___GET_LABEL:
			return getLabel();
		case UMLPackage.EXTENSION_POINT___GET_LABEL__BOOLEAN:
			return getLabel((Boolean) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___GET_NAMESPACE:
			return getNamespace();
		case UMLPackage.EXTENSION_POINT___ALL_NAMESPACES:
			return allNamespaces();
		case UMLPackage.EXTENSION_POINT___ALL_OWNING_PACKAGES:
			return allOwningPackages();
		case UMLPackage.EXTENSION_POINT___IS_DISTINGUISHABLE_FROM__NAMEDELEMENT_NAMESPACE:
			return isDistinguishableFrom((NamedElement) arguments.get(0), (Namespace) arguments.get(1));
		case UMLPackage.EXTENSION_POINT___GET_QUALIFIED_NAME:
			return getQualifiedName();
		case UMLPackage.EXTENSION_POINT___SEPARATOR:
			return separator();
		case UMLPackage.EXTENSION_POINT___GET_CLIENT_DEPENDENCIES:
			return getClientDependencies();
		case UMLPackage.EXTENSION_POINT___VALIDATE_REDEFINITION_CONSISTENT__DIAGNOSTICCHAIN_MAP:
			return validateRedefinitionConsistent((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.EXTENSION_POINT___VALIDATE_NON_LEAF_REDEFINITION__DIAGNOSTICCHAIN_MAP:
			return validateNonLeafRedefinition((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.EXTENSION_POINT___VALIDATE_REDEFINITION_CONTEXT_VALID__DIAGNOSTICCHAIN_MAP:
			return validateRedefinitionContextValid((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		case UMLPackage.EXTENSION_POINT___IS_CONSISTENT_WITH__REDEFINABLEELEMENT:
			return isConsistentWith((RedefinableElement) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___IS_REDEFINITION_CONTEXT_VALID__REDEFINABLEELEMENT:
			return isRedefinitionContextValid((RedefinableElement) arguments.get(0));
		case UMLPackage.EXTENSION_POINT___VALIDATE_MUST_HAVE_NAME__DIAGNOSTICCHAIN_MAP:
			return validateMustHaveName((DiagnosticChain) arguments.get(0), (Map<Object, Object>) arguments.get(1));
		}
		return eDynamicInvoke(operationID, arguments);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSetNamespace() {
		return super.isSetNamespace()
				|| eIsSet(UMLPackage.EXTENSION_POINT__USE_CASE);
	}

} //ExtensionPointImpl
