/*
 * Copyright (c) 2005, 2018 IBM Corporation, CEA, and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *   IBM - initial API and implementation
 *   Kenn Hussey (CEA) - 327039, 451350, 485756
 *   Kenn Hussey - 519572, 535301
 *
 */
package org.eclipse.uml2.uml.cdo.internal.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.UMLPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Image</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.ImageImpl#getContent <em>Content</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.ImageImpl#getFormat <em>Format</em>}</li>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.ImageImpl#getLocation <em>Location</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ImageImpl
		extends ElementImpl
		implements Image {

	/**
	 * The default value of the '{@link #getContent() <em>Content</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContent()
	 * @generated
	 * @ordered
	 */
	protected static final String CONTENT_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getFormat() <em>Format</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFormat()
	 * @generated
	 * @ordered
	 */
	protected static final String FORMAT_EDEFAULT = null;

	/**
	 * The default value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected static final String LOCATION_EDEFAULT = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImageImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return UMLPackage.Literals.IMAGE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getContent() {
		return (String) eDynamicGet(UMLPackage.IMAGE__CONTENT - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.IMAGE__CONTENT, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setContent(String newContent) {
		eDynamicSet(UMLPackage.IMAGE__CONTENT - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.IMAGE__CONTENT, newContent);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetContent() {
		eDynamicUnset(UMLPackage.IMAGE__CONTENT - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.IMAGE__CONTENT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetContent() {
		return eDynamicIsSet(UMLPackage.IMAGE__CONTENT - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.IMAGE__CONTENT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLocation() {
		return (String) eDynamicGet(UMLPackage.IMAGE__LOCATION - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.IMAGE__LOCATION, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLocation(String newLocation) {
		eDynamicSet(UMLPackage.IMAGE__LOCATION - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.IMAGE__LOCATION, newLocation);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetLocation() {
		eDynamicUnset(UMLPackage.IMAGE__LOCATION - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.IMAGE__LOCATION);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetLocation() {
		return eDynamicIsSet(UMLPackage.IMAGE__LOCATION - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.IMAGE__LOCATION);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getFormat() {
		return (String) eDynamicGet(UMLPackage.IMAGE__FORMAT - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.IMAGE__FORMAT, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFormat(String newFormat) {
		eDynamicSet(UMLPackage.IMAGE__FORMAT - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.IMAGE__FORMAT, newFormat);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetFormat() {
		eDynamicUnset(UMLPackage.IMAGE__FORMAT - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.IMAGE__FORMAT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetFormat() {
		return eDynamicIsSet(UMLPackage.IMAGE__FORMAT - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.IMAGE__FORMAT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case UMLPackage.IMAGE__EANNOTATIONS:
			return getEAnnotations();
		case UMLPackage.IMAGE__OWNED_COMMENT:
			return getOwnedComments();
		case UMLPackage.IMAGE__OWNED_ELEMENT:
			return getOwnedElements();
		case UMLPackage.IMAGE__OWNER:
			if (resolve)
				return getOwner();
			return basicGetOwner();
		case UMLPackage.IMAGE__CONTENT:
			return getContent();
		case UMLPackage.IMAGE__FORMAT:
			return getFormat();
		case UMLPackage.IMAGE__LOCATION:
			return getLocation();
		}
		return eDynamicGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case UMLPackage.IMAGE__EANNOTATIONS:
			getEAnnotations().clear();
			getEAnnotations().addAll((Collection<? extends EAnnotation>) newValue);
			return;
		case UMLPackage.IMAGE__OWNED_COMMENT:
			getOwnedComments().clear();
			getOwnedComments().addAll((Collection<? extends Comment>) newValue);
			return;
		case UMLPackage.IMAGE__CONTENT:
			setContent((String) newValue);
			return;
		case UMLPackage.IMAGE__FORMAT:
			setFormat((String) newValue);
			return;
		case UMLPackage.IMAGE__LOCATION:
			setLocation((String) newValue);
			return;
		}
		eDynamicSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case UMLPackage.IMAGE__EANNOTATIONS:
			getEAnnotations().clear();
			return;
		case UMLPackage.IMAGE__OWNED_COMMENT:
			getOwnedComments().clear();
			return;
		case UMLPackage.IMAGE__CONTENT:
			unsetContent();
			return;
		case UMLPackage.IMAGE__FORMAT:
			unsetFormat();
			return;
		case UMLPackage.IMAGE__LOCATION:
			unsetLocation();
			return;
		}
		eDynamicUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case UMLPackage.IMAGE__EANNOTATIONS:
			return !getEAnnotations().isEmpty();
		case UMLPackage.IMAGE__OWNED_COMMENT:
			return !getOwnedComments().isEmpty();
		case UMLPackage.IMAGE__OWNED_ELEMENT:
			return isSetOwnedElements();
		case UMLPackage.IMAGE__OWNER:
			return isSetOwner();
		case UMLPackage.IMAGE__CONTENT:
			return isSetContent();
		case UMLPackage.IMAGE__FORMAT:
			return isSetFormat();
		case UMLPackage.IMAGE__LOCATION:
			return isSetLocation();
		}
		return eDynamicIsSet(featureID);
	}

} //ImageImpl
