/*
 * Copyright (c) 2005, 2018 IBM Corporation, CEA, and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *   IBM - initial API and implementation
 *   Kenn Hussey (CEA) - 327039, 418466, 451350, 485756
 *   Kenn Hussey - 535301
 *
 */
package org.eclipse.uml2.uml.cdo.internal.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.StringExpression;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Signal Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.uml2.uml.cdo.internal.impl.SignalEventImpl#getSignal <em>Signal</em>}</li>
 * </ul>
 *
 * @generated
 */
public class SignalEventImpl
		extends MessageEventImpl
		implements SignalEvent {

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SignalEventImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return UMLPackage.Literals.SIGNAL_EVENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Signal getSignal() {
		return (Signal) eDynamicGet(UMLPackage.SIGNAL_EVENT__SIGNAL - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.SIGNAL_EVENT__SIGNAL, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Signal basicGetSignal() {
		return (Signal) eDynamicGet(UMLPackage.SIGNAL_EVENT__SIGNAL - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.SIGNAL_EVENT__SIGNAL, false, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSignal(Signal newSignal) {
		eDynamicSet(UMLPackage.SIGNAL_EVENT__SIGNAL - ESTATIC_FEATURE_COUNT, UMLPackage.Literals.SIGNAL_EVENT__SIGNAL, newSignal);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case UMLPackage.SIGNAL_EVENT__EANNOTATIONS:
			return getEAnnotations();
		case UMLPackage.SIGNAL_EVENT__OWNED_COMMENT:
			return getOwnedComments();
		case UMLPackage.SIGNAL_EVENT__OWNED_ELEMENT:
			return getOwnedElements();
		case UMLPackage.SIGNAL_EVENT__OWNER:
			if (resolve)
				return getOwner();
			return basicGetOwner();
		case UMLPackage.SIGNAL_EVENT__CLIENT_DEPENDENCY:
			return getClientDependencies();
		case UMLPackage.SIGNAL_EVENT__NAME:
			return getName();
		case UMLPackage.SIGNAL_EVENT__NAME_EXPRESSION:
			if (resolve)
				return getNameExpression();
			return basicGetNameExpression();
		case UMLPackage.SIGNAL_EVENT__NAMESPACE:
			if (resolve)
				return getNamespace();
			return basicGetNamespace();
		case UMLPackage.SIGNAL_EVENT__QUALIFIED_NAME:
			return getQualifiedName();
		case UMLPackage.SIGNAL_EVENT__VISIBILITY:
			return getVisibility();
		case UMLPackage.SIGNAL_EVENT__OWNING_TEMPLATE_PARAMETER:
			if (resolve)
				return getOwningTemplateParameter();
			return basicGetOwningTemplateParameter();
		case UMLPackage.SIGNAL_EVENT__TEMPLATE_PARAMETER:
			if (resolve)
				return getTemplateParameter();
			return basicGetTemplateParameter();
		case UMLPackage.SIGNAL_EVENT__SIGNAL:
			if (resolve)
				return getSignal();
			return basicGetSignal();
		}
		return eDynamicGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case UMLPackage.SIGNAL_EVENT__EANNOTATIONS:
			getEAnnotations().clear();
			getEAnnotations().addAll((Collection<? extends EAnnotation>) newValue);
			return;
		case UMLPackage.SIGNAL_EVENT__OWNED_COMMENT:
			getOwnedComments().clear();
			getOwnedComments().addAll((Collection<? extends Comment>) newValue);
			return;
		case UMLPackage.SIGNAL_EVENT__NAME:
			setName((String) newValue);
			return;
		case UMLPackage.SIGNAL_EVENT__NAME_EXPRESSION:
			setNameExpression((StringExpression) newValue);
			return;
		case UMLPackage.SIGNAL_EVENT__VISIBILITY:
			setVisibility((VisibilityKind) newValue);
			return;
		case UMLPackage.SIGNAL_EVENT__OWNING_TEMPLATE_PARAMETER:
			setOwningTemplateParameter((TemplateParameter) newValue);
			return;
		case UMLPackage.SIGNAL_EVENT__TEMPLATE_PARAMETER:
			setTemplateParameter((TemplateParameter) newValue);
			return;
		case UMLPackage.SIGNAL_EVENT__SIGNAL:
			setSignal((Signal) newValue);
			return;
		}
		eDynamicSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case UMLPackage.SIGNAL_EVENT__EANNOTATIONS:
			getEAnnotations().clear();
			return;
		case UMLPackage.SIGNAL_EVENT__OWNED_COMMENT:
			getOwnedComments().clear();
			return;
		case UMLPackage.SIGNAL_EVENT__NAME:
			unsetName();
			return;
		case UMLPackage.SIGNAL_EVENT__NAME_EXPRESSION:
			setNameExpression((StringExpression) null);
			return;
		case UMLPackage.SIGNAL_EVENT__VISIBILITY:
			unsetVisibility();
			return;
		case UMLPackage.SIGNAL_EVENT__OWNING_TEMPLATE_PARAMETER:
			setOwningTemplateParameter((TemplateParameter) null);
			return;
		case UMLPackage.SIGNAL_EVENT__TEMPLATE_PARAMETER:
			setTemplateParameter((TemplateParameter) null);
			return;
		case UMLPackage.SIGNAL_EVENT__SIGNAL:
			setSignal((Signal) null);
			return;
		}
		eDynamicUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case UMLPackage.SIGNAL_EVENT__EANNOTATIONS:
			return !getEAnnotations().isEmpty();
		case UMLPackage.SIGNAL_EVENT__OWNED_COMMENT:
			return !getOwnedComments().isEmpty();
		case UMLPackage.SIGNAL_EVENT__OWNED_ELEMENT:
			return isSetOwnedElements();
		case UMLPackage.SIGNAL_EVENT__OWNER:
			return isSetOwner();
		case UMLPackage.SIGNAL_EVENT__CLIENT_DEPENDENCY:
			return !getClientDependencies().isEmpty();
		case UMLPackage.SIGNAL_EVENT__NAME:
			return isSetName();
		case UMLPackage.SIGNAL_EVENT__NAME_EXPRESSION:
			return basicGetNameExpression() != null;
		case UMLPackage.SIGNAL_EVENT__NAMESPACE:
			return isSetNamespace();
		case UMLPackage.SIGNAL_EVENT__QUALIFIED_NAME:
			return QUALIFIED_NAME_EDEFAULT == null ? getQualifiedName() != null : !QUALIFIED_NAME_EDEFAULT.equals(getQualifiedName());
		case UMLPackage.SIGNAL_EVENT__VISIBILITY:
			return isSetVisibility();
		case UMLPackage.SIGNAL_EVENT__OWNING_TEMPLATE_PARAMETER:
			return basicGetOwningTemplateParameter() != null;
		case UMLPackage.SIGNAL_EVENT__TEMPLATE_PARAMETER:
			return basicGetTemplateParameter() != null;
		case UMLPackage.SIGNAL_EVENT__SIGNAL:
			return basicGetSignal() != null;
		}
		return eDynamicIsSet(featureID);
	}

} //SignalEventImpl
