/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.cdo.internal.util;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EStoreEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;

public class SubsetSupersetEObjectEList<E>
extends EStoreEObjectImpl.BasicEStoreEList<E> {
    private static final long serialVersionUID = 1L;
    protected final int[] supersetFeatureIDs;
    protected final int[] subsetFeatureIDs;

    public SubsetSupersetEObjectEList(Class<?> dataClass, InternalEObject owner, int featureID, int[] supersetFeatureIDs, int[] subsetFeatureIDs) {
        super(owner, owner.eClass().getEStructuralFeature(featureID));
        this.supersetFeatureIDs = supersetFeatureIDs;
        this.subsetFeatureIDs = subsetFeatureIDs;
    }

    protected boolean enforceSubsetConstraints() {
        Resource.Internal eInternalResource = this.owner.eInternalResource();
        return eInternalResource == null || !eInternalResource.isLoading();
    }

    protected void supersetAdd(Object object) {
        if (this.supersetFeatureIDs != null && this.enforceSubsetConstraints()) {
            int i = 0;
            while (i < this.supersetFeatureIDs.length) {
                EList supersetEList;
                EStructuralFeature supersetEStructuralFeature = this.owner.eClass().getEStructuralFeature(this.supersetFeatureIDs[i]);
                if (supersetEStructuralFeature.isMany() && !(supersetEList = (EList)this.owner.eGet(supersetEStructuralFeature)).contains(object)) {
                    supersetEList.add(object);
                }
                ++i;
            }
        }
    }

    protected boolean enforceSupersetConstraints() {
        return true;
    }

    protected void subsetRemove(Object object) {
        if (this.subsetFeatureIDs != null && this.enforceSupersetConstraints()) {
            int i = 0;
            while (i < this.subsetFeatureIDs.length) {
                EStructuralFeature subsetEStructuralFeature = this.owner.eClass().getEStructuralFeature(this.subsetFeatureIDs[i]);
                if (subsetEStructuralFeature.isMany()) {
                    EList list = (EList)this.owner.eGet(subsetEStructuralFeature);
                    list.remove(object);
                } else if (object.equals(this.owner.eGet(subsetEStructuralFeature))) {
                    this.owner.eSet(subsetEStructuralFeature, null);
                }
                ++i;
            }
        }
    }

    public NotificationChain basicAdd(E object, NotificationChain notifications) {
        notifications = super.basicAdd(object, notifications);
        this.supersetAdd(object);
        return notifications;
    }

    public NotificationChain basicSet(int index, E object, NotificationChain notifications) {
        Object oldObject = super.basicGet(index);
        notifications = super.basicSet(index, object, notifications);
        this.supersetAdd(object);
        if (oldObject != object) {
            this.subsetRemove(oldObject);
        }
        return notifications;
    }

    public void add(int index, E object) {
        super.add(index, object);
        this.supersetAdd(object);
    }

    public boolean add(E object) {
        boolean result = super.add(object);
        this.supersetAdd(object);
        return result;
    }

    public boolean addAll(Collection<? extends E> collection) {
        boolean result = super.addAll(collection);
        Iterator<E> elements = collection.iterator();
        while (elements.hasNext()) {
            this.supersetAdd(elements.next());
        }
        return result;
    }

    public boolean addAll(int index, Collection<? extends E> collection) {
        boolean result = super.addAll(index, collection);
        Iterator<E> elements = collection.iterator();
        while (elements.hasNext()) {
            this.supersetAdd(elements.next());
        }
        return result;
    }

    public E set(int index, E object) {
        Object result = super.set(index, object);
        this.supersetAdd(object);
        if (result != object) {
            this.subsetRemove(result);
        }
        return (E)result;
    }

    protected void didRemove(int index, E oldObject) {
        super.didRemove(index, oldObject);
        this.subsetRemove(oldObject);
    }

    public static class Unsettable<E>
    extends SubsetSupersetEObjectEList<E> {
        private static final long serialVersionUID = 1L;
        protected boolean isSet;

        public Unsettable(Class<?> dataClass, InternalEObject owner, int featureID, int[] supersetFeatureIDs, int[] subsetFeatureIDs) {
            super(dataClass, owner, featureID, supersetFeatureIDs, subsetFeatureIDs);
        }

        protected void didChange() {
            this.isSet = true;
        }

        public boolean isSet() {
            return this.isSet;
        }

        public void unset() {
            super.unset();
            if (this.isNotificationRequired()) {
                boolean oldIsSet = this.isSet;
                this.isSet = false;
                this.owner.eNotify((Notification)this.createNotification(2, oldIsSet, false));
            } else {
                this.isSet = false;
            }
        }
    }
}

