/*****************************************************************************
 * Copyright (c) 2013 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 *
 *****************************************************************************/

package org.eclipse.papyrus.designer.components.transformation.component.filters;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.components.fcm.InteractionComponent;
import org.eclipse.papyrus.designer.transformation.core.copylisteners.PreCopyListener;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;


/**
 * Do not copy connector related elements, i.e.
 * 1. UML connectors with stereotype FCM.Connector
 * The rationale behind this is that we want to avoid copying a FCM connector from the source model
 * into the target model since the target model should only contain the reified form of the connector
 *
 * 2. UML classes that are stereotyped as interaction components
 * We do not want to copy interaction components, since they typically need to be instantiated.
 * TODO: there is no check whether we are actually in a template. An interaction component might be fixed (i.e. not
 * depend on template instantiation) and needs to be copied in this case.
 * (in most cases, these are not copied anyway, since these are in a different model,
 * but we do not want to exclude the case of defining model-local connectors)
 */
public class FilterTemplate implements PreCopyListener {

	public FilterTemplate() {
		active = true;
	}

	public static FilterTemplate getInstance() {
		if (instance == null) {
			instance = new FilterTemplate();
		}
		return instance;
	}

	@Override
	public EObject preCopyEObject(LazyCopier copier, EObject sourceEObj) {
		if (active && (sourceEObj instanceof Element)) {
			Element sourceElem = (Element) sourceEObj;
			if ((sourceEObj instanceof Connector) && StereotypeUtil.isApplied(sourceElem, org.eclipse.papyrus.designer.components.fcm.Connector.class)) {
	//			return null;
			}
			if ((sourceEObj instanceof Class) && StereotypeUtil.isApplied(sourceElem, InteractionComponent.class)) {
				return null;
			}
		}
		return sourceEObj;
	}

	public void setActive(boolean active) {
		this.active = active;
	}

	private boolean active;

	private static FilterTemplate instance = null;
}
