/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.transformation.ui.dialogs;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.designer.components.fcm.ContainerRule;
import org.eclipse.papyrus.designer.components.fcm.RuleApplication;
import org.eclipse.papyrus.designer.components.transformation.component.ContainerUtil;
import org.eclipse.papyrus.designer.components.transformation.ui.dialogs.RuleLabelProvider;
import org.eclipse.papyrus.designer.uml.tools.utils.DescriptionUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.infra.widgets.toolbox.utils.DialogUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ContainerDialog
extends SelectionStatusDialog {
    protected Class m_component;
    protected Text fDescription;
    protected CheckboxTableViewer fRules;
    protected ContainerRule m_currentRule;
    protected Package m_model;
    protected boolean m_rulePropertiesOnly;

    public ContainerDialog(Shell parent, Class componentOrRule) {
        super(parent);
        this.m_rulePropertiesOnly = StereotypeUtil.isApplied((Element)componentOrRule, ContainerRule.class);
        if (!this.m_rulePropertiesOnly) {
            this.m_component = componentOrRule;
        }
        this.m_model = PackageUtil.getRootPackage((Element)componentOrRule);
    }

    protected void computeResult() {
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        if (this.m_rulePropertiesOnly) {
            this.createRuleInfoGroup(contents);
            this.selectRule(this.m_currentRule);
        } else {
            this.createRuleSelectionGroup(contents);
            this.createRuleInfoGroup(contents);
        }
        return contents;
    }

    protected void createRuleSelectionGroup(Composite parent) {
        Composite ruleSelections = new Composite(parent, 0);
        GridLayout grid = new GridLayout(1, true);
        GridData groupGridData = new GridData();
        groupGridData.grabExcessVerticalSpace = true;
        groupGridData.grabExcessHorizontalSpace = true;
        groupGridData.horizontalAlignment = 4;
        groupGridData.verticalAlignment = 4;
        ruleSelections.setLayout((Layout)grid);
        ruleSelections.setLayoutData((Object)groupGridData);
        ruleSelections.setSize(400, 300);
        GridData data = new GridData(1808);
        data.heightHint = 150;
        data.widthHint = 200;
        ICheckStateListener checkListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object obj = event.getElement();
                if (obj instanceof ContainerRule) {
                    ContainerRule rule = (ContainerRule)obj;
                    if (event.getChecked()) {
                        ContainerDialog.this.applyRule(rule);
                    } else {
                        ContainerDialog.this.unapplyRule(rule);
                    }
                }
            }
        };
        Group gRuleSelGroup = new Group(ruleSelections, 2048);
        gRuleSelGroup.setText(" available rules ");
        gRuleSelGroup.setLayout((Layout)new GridLayout(1, false));
        gRuleSelGroup.setLayoutData((Object)groupGridData);
        EList globalRuleList = ContainerUtil.getAllRules((Package)this.m_model);
        this.fRules = CheckboxTableViewer.newCheckList((Composite)gRuleSelGroup, (int)2048);
        GridData data2 = new GridData(1808);
        data2.heightHint = 200;
        this.fRules.getTable().setLayoutData((Object)data);
        this.fRules.setLabelProvider((IBaseLabelProvider)new RuleLabelProvider());
        this.fRules.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fRules.setInput((Object)globalRuleList.toArray());
        for (ContainerRule rule : globalRuleList) {
            if (!this.isRuleApplied(rule)) continue;
            this.fRules.setChecked((Object)rule, true);
        }
        this.fRules.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] selected;
                ISelection selection = ContainerDialog.this.fRules.getSelection();
                if (selection instanceof StructuredSelection && (selected = ((StructuredSelection)selection).toArray()).length == 1 && selected[0] instanceof ContainerRule && ContainerDialog.this.m_currentRule != selected[0]) {
                    ContainerDialog.this.selectRule((ContainerRule)selected[0]);
                }
            }
        });
        this.fRules.addCheckStateListener(checkListener);
    }

    protected void createRuleInfoGroup(Composite parent) {
        GridData groupGridData = DialogUtils.createFillGridData();
        Group ruleInfoGroup = new Group(parent, 2048);
        ruleInfoGroup.setText(" rule information ");
        ruleInfoGroup.setLayout((Layout)new GridLayout(2, false));
        ruleInfoGroup.setLayoutData((Object)groupGridData);
        GridData span2 = new GridData();
        span2.horizontalSpan = 2;
        span2.horizontalAlignment = 4;
        span2.grabExcessHorizontalSpace = true;
        span2.grabExcessVerticalSpace = true;
        span2.verticalAlignment = 4;
        span2.heightHint = 80;
        this.fDescription = new Text((Composite)ruleInfoGroup, 584);
        this.fDescription.setLayoutData((Object)span2);
        ruleInfoGroup.pack();
    }

    protected void selectRule(ContainerRule rule) {
        this.m_currentRule = rule;
        this.fDescription.setText(DescriptionUtils.getDescription((Element)rule.getBase_Class()));
    }

    ContainerRule addRule(String name) {
        Class ruleCl = (Class)this.m_component.createNestedClassifier(name, UMLPackage.eINSTANCE.getClass_());
        StereotypeUtil.apply((Element)ruleCl, ContainerRule.class);
        return (ContainerRule)UMLUtil.getStereotypeApplication((Element)ruleCl, ContainerRule.class);
    }

    void deleteRule(ContainerRule rule) {
        Classifier ruleCl = this.m_component.getNestedClassifier(rule.getBase_Class().getName());
        if (ruleCl instanceof Class) {
            ruleCl.destroy();
        }
    }

    void applyRule(ContainerRule rule) {
        if (!StereotypeUtil.isApplied((Element)this.m_component, RuleApplication.class)) {
            StereotypeUtil.apply((Element)this.m_component, RuleApplication.class);
        }
        RuleApplication containerConfig = (RuleApplication)UMLUtil.getStereotypeApplication((Element)this.m_component, RuleApplication.class);
        containerConfig.getContainerRule().add((Object)rule);
    }

    void unapplyRule(ContainerRule rule) {
        RuleApplication containerConfig = (RuleApplication)UMLUtil.getStereotypeApplication((Element)this.m_component, RuleApplication.class);
        int index = containerConfig.getContainerRule().indexOf((Object)rule);
        if (index >= 0 && index < containerConfig.getContainerRule().size()) {
            containerConfig.getContainerRule().remove(index);
        }
    }

    boolean isRuleApplied(ContainerRule rule) {
        RuleApplication containerConfig = (RuleApplication)UMLUtil.getStereotypeApplication((Element)this.m_component, RuleApplication.class);
        if (containerConfig != null) {
            return containerConfig.getContainerRule().contains((Object)rule);
        }
        return false;
    }
}

