/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.transformation;

import java.util.List;
import org.eclipse.papyrus.designer.components.transformation.PortUtils;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;

public class PortInfo {
    protected Port port;
    protected Port parentPort;

    public PortInfo(Port port, Port parentPort) {
        this.port = port;
        this.parentPort = parentPort;
    }

    public static PortInfo fromSubPort(Port port, Port subPort) {
        if (subPort != null) {
            return new PortInfo(subPort, port);
        }
        return new PortInfo(port, null);
    }

    public String getName() {
        if (this.parentPort != null) {
            return this.parentPort.getName() + "_" + this.port.getName();
        }
        return this.port.getName();
    }

    public Interface getProvided() {
        if (this.parentPort != null && this.parentPort.isConjugated()) {
            return PortUtils.getRequired(this.port);
        }
        return PortUtils.getProvided(this.port);
    }

    public List<Interface> getProvideds() {
        if (this.parentPort != null && this.parentPort.isConjugated()) {
            return PortUtils.getRequireds(this.port);
        }
        return PortUtils.getProvideds(this.port);
    }

    public Interface getRequired() {
        if (this.parentPort != null && this.parentPort.isConjugated()) {
            return PortUtils.getProvided(this.port);
        }
        return PortUtils.getRequired(this.port);
    }

    public List<Interface> getRequireds() {
        if (this.parentPort != null && this.parentPort.isConjugated()) {
            return PortUtils.getProvideds(this.port);
        }
        return PortUtils.getRequireds(this.port);
    }

    public boolean isConjugated() {
        if (this.parentPort != null) {
            return this.port.isConjugated() ^ this.parentPort.isConjugated();
        }
        return this.port.isConjugated();
    }

    public int getUpper() {
        return this.port.getUpper();
    }

    public Port getPort() {
        return this.port;
    }

    public Port getModelPort() {
        if (this.parentPort != null) {
            return this.parentPort;
        }
        return this.port;
    }
}

