/**
 * Copyright (c) 2016 CEA LIST
 * 
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License 2.0 which
 * accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Shuai Li (CEA LIST) <shuai.li@cea.fr> - Initial API and implementation
 *   Van Cam Pham (CEA LIST) <vancam.pham@cea.fr> - Reverse implementation
 *   Ansgar Radermacher (CEA LIST) - Larger refactoring
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Mutable;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Typedef;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Volatile;
import org.eclipse.papyrus.designer.languages.cpp.reverse.utils.TypeOperationsEnhanced;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * functions to create and update properties
 */
@SuppressWarnings("all")
public class PropertyUtils {
  public static void createProperty(final IField field, final Classifier classifier) {
    Property _createProperty = UMLFactory.eINSTANCE.createProperty();
    final Procedure1<Property> _function = (Property it) -> {
      it.setName(field.getElementName());
    };
    Property prop = ObjectExtensions.<Property>operator_doubleArrow(_createProperty, _function);
    if ((classifier instanceof DataType)) {
      EList<Property> _ownedAttributes = ((DataType) classifier).getOwnedAttributes();
      _ownedAttributes.add(prop);
    } else {
      if ((classifier instanceof org.eclipse.uml2.uml.Class)) {
        EList<Property> _ownedAttributes_1 = ((org.eclipse.uml2.uml.Class) classifier).getOwnedAttributes();
        _ownedAttributes_1.add(prop);
      }
    }
    ReverseUtils.setXmlID(prop);
    PropertyUtils.updateProperty(field, prop);
  }

  public static void updateProperty(final IField field, final Property prop) {
    try {
      ReverseUtils.unapplyAllStereotypes(prop);
      Type type = null;
      boolean doNotAnalyzeDeclaration = false;
      try {
        IASTNode fieldNode = ASTUtils.findEnclosingNode(field);
        if ((fieldNode != null)) {
          String rawSignature = fieldNode.getRawSignature().replaceAll("\\n", "").replaceAll("\\r", "").replaceAll(";", "").replaceAll("\\s+", " ").trim();
          Pattern pattern = Pattern.compile("(\\()(\\s*)(\\*)(.*)(\\))(\\s*)(\\()(.*)(\\))");
          Matcher matcher = pattern.matcher(rawSignature);
          boolean _find = matcher.find();
          if (_find) {
            String typeName = rawSignature.replaceFirst(Pattern.quote(field.getElementName()), "typeName").replaceFirst("typedef", "");
            PackageableElement packageable = null;
            Element _owner = prop.getOwner();
            if ((_owner instanceof org.eclipse.uml2.uml.Class)) {
              Element _owner_1 = prop.getOwner();
              packageable = ((org.eclipse.uml2.uml.Class) _owner_1);
            } else {
              packageable = prop.getNearestPackage();
            }
            final String ownerName = packageable.getName();
            PrimitiveType _createPrimitiveType = UMLFactory.eINSTANCE.createPrimitiveType();
            final Procedure1<PrimitiveType> _function = (PrimitiveType it) -> {
              String _elementName = field.getElementName();
              String _plus = ((ownerName + "_") + _elementName);
              String _plus_1 = (_plus + "_funcptr");
              it.setName(_plus_1);
            };
            PrimitiveType primitiveType = ObjectExtensions.<PrimitiveType>operator_doubleArrow(_createPrimitiveType, _function);
            if ((packageable instanceof org.eclipse.uml2.uml.Package)) {
              EList<Type> _ownedTypes = ((org.eclipse.uml2.uml.Package) packageable).getOwnedTypes();
              _ownedTypes.add(primitiveType);
            } else {
              EList<Classifier> _nestedClassifiers = ((org.eclipse.uml2.uml.Class) packageable).getNestedClassifiers();
              _nestedClassifiers.add(primitiveType);
            }
            StereotypeUtil.apply(primitiveType, Typedef.class);
            Typedef _stereotypeApplication = UMLUtil.<Typedef>getStereotypeApplication(primitiveType, Typedef.class);
            _stereotypeApplication.setDefinition(typeName);
            type = primitiveType;
            doNotAnalyzeDeclaration = true;
          }
        }
        if ((type == null)) {
          if (((field.getTypeName().equals("enum") || field.getTypeName().equals("struct")) || 
            field.getTypeName().equals("class"))) {
            String rawSignature_1 = fieldNode.getRawSignature();
            String trimmedRawSignature = rawSignature_1.replaceAll("\\n", "").replaceAll("\\r", "").replaceAll(";", "").replaceAll("\\s+", " ").trim();
            Pattern pattern_1 = Pattern.compile("(\\{)(.*)(\\})");
            Matcher matcher_1 = pattern_1.matcher(trimmedRawSignature);
            boolean _find_1 = matcher_1.find();
            if (_find_1) {
              String[] tokens = rawSignature_1.split("}");
              final String[] _converted_tokens = (String[])tokens;
              int _size = ((List<String>)Conversions.doWrapArray(_converted_tokens)).size();
              boolean _greaterThan = (_size > 0);
              if (_greaterThan) {
                final String[] _converted_tokens_1 = (String[])tokens;
                int _size_1 = ((List<String>)Conversions.doWrapArray(_converted_tokens_1)).size();
                int _minus = (_size_1 - 1);
                String lastToken = tokens[_minus];
                boolean _contains = lastToken.contains(field.getElementName());
                if (_contains) {
                  lastToken = lastToken.replaceFirst(Pattern.quote(field.getElementName()), "typeName");
                }
                String typeName_1 = "";
                final String[] _converted_tokens_2 = (String[])tokens;
                int _size_2 = ((List<String>)Conversions.doWrapArray(_converted_tokens_2)).size();
                int _minus_1 = (_size_2 - 1);
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _minus_1, true);
                for (final Integer i : _doubleDotLessThan) {
                  String _typeName = typeName_1;
                  String _get = tokens[(i).intValue()];
                  typeName_1 = (_typeName + _get);
                }
                String _typeName_1 = typeName_1;
                typeName_1 = (_typeName_1 + lastToken);
                PackageableElement packageable_1 = null;
                Element _owner_2 = prop.getOwner();
                if ((_owner_2 instanceof org.eclipse.uml2.uml.Class)) {
                  Element _owner_3 = prop.getOwner();
                  packageable_1 = ((org.eclipse.uml2.uml.Class) _owner_3);
                } else {
                  packageable_1 = prop.getNearestPackage();
                }
                final String ownerName_1 = packageable_1.getName();
                PrimitiveType _createPrimitiveType_1 = UMLFactory.eINSTANCE.createPrimitiveType();
                final Procedure1<PrimitiveType> _function_1 = (PrimitiveType it) -> {
                  try {
                    String _elementName = field.getElementName();
                    String _plus = ((ownerName_1 + "_") + _elementName);
                    String _plus_1 = (_plus + "_anon_");
                    String _typeName_2 = field.getTypeName();
                    String _plus_2 = (_plus_1 + _typeName_2);
                    it.setName(_plus_2);
                  } catch (Throwable _e) {
                    throw Exceptions.sneakyThrow(_e);
                  }
                };
                PrimitiveType primitiveType_1 = ObjectExtensions.<PrimitiveType>operator_doubleArrow(_createPrimitiveType_1, _function_1);
                if ((packageable_1 instanceof org.eclipse.uml2.uml.Package)) {
                  EList<Type> _ownedTypes_1 = ((org.eclipse.uml2.uml.Package) packageable_1).getOwnedTypes();
                  _ownedTypes_1.add(primitiveType_1);
                } else {
                  EList<Classifier> _nestedClassifiers_1 = ((org.eclipse.uml2.uml.Class) packageable_1).getNestedClassifiers();
                  _nestedClassifiers_1.add(primitiveType_1);
                }
                StereotypeUtil.apply(primitiveType_1, Typedef.class);
                Typedef _stereotypeApplication_1 = UMLUtil.<Typedef>getStereotypeApplication(primitiveType_1, Typedef.class);
                _stereotypeApplication_1.setDefinition(typeName_1);
                type = primitiveType_1;
                doNotAnalyzeDeclaration = true;
              }
            }
          }
        }
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception e = (Exception)_t;
          e.printStackTrace();
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
      if ((type == null)) {
        type = ReverseUtils.getUMLType(ASTUtils.getQualifiedName(field), field);
      }
      prop.setType(type);
      prop.setName(field.getElementName());
      if ((!doNotAnalyzeDeclaration)) {
        IASTNode node = ASTUtils.getSelector(field.getTranslationUnit()).findEnclosingNode(field.getSourceRange().getStartPos(), 
          field.getSourceRange().getLength());
        if ((node instanceof IASTSimpleDeclaration)) {
          ReverseUtils.analyzeDeclaration(((List<IASTDeclarator>)Conversions.doWrapArray(((IASTSimpleDeclaration)node).getDeclarators())), prop.getType(), prop, ReverseUtils.Cpp_LangID);
        }
        Element _owner = prop.getOwner();
        if ((_owner instanceof NamedElement)) {
          Element _owner_1 = prop.getOwner();
          PkgDependencies.createDependency(((NamedElement) _owner_1), type);
        }
        CommentUtils.addComment(prop, node);
      }
      prop.setIsStatic(field.isStatic());
      prop.setVisibility(ASTUtils.convertVisibility(field.getVisibility()));
      ReverseUtils.applyStereotype(prop, field.isConst(), Const.class);
      ReverseUtils.applyStereotype(prop, field.isVolatile(), Volatile.class);
      ReverseUtils.applyStereotype(prop, field.isMutable(), Mutable.class);
      boolean createAssociations = false;
      if (createAssociations) {
        EObject _eContainer = prop.eContainer();
        Association asso = TypeOperationsEnhanced.createAssociationFromProperty(prop, true, AggregationKind.NONE_LITERAL, 
          false, AggregationKind.NONE_LITERAL, StringExtensions.toFirstLower(((Classifier) _eContainer).getName()), 1, 1);
        String _name = prop.getName();
        String _plus = ("A_" + _name);
        String _plus_1 = (_plus + "_");
        EObject _eContainer_1 = prop.eContainer();
        String _firstLower = StringExtensions.toFirstLower(((Classifier) _eContainer_1).getName());
        String _plus_2 = (_plus_1 + _firstLower);
        asso.setName(_plus_2);
      }
      boolean _isSimpleAssociation = ReverseUtils.isSimpleAssociation(prop);
      if (_isSimpleAssociation) {
        prop.setAggregation(AggregationKind.NONE_LITERAL);
      } else {
        boolean _isAggregation = ReverseUtils.isAggregation(prop);
        if (_isAggregation) {
          prop.setAggregation(AggregationKind.SHARED_LITERAL);
        } else {
          boolean _isComposition = ReverseUtils.isComposition(prop);
          if (_isComposition) {
            prop.setAggregation(AggregationKind.COMPOSITE_LITERAL);
          }
        }
      }
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
