/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMemberClass;
import org.eclipse.cdt.internal.core.model.ASTStringUtil;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ReverseData;
import org.eclipse.papyrus.designer.languages.cpp.reverse.ReverseUtils;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ASTUtils {
    public static IASTDeclSpecifier getDeclSpecifier(ISourceReference sourceRef) {
        return ASTUtils.getDeclSpecifier(ASTUtils.findEnclosingNode(sourceRef));
    }

    public static IASTDeclSpecifier getDeclSpecifier(IASTNode node) {
        if (node instanceof IASTDeclSpecifier) {
            return (IASTDeclSpecifier)node;
        }
        if (node instanceof IASTFunctionDefinition) {
            return ((IASTFunctionDefinition)node).getDeclSpecifier();
        }
        if (node instanceof IASTSimpleDeclaration) {
            return ((IASTSimpleDeclaration)node).getDeclSpecifier();
        }
        if (node instanceof ICPPASTTemplateDeclaration) {
            return ASTUtils.getDeclSpecifier((IASTNode)((ICPPASTTemplateDeclaration)node).getDeclaration());
        }
        return null;
    }

    public static IASTStandardFunctionDeclarator getDeclarator(ISourceReference sourceRef) {
        IASTDeclaration declaration;
        IASTNode node = ASTUtils.findEnclosingNode(sourceRef);
        if (node instanceof ICPPASTFunctionDefinition) {
            IASTFunctionDeclarator _declarator = ((ICPPASTFunctionDefinition)node).getDeclarator();
            return (IASTStandardFunctionDeclarator)_declarator;
        }
        if (node instanceof IASTSimpleDeclaration) {
            return (IASTStandardFunctionDeclarator)IterableExtensions.head((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)((IASTSimpleDeclaration)node).getDeclarators())), IASTStandardFunctionDeclarator.class));
        }
        if (node instanceof ICPPASTTemplateDeclaration && (declaration = ((ICPPASTTemplateDeclaration)node).getDeclaration()) instanceof IASTSimpleDeclaration) {
            return (IASTStandardFunctionDeclarator)IterableExtensions.head((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)((IASTSimpleDeclaration)declaration).getDeclarators())), IASTStandardFunctionDeclarator.class));
        }
        return null;
    }

    public static IASTNodeSelector getSelector(ITranslationUnit unit) {
        try {
            IASTTranslationUnit ast = null;
            Map<ITranslationUnit, IASTTranslationUnit> tuToASTtuMap = ReverseData.current.tuToASTtuMap;
            if (unit != null) {
                boolean _tripleNotEquals;
                IASTTranslationUnit _get = tuToASTtuMap.get(unit);
                boolean bl = _tripleNotEquals = _get != null;
                if (_tripleNotEquals) {
                    return tuToASTtuMap.get(unit).getNodeSelector(null);
                }
                ast = unit.getAST(ReverseData.current.index, 2);
                if (ast != null) {
                    tuToASTtuMap.put(unit, ast);
                    return ast.getNodeSelector(null);
                }
            }
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static IASTNode findEnclosingNode(ISourceReference sourceRef) {
        try {
            IASTNodeSelector selector = ASTUtils.getSelector(sourceRef.getTranslationUnit());
            ISourceRange range = sourceRef.getSourceRange();
            if (selector != null) {
                return selector.findEnclosingNode(range.getStartPos(), range.getLength());
            }
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String getQualifiedName(ISourceReference sourceRef) {
        IBinding binding;
        IASTNode node = ASTUtils.findEnclosingNode(sourceRef);
        if (node instanceof IASTName) {
            return ASTUtils.getQualifiedName((IASTName)node);
        }
        if (node instanceof ICPPASTNamespaceDefinition) {
            return ASTUtils.getQualifiedName(((ICPPASTNamespaceDefinition)node).getName());
        }
        if (node instanceof ICPPASTTemplateDeclaration) {
            node = ((ICPPASTTemplateDeclaration)node).getDeclaration();
        }
        if (node instanceof IASTFunctionDefinition && (binding = ((IASTFunctionDefinition)node).getDeclarator().getName().resolveBinding().getOwner()) instanceof ICPPBinding) {
            return ASTTypeUtil.getQualifiedName((ICPPBinding)((ICPPBinding)binding));
        }
        IASTDeclSpecifier declSpecifier = ASTUtils.getDeclSpecifier(node);
        if (declSpecifier != null) {
            return ASTUtils.getQualifiedName(declSpecifier);
        }
        return null;
    }

    public static String getQualifiedName(IASTDeclSpecifier declSpecifier) {
        if (declSpecifier instanceof IASTNamedTypeSpecifier) {
            return ASTUtils.getQualifiedName(((IASTNamedTypeSpecifier)declSpecifier).getName());
        }
        if (declSpecifier instanceof IASTElaboratedTypeSpecifier) {
            return ASTUtils.getQualifiedName(((IASTElaboratedTypeSpecifier)declSpecifier).getName());
        }
        if (declSpecifier instanceof IASTCompositeTypeSpecifier) {
            return ASTUtils.getQualifiedName(((IASTCompositeTypeSpecifier)declSpecifier).getName());
        }
        if (declSpecifier instanceof IASTEnumerationSpecifier) {
            return ASTUtils.getQualifiedName(((IASTEnumerationSpecifier)declSpecifier).getName());
        }
        return ReverseUtils.getCppTypeName(ASTStringUtil.getSignatureString((IASTDeclSpecifier)declSpecifier, null));
    }

    public static String getQNameOfUsing(IASTName name) {
        ICPPASTNameSpecifier segment;
        if (name instanceof ICPPASTQualifiedName && (segment = ((ICPPASTQualifiedName)name).getAllSegments()[0]) instanceof IASTName) {
            IASTName segLastName = ((IASTName)segment).getLastName();
            return ASTUtils.getQualifiedName(segLastName);
        }
        return null;
    }

    public static String getQualifiedName(IASTName name) {
        IASTName lastName = name.getLastName();
        IBinding binding = null;
        binding = lastName instanceof ICPPASTTemplateId ? ((ICPPASTTemplateId)lastName).getTemplateName().resolveBinding() : name.resolveBinding();
        if (binding instanceof ICPPUnknownMemberClass) {
            binding = ((ICPPUnknownMemberClass)binding).getOwner();
        }
        return ASTUtils.getQualifiedName(binding);
    }

    public static String getQualifiedNameFromNSpec(ICPPASTNameSpecifier nameSpecifier) {
        if (nameSpecifier instanceof ICPPASTTemplateId) {
            return ASTUtils.getQualifiedName(((ICPPASTTemplateId)nameSpecifier).getTemplateName().resolveBinding());
        }
        if (nameSpecifier instanceof IASTName) {
            return ASTUtils.getQualifiedName((IASTName)nameSpecifier);
        }
        return ASTUtils.getQualifiedName(nameSpecifier.resolveBinding());
    }

    public static String getQualifiedName(IBinding binding) {
        if (binding instanceof IProblemBinding) {
            boolean _greaterThan;
            ReverseUtils.LOGGER.log(Level.WARNING, String.format("binding <%s> is problematic", binding));
            int _size = ((List)Conversions.doWrapArray((Object)((IProblemBinding)binding).getCandidateBindings())).size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                return ASTUtils.getQualifiedName(((IProblemBinding)binding).getCandidateBindings()[0]);
            }
        }
        if (binding instanceof IField) {
            return ASTUtils.getQualifiedName((IBinding)((IField)binding).getCompositeTypeOwner());
        }
        if (binding instanceof ICPPTemplateInstance) {
            ICPPTemplateDefinition _templateDefinition = ((ICPPTemplateInstance)binding).getTemplateDefinition();
            return ASTUtils.getQualifiedName((IBinding)_templateDefinition);
        }
        if (binding instanceof ICPPSpecialization) {
            return ASTUtils.getQualifiedName(((ICPPSpecialization)binding).getSpecializedBinding());
        }
        boolean cfr_ignored_0 = binding instanceof ITypedef;
        if (binding instanceof ICPPBinding) {
            return ASTUtils.stripFNHint(ASTTypeUtil.getQualifiedName((ICPPBinding)((ICPPBinding)binding)));
        }
        return binding.getName();
    }

    public static String stripFNHint(String qName) {
        int idx;
        if (qName != null && (idx = qName.lastIndexOf("{")) != -1) {
            int endIdx;
            if (idx > 2) {
                int _idx = idx;
                idx = _idx - 2;
            }
            if ((endIdx = qName.indexOf("}", idx)) != -1) {
                boolean _lessThan;
                int _length = qName.length();
                int _minus = _length - 2;
                boolean bl = _lessThan = endIdx < _minus;
                if (_lessThan) {
                    int _endIdx = endIdx;
                    endIdx = _endIdx + 2;
                }
                String _substring = qName.substring(0, idx);
                String _substring_1 = qName.substring(endIdx + 1);
                String strippedName = _substring + _substring_1;
                return ASTUtils.stripFNHint(strippedName);
            }
        }
        return qName;
    }

    public static ITranslationUnit getTargetTU(IASTName name) {
        return ReverseUtils.getTranslationUnitFromPath(name.getContainingFilename(), ReverseData.current.project);
    }

    public static String getTemplateType(IASTName astName, String name) {
        IASTName parent = astName;
        while (parent != null) {
            if (parent instanceof ICPPASTTemplateDeclaration) {
                ICPPASTTemplateParameter[] _templateParameters;
                ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = _templateParameters = ((ICPPASTTemplateDeclaration)parent).getTemplateParameters();
                int n = _templateParameters.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPASTTemplateParameter parameter = iCPPASTTemplateParameterArray[n2];
                    String _string = parameter.toString();
                    boolean _equals = Objects.equals(_string, name);
                    if (_equals) {
                        IASTDeclaration _declaration = ((ICPPASTTemplateDeclaration)parent).getDeclaration();
                        String templateQN = ASTUtils.getQualifiedName(((IASTSimpleDeclaration)_declaration).getDeclSpecifier());
                        return templateQN + "::" + name;
                    }
                    ++n2;
                }
            }
            parent = parent.getParent();
        }
        return name;
    }

    public static String getCppTypeName(IASTDeclSpecifier declarator) {
        Object parameterTypeName;
        block5: {
            parameterTypeName = "";
            try {
                IToken token = declarator.getSyntax();
                while (token != null) {
                    boolean _equals_2;
                    boolean _equals_1;
                    String tokenStr = token.toString();
                    boolean _equals = tokenStr.equals("*");
                    if (!(_equals || (_equals_1 = tokenStr.equals("&")) || (_equals_2 = tokenStr.equals("const")))) {
                        boolean _greaterThan;
                        int _length = ((String)parameterTypeName).length();
                        boolean bl = _greaterThan = _length > 0;
                        if (_greaterThan) {
                            String _parameterTypeName = parameterTypeName;
                            parameterTypeName = _parameterTypeName + " ";
                        }
                        String _parameterTypeName_1 = parameterTypeName;
                        parameterTypeName = _parameterTypeName_1 + tokenStr;
                    }
                    token = token.getNext();
                }
            }
            catch (Throwable _t) {
                if (_t instanceof ExpansionOverlapsBoundaryException) break block5;
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return parameterTypeName;
    }

    public static VisibilityKind convertVisibility(ASTAccessVisibility visibility) {
        boolean _equals = Objects.equals(visibility, ASTAccessVisibility.PRIVATE);
        if (_equals) {
            return VisibilityKind.PRIVATE_LITERAL;
        }
        boolean _equals_1 = Objects.equals(visibility, ASTAccessVisibility.PROTECTED);
        if (_equals_1) {
            return VisibilityKind.PROTECTED_LITERAL;
        }
        return VisibilityKind.PUBLIC_LITERAL;
    }

    public static VisibilityKind convertVisibility(int visibility) {
        if (visibility == 3) {
            return VisibilityKind.PRIVATE_LITERAL;
        }
        if (visibility == 2) {
            return VisibilityKind.PROTECTED_LITERAL;
        }
        return VisibilityKind.PUBLIC_LITERAL;
    }
}

