/*******************************************************************************
 * Copyright (c) 2006 - 2007 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     CEA LIST - initial API and implementation
 *******************************************************************************/

package org.eclipse.papyrus.designer.languages.cpp.view.panels;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.papyrus.designer.infra.base.CommandSupport;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Array;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ref;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Parameter;


/**
 * Panel displayed when a Parameter is selected
 * @deprecated This view will be replaced by an XWT view for the C++ profile
 */
@Deprecated
public class CppParameterPanel extends CppAbstractPanel {

	private Button isConst;

	private Parameter selectedParameter;

	// document used by the viewer
	private IDocument docPtr;

	private IDocument docRef;

	private IDocument docArray;

	private IDocument docDefault;

	@SuppressWarnings("unused")
	private SourceViewer viewerPtr;

	@SuppressWarnings("unused")
	private SourceViewer viewerRef;

	@SuppressWarnings("unused")
	private SourceViewer viewerArray;

	@SuppressWarnings("unused")
	private SourceViewer viewerDefault;

	private Group groupPtr;

	private Group groupRef;

	private Group groupArray;

	private Group groupDefault;

	public CppParameterPanel(Composite parent, int style) {
		super(parent, style);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see com.cea.accordcpp.core.ui.panels.AccordAbstractPanel#getSelectedElement()
	 */
	@Override
	public org.eclipse.uml2.uml.Parameter getSelectedElement() {
		return selectedParameter;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see com.cea.accordcpp.core.ui.panels.AccordAbstractPanel#setSelectedElement(java.lang.Element)
	 */
	@Override
	public void setSelectedElement(Element newElement) {
		super.setSelectedElement(newElement);
		if (newElement instanceof Parameter) {
			this.selectedParameter = (Parameter) newElement;
		}
		else {
			throw new RuntimeException("bad selection: " + newElement + " should be an uml2 Parameter");
		}
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see com.cea.accorduml.ui.views.panels.AccordUMLAbstractPanel#createContent()
	 */
	@Override
	public Control createContent() {
		// /////////////////////////////////////////////////////////////////////
		// Create save reset buttons with superclass method
		// /////////////////////////////////////////////////////////////////////
		createSaveResetButtons();

		// /////////////////////////////////////////////////////////////////////
		// Create checkboxes
		// /////////////////////////////////////////////////////////////////////
		isConst = createButton("isConst", this, null);

		// /////////////////////////////////////////////////////////////////////
		// Add checkboxes listeners
		// /////////////////////////////////////////////////////////////////////
		addStereotypeSelectionListener(isConst, "Const");

		// /////////////////////////////////////////////////////////////////////
		// Pointer declaration
		// /////////////////////////////////////////////////////////////////////
		docPtr = createDocument();
		groupPtr = createGroup(
				this
				, "Pointer declaration"
				, buttonSave
				, null
				, false
				, 0
				, 25
				, false);

		// Use CDT CEditor coloration
		viewerPtr = createViewer(docPtr, groupPtr);

		// /////////////////////////////////////////////////////////////////////
		// Pointer declaration
		// /////////////////////////////////////////////////////////////////////
		docRef = createDocument();
		groupRef = createGroup(
				this
				, "Reference declaration"
				, buttonSave
				, groupPtr
				, false
				, 0
				, 50
				, false);

		// Use CDT CEditor coloration
		viewerRef = createViewer(docRef, groupRef);

		// /////////////////////////////////////////////////////////////////////
		// Pointer declaration
		// /////////////////////////////////////////////////////////////////////
		docDefault = createDocument();
		groupDefault = createGroup(
				this
				, "Default value"
				, buttonSave
				, groupRef
				, false
				, 0
				, 75
				, false);

		// Use CDT CEditor coloration
		viewerDefault = createViewer(docDefault, groupDefault);

		// /////////////////////////////////////////////////////////////////////
		// Pointer declaration
		// /////////////////////////////////////////////////////////////////////
		docArray = createDocument();
		groupArray = createGroup(
				this
				, "Array value ([...])"
				, buttonSave
				, groupDefault
				, true
				, 0
				, 0
				, false);

		// Use CDT CEditor coloration
		viewerArray = createViewer(docArray, groupArray);

		// /////////////////////////////////////////////////////////////////////
		// Return control
		// /////////////////////////////////////////////////////////////////////

		return this;
	}

	/**
	 * Saves the body for an '<code>Parameter</code>'
	 */
	@Override
	public void save()
	{
		if (selectedParameter == null) {
			/* Log.debug("saveBody : selectedParameter is null"); */
		}
		else {
			CommandSupport.exec(selectedParameter, "C++ parameter save", new Runnable() {

				@Override
				public void run()
				{
					// Treat Pointer
					String newPtr = docPtr.get();
					if (newPtr.equals("")) {
						StereotypeUtil.unapply(selectedParameter, Ptr.class);
					}
					else {
						StereotypeUtil.apply(selectedParameter, Ptr.class);
					}

					// Treat Reference
					String newRef = docRef.get();
					if (newRef.equals("")) {
						StereotypeUtil.unapply(selectedParameter, Ref.class);
					}
					else {
						StereotypeUtil.apply(selectedParameter, Ref.class);
					}

					// Treat DefaultValue
					// need common class for facilitating this
					// selectedParameter.setDefaultValue(selectedParameter.createDefaultValue("default", selectedParameter.getType(), null);

					// Treat Array
					String newArray = docArray.get();
					if (newArray.equals("")) {
						StereotypeUtil.unapply(selectedParameter, Array.class);
					}
					else {
						StereotypeUtil.apply(selectedParameter, Array.class);
						// StereotypeUtil.setTaggedValue(selectedParameter, Array.class, "definition", newArray);
					}
				}
			});
		}
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see com.cea.accordcpp.core.ui.panels.AccordAbstractPanel#refreshPanel()
	 */
	@Override
	protected void refreshPanel() {
		if (selectedParameter != null) {
			// Const

			isConst.setSelection(StereotypeUtil.isApplied(selectedParameter, Const.class));
			// TODO: examine effect;
			// isConst.setSelection(selectedParameter.getEffect?);

			docPtr.set(StereotypeUtil.isApplied(selectedParameter, Ptr.class) ? "*" : "");
			docRef.set(StereotypeUtil.isApplied(selectedParameter, Ref.class) ? "&" : "");
			docDefault.set(selectedParameter.getDefault());
			docArray.set(StereotypeUtil.isApplied(selectedParameter, Array.class) ? "[]" : "");
			// need definition?
		}
	}

	/**
	 * Called when the static checkbox is modified
	 */
	protected void checkConst() {

		boolean boxState = isConst.getSelection();

		if (boxState) {
			if (!StereotypeUtil.isApplied(selectedParameter, Const.class)) {
				StereotypeUtil.apply(selectedParameter, Const.class);
			}
		} else {
			if (StereotypeUtil.isApplied(selectedParameter, Const.class)) {
				StereotypeUtil.unapply(selectedParameter, Const.class);
			}
		}
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see com.cea.accorduml.ui.views.panels.AccordUMLAbstractPanel#entryAction()
	 */
	@Override
	public void entryAction() {
		super.entryAction();
		reset();
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see com.cea.accordcpp.core.ui.panels.AccordAbstractPanel#checkModifications()
	 */
	@Override
	public boolean checkModifications() {
		String ptrValue = StereotypeUtil.isApplied(selectedParameter, Ptr.class) ? "*" : "";
		if (!docPtr.get().equals(ptrValue)) {
			return true;
		}

		String refValue = StereotypeUtil.isApplied(selectedParameter, Ref.class) ? "&" : "";
		if (!docRef.get().equals(refValue)) {
			return true;
		}

		String defaultValue = selectedParameter.getDefault();
		if (defaultValue == null) {
			if (!docDefault.get().equals("")) {
				return true;
			}
		}
		else if (!docDefault.get().equals(defaultValue)) {
			return true;
		}

		String arrayValue = StereotypeUtil.isApplied(selectedParameter, Array.class) ? "[]" : "";
		if (!docArray.get().equals(arrayValue)) {
			return true;
		}
		return false;
	}

	@Override
	protected void updateModel() {

		// Check button changes
		CommandSupport.exec(selectedParameter, "C++ parameter update", new Runnable() {

			@Override
			public void run()
			{
				checkConst();
			}
		});
	}
}
