/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.jdt.texteditor.sync;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.papyrus.designer.infra.base.CommandSupport;
import org.eclipse.papyrus.designer.infra.base.StringUtils;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageCodegen;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.ListHint;
import org.eclipse.papyrus.designer.languages.java.jdt.texteditor.Activator;
import org.eclipse.papyrus.designer.languages.java.jdt.texteditor.TextEditorConstants;
import org.eclipse.papyrus.designer.languages.java.jdt.texteditor.listener.ModelListener;
import org.eclipse.papyrus.designer.languages.java.jdt.texteditor.sync.ASTUtils;
import org.eclipse.papyrus.designer.languages.java.library.JavaLibUriConstants;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Array;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Final;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Import;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Variadic;
import org.eclipse.papyrus.designer.uml.tools.utils.BehaviorUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.ParameterUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class SyncJDTtoModel
implements Runnable {
    public static final String VOID_TYPE = "void";
    public static final String REGISTER = "register";
    public static final String CONST = "const";
    public static final String VOLATILE = "volatile";
    public static final String sAtParam = "@param";
    public static final String sAtReturn = "@return";
    public static final String ansiCLib = "AnsiCLibrary";
    public static final URI[] defaultLibs = new URI[]{JavaLibUriConstants.LIBRARY_PATH_URI, JavaLibUriConstants.PT_LIBRARY_PATH_URI};
    ICompilationUnit icu;
    CompilationUnit astCU;
    protected IEditorInput m_input;
    protected Classifier m_classifier;
    protected String m_projectName;
    protected ILangCodegen m_codegen;

    public SyncJDTtoModel(IEditorInput input, Classifier classifier, String projectName, String generatorID) {
        this.m_input = input;
        this.m_classifier = classifier;
        this.m_projectName = projectName;
        this.m_codegen = LanguageCodegen.getGenerator((Pattern)TextEditorConstants.JAVA, (String)generatorID);
    }

    public void syncJDTtoModel(ITypeRoot root) {
        if (root instanceof ICompilationUnit) {
            this.icu = (ICompilationUnit)root;
            CommandSupport.exec((EObject)this.m_classifier, (String)"update model from JDT", (Runnable)this);
        }
    }

    @Override
    public void run() {
        ModelListener.syncFromEditor = true;
        ASTParser parser = ASTParser.newParser((int)14);
        parser.setKind(8);
        parser.setSource(this.icu);
        parser.setResolveBindings(true);
        this.astCU = (CompilationUnit)parser.createAST(null);
        try {
            this.examineChildren((IParent)this.icu);
            this.updateJavaImport();
        }
        catch (JavaModelException e) {
            Activator.log.error((Throwable)e);
        }
        ModelListener.syncFromEditor = false;
    }

    public void examineChildren(IParent parent) throws JavaModelException {
        IJavaElement[] iJavaElementArray = parent.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            if (child instanceof IParent) {
                this.examineChildren((IParent)child);
            }
            if (child instanceof IType) {
                IType clazz = (IType)child;
                TypeDeclaration astClazz = (TypeDeclaration)this.astCU.findDeclaringNode(clazz.getKey());
                ArrayList<Property> refAttributes = new ArrayList<Property>();
                ArrayList<Operation> refOperations = new ArrayList<Operation>();
                ArrayList existingAttributes = new ArrayList();
                ArrayList existingOperations = new ArrayList();
                existingAttributes.addAll(this.m_classifier.getAttributes());
                existingOperations.addAll(this.m_classifier.getOperations());
                int position = 0;
                FieldDeclaration[] fieldDeclarationArray = astClazz.getFields();
                int n3 = fieldDeclarationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    FieldDeclaration field = fieldDeclarationArray[n4];
                    this.updateAttribute(field, refAttributes, position);
                    ++position;
                    ++n4;
                }
                position = 0;
                fieldDeclarationArray = astClazz.getMethods();
                n3 = fieldDeclarationArray.length;
                n4 = 0;
                while (n4 < n3) {
                    FieldDeclaration method = fieldDeclarationArray[n4];
                    this.updateMethod((MethodDeclaration)method, refOperations, position);
                    ++position;
                    ++n4;
                }
                for (Property attribute : existingAttributes) {
                    if (refAttributes.contains(attribute)) continue;
                    attribute.destroy();
                }
                for (Operation operation : existingOperations) {
                    if (refOperations.contains(operation)) continue;
                    ArrayList behaviors = new ArrayList();
                    behaviors.addAll(operation.getMethods());
                    for (Behavior behavior : behaviors) {
                        behavior.destroy();
                    }
                    operation.destroy();
                }
            }
            ++n2;
        }
    }

    public void updateJavaImport() throws JavaModelException {
        Import importSt;
        Object body = "";
        IImportDeclaration[] iImportDeclarationArray = this.icu.getImports();
        int n = iImportDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IImportDeclaration import_ = iImportDeclarationArray[n2];
            body = (String)body + import_.getSource();
            ++n2;
        }
        if (((String)body).length() > 0 && (importSt = (Import)StereotypeUtil.applyApp((Element)this.m_classifier, Import.class)) != null) {
            importSt.setManualImports((String)body);
        }
    }

    public NamedElement updateMethod(MethodDeclaration method, List<Operation> refOperations, int position) throws JavaModelException {
        String qualifiedName = method.getName().getFullyQualifiedName();
        String[] names = qualifiedName.split("\\.");
        String name = names[names.length - 1];
        Operation operation = this.m_classifier.getOperation(name, null, null);
        if (operation == null) {
            if (this.m_classifier instanceof Interface) {
                operation = ((Interface)this.m_classifier).createOwnedOperation(name, null, null);
            } else if (this.m_classifier instanceof Class) {
                operation = ((Class)this.m_classifier).createOwnedOperation(name, null, null);
            }
        }
        if (operation != null) {
            this.updateParameters(method, (NamedElement)operation);
            this.updateComment(method, (NamedElement)operation);
            Behavior behavior = null;
            if (operation.getMethods().size() > 0) {
                behavior = (Behavior)operation.getMethods().get(0);
            } else if (this.m_classifier instanceof Class) {
                behavior = ((Class)this.m_classifier).createOwnedBehavior(name, UMLPackage.eINSTANCE.getOpaqueBehavior());
                operation.getMethods().add((Object)behavior);
            }
            if (behavior instanceof OpaqueBehavior) {
                String body = this.getBody(method);
                OpaqueBehavior ob = (OpaqueBehavior)behavior;
                BehaviorUtils.set((Behavior)ob, (String)body, (String)"Java");
            }
            refOperations.add(operation);
        }
        return operation;
    }

    protected void updateAttribute(FieldDeclaration field, List<Property> refAttributes, int position) {
        VariableDeclaration varDecl = ASTUtils.getVarDeclaration(field);
        String name = varDecl.getName().toString();
        Property attribute = this.m_classifier.getAttribute(name, null);
        if (attribute == null && this.m_classifier instanceof Class) {
            attribute = ((Class)this.m_classifier).createOwnedAttribute(name, null);
        }
        if (attribute != null) {
            String typeName = ASTUtils.getTypeName(field.getType());
            NamedElement ne = this.getJavaType(typeName);
            if (ne instanceof Type) {
                attribute.setType((Type)ne);
            }
            refAttributes.add(attribute);
        }
    }

    protected void updateParameters(MethodDeclaration method, NamedElement opOrBehavior) {
        ArrayList<Parameter> paramList = new ArrayList<Parameter>();
        List existingParamList = ParameterUtils.getOwnedParametersCopy((NamedElement)opOrBehavior);
        for (Object parObj : method.parameters()) {
            if (!(parObj instanceof SingleVariableDeclaration)) continue;
            SingleVariableDeclaration parameter = (SingleVariableDeclaration)parObj;
            String paramName = parameter.getName().toString();
            Parameter umlParameter = ParameterUtils.getParameterViaName((List)existingParamList, (String)paramName);
            if (umlParameter == null) {
                org.eclipse.jdt.core.dom.Type type = parameter.getType();
                if (type instanceof ArrayType) {
                    type = ((ArrayType)type).getElementType();
                }
                String typeName = ASTUtils.getTypeName(type);
                NamedElement ne = this.getJavaType(typeName);
                Type umlType = null;
                if (ne instanceof Type) {
                    umlType = (Type)ne;
                }
                umlParameter = ParameterUtils.createOwnedParameter((NamedElement)opOrBehavior, (String)paramName, (Type)umlType);
                this.applyParameterModifiers(parameter, umlParameter);
            }
            paramList.add(umlParameter);
        }
        org.eclipse.jdt.core.dom.Type type = method.getReturnType2();
        if (type != null) {
            Parameter umlRetParam;
            String typeName = ASTUtils.getTypeName(type);
            NamedElement ne = this.getJavaType(typeName);
            Type umlType = null;
            if (ne instanceof Type) {
                umlType = (Type)ne;
            }
            if ((umlRetParam = ParameterUtils.getParameterViaName((List)existingParamList, null)) == null && umlType != null) {
                umlRetParam = ParameterUtils.createReturnResult((NamedElement)opOrBehavior, (Type)umlType);
            }
            if (umlRetParam != null) {
                paramList.add(umlRetParam);
            }
        }
        for (Parameter existingParam : existingParamList) {
            if (paramList.contains(existingParam)) continue;
            existingParam.destroy();
        }
        ParameterUtils.resetParameters((NamedElement)opOrBehavior, paramList);
    }

    protected void updateMultiplicity(Parameter parameter, Parameter existingParameter) {
        if (parameter != null && existingParameter != null) {
            parameter.setLower(existingParameter.getLower());
            parameter.setUpper(existingParameter.getUpper());
        }
    }

    protected Type getParameterType(String typeName, Parameter existingParameter) {
        return null;
    }

    public void applyParameterModifiers(SingleVariableDeclaration parameter, Parameter umlParameter) {
        IVariableBinding binding;
        for (Object mod : parameter.modifiers()) {
            if (!mod.toString().equals("final")) continue;
            StereotypeUtil.apply((Element)umlParameter, Final.class);
        }
        if (parameter.isVarargs()) {
            StereotypeUtil.apply((Element)umlParameter, Variadic.class);
        }
        if ((binding = parameter.resolveBinding()) != null && binding.getType().isArray()) {
            if (GenUtils.hasStereotypeTree((Element)umlParameter, ListHint.class)) {
                StereotypeUtil.applyApp((Element)umlParameter, Array.class);
            } else {
                umlParameter.setLower(0);
                umlParameter.setUpper(-1);
            }
        }
    }

    public Operation getModelOperationFromName(String name, IParent parent, int position) {
        Operation operation = this.m_classifier.getOperation(name, null, null);
        if (operation == null && position < this.m_classifier.getOperations().size()) {
            operation = (Operation)this.m_classifier.getOperations().get(position);
            String modelName = operation.getName();
            try {
                IJavaElement[] iJavaElementArray = parent.getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String cdtName;
                    IJavaElement child = iJavaElementArray[n2];
                    if (child instanceof IMethod && (cdtName = ((IMethod)child).getElementName()).equals(modelName)) {
                        operation = null;
                        break;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return operation;
    }

    public String getBody(MethodDeclaration method) throws JavaModelException {
        Block body = method.getBody();
        String source = this.getSource((ASTNode)body);
        if (source.length() > 2) {
            return StringUtils.decreaseIndent((char[])source.toCharArray(), (int)1, (int)(source.length() - 1), (int)8).trim();
        }
        return "";
    }

    public void updateComment(MethodDeclaration method, NamedElement ne) throws JavaModelException {
        String comment = this.getSource((ASTNode)method.getJavadoc());
        if (comment.startsWith("/**")) {
            comment = comment.substring(3);
        }
        if ((comment = comment.replaceAll("\n\\s+\\* ", "\n").replace("*/", "").trim()).length() > 0) {
            int atParam = comment.indexOf(sAtParam);
            int atReturn = comment.indexOf(sAtReturn);
            int atParamOrReturn = atReturn != -1 && (atReturn < atParam || atParam == -1) ? atReturn : atParam;
            Object commentMethodOnly = atParamOrReturn != -1 ? comment.substring(0, atParamOrReturn).trim() : comment;
            while (atParam != -1) {
                int currentAtParam = atParam;
                String commentParam = (atParam = comment.indexOf(sAtParam, atParam + 1)) != -1 ? comment.substring(currentAtParam, atParam) : comment.substring(currentAtParam);
                int atParamName = sAtParam.length();
                while (atParamName < commentParam.length() && Character.isWhitespace(commentParam.charAt(atParamName))) {
                    ++atParamName;
                }
                int atParamNameEnd = atParamName;
                while (atParamNameEnd < commentParam.length() && !Character.isWhitespace(commentParam.charAt(atParamNameEnd))) {
                    ++atParamNameEnd;
                }
                if (atParamNameEnd >= commentParam.length() - 1) continue;
                String parameterName = commentParam.substring(atParamName, atParamNameEnd);
                String commentParamText = commentParam.substring(atParamNameEnd).trim();
                Parameter parameter = null;
                if (ne instanceof BehavioralFeature) {
                    parameter = ((BehavioralFeature)ne).getOwnedParameter(parameterName, null, false, false);
                } else if (ne instanceof Behavior) {
                    parameter = ((Behavior)ne).getOwnedParameter(parameterName, null, false, false);
                }
                if (parameter != null) {
                    Comment commentParamUML;
                    EList commentsParamUML = parameter.getOwnedComments();
                    if (commentsParamUML.size() == 0) {
                        commentParamUML = parameter.createOwnedComment();
                        commentParamUML.getAnnotatedElements().add((Object)commentParamUML);
                    } else {
                        commentParamUML = (Comment)commentsParamUML.get(0);
                    }
                    commentParamUML.setBody(commentParamText);
                    continue;
                }
                commentMethodOnly = (String)commentMethodOnly + "\n @param" + parameterName + " not found(!) " + commentParamText;
            }
            if (((String)commentMethodOnly).equals("*")) {
                commentMethodOnly = "";
            }
            EList commentsUML = ne.getOwnedComments();
            if (((String)commentMethodOnly).length() > 0) {
                Comment commentUML;
                if (commentsUML.size() == 0) {
                    commentUML = ne.createOwnedComment();
                    commentUML.getAnnotatedElements().add((Object)commentUML);
                } else {
                    commentUML = (Comment)commentsUML.get(0);
                }
                commentUML.setBody((String)commentMethodOnly);
            } else if (commentsUML.size() > 0) {
                ((Comment)commentsUML.get(0)).destroy();
            }
        }
    }

    public ILangCodegen getCodeGen() {
        return this.m_codegen;
    }

    public String getSource(ASTNode node) throws JavaModelException {
        String source;
        int len;
        int start;
        if (node != null && (start = node.getStartPosition()) + (len = node.getLength()) < (source = this.icu.getSource()).length()) {
            return source.substring(start, start + len);
        }
        return "";
    }

    protected NamedElement getJavaType(String qualifiedName) {
        if (qualifiedName.equals(VOID_TYPE)) {
            return null;
        }
        NamedElement ne = ElementUtils.getQualifiedElementFromRS((Element)this.m_classifier, (URI[])defaultLibs, (String)qualifiedName);
        if (ne == null) {
            String prefix = "java.lang.".replace(".", "::");
            ne = ElementUtils.getQualifiedElementFromRS((Element)this.m_classifier, (URI[])defaultLibs, (String)(prefix + qualifiedName));
        }
        return ne;
    }
}

