/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.jdt.texteditor.sync;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageCodegen;
import org.eclipse.papyrus.designer.languages.java.jdt.texteditor.TextEditorConstants;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.PackageableElement;

public class SyncModelToJDT {
    public static boolean syncFromEditor;

    public static IFile syncModelToJDT(Classifier classifier, String generatorID) {
        if (classifier == null || classifier.eResource() == null) {
            return null;
        }
        ILangCodegen codegen = LanguageCodegen.getGenerator((Pattern)TextEditorConstants.JAVA, (String)generatorID);
        IProject modelProject = codegen.getTargetProject((PackageableElement)classifier, false);
        if (modelProject == null) {
            return null;
        }
        Object srcPkg = null;
        IFile javaFile = null;
        try {
            codegen.generateCode(modelProject, (PackageableElement)classifier, null);
            String suffix = "java";
            javaFile = modelProject.getFile((IPath)new Path("src-gen/" + codegen.getFileName(modelProject, (NamedElement)classifier) + "." + suffix));
        }
        finally {
            try {
                if (srcPkg != null) {
                    srcPkg.refreshLocal(2, null);
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return javaFile;
    }
}

