/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.javaparser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.CompilationUnit;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.Node;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.BodyDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.FieldDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.MethodDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.Parameter;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.TypeDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.VariableDeclarator;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.VariableDeclaratorId;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.Expression;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.MethodCallExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.NameExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.QualifiedNameExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.VariableDeclarationExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.internal.Utils;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.BlockStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.ExpressionStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.Statement;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.ClassOrInterfaceType;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.PrimitiveType;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.ReferenceType;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.Type;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.VoidType;

public final class ASTHelper {
    public static final PrimitiveType BYTE_TYPE = new PrimitiveType(PrimitiveType.Primitive.Byte);
    public static final PrimitiveType SHORT_TYPE = new PrimitiveType(PrimitiveType.Primitive.Short);
    public static final PrimitiveType INT_TYPE = new PrimitiveType(PrimitiveType.Primitive.Int);
    public static final PrimitiveType LONG_TYPE = new PrimitiveType(PrimitiveType.Primitive.Long);
    public static final PrimitiveType FLOAT_TYPE = new PrimitiveType(PrimitiveType.Primitive.Float);
    public static final PrimitiveType DOUBLE_TYPE = new PrimitiveType(PrimitiveType.Primitive.Double);
    public static final PrimitiveType BOOLEAN_TYPE = new PrimitiveType(PrimitiveType.Primitive.Boolean);
    public static final PrimitiveType CHAR_TYPE = new PrimitiveType(PrimitiveType.Primitive.Char);
    public static final VoidType VOID_TYPE = new VoidType();

    private ASTHelper() {
    }

    public static NameExpr createNameExpr(String qualifiedName) {
        String[] split = qualifiedName.split("\\.");
        NameExpr ret = new NameExpr(split[0]);
        int i = 1;
        while (i < split.length) {
            ret = new QualifiedNameExpr(ret, split[i]);
            ++i;
        }
        return ret;
    }

    public static Parameter createParameter(Type type, String name) {
        return new Parameter(type, new VariableDeclaratorId(name));
    }

    public static FieldDeclaration createFieldDeclaration(int modifiers, Type type, VariableDeclarator variable) {
        ArrayList<VariableDeclarator> variables = new ArrayList<VariableDeclarator>();
        variables.add(variable);
        FieldDeclaration ret = new FieldDeclaration(modifiers, type, variables);
        return ret;
    }

    public static FieldDeclaration createFieldDeclaration(int modifiers, Type type, String name) {
        VariableDeclaratorId id = new VariableDeclaratorId(name);
        VariableDeclarator variable = new VariableDeclarator(id);
        return ASTHelper.createFieldDeclaration(modifiers, type, variable);
    }

    public static VariableDeclarationExpr createVariableDeclarationExpr(Type type, String name) {
        ArrayList<VariableDeclarator> vars = new ArrayList<VariableDeclarator>();
        vars.add(new VariableDeclarator(new VariableDeclaratorId(name)));
        return new VariableDeclarationExpr(type, vars);
    }

    public static void addParameter(MethodDeclaration method, Parameter parameter) {
        List<Parameter> parameters = method.getParameters();
        if (Utils.isNullOrEmpty(parameters)) {
            parameters = new ArrayList<Parameter>();
            method.setParameters(parameters);
        }
        parameters.add(parameter);
    }

    public static void addArgument(MethodCallExpr call, Expression arg) {
        List<Expression> args = call.getArgs();
        if (Utils.isNullOrEmpty(args)) {
            args = new ArrayList<Expression>();
            call.setArgs(args);
        }
        args.add(arg);
    }

    public static void addTypeDeclaration(CompilationUnit cu, TypeDeclaration type) {
        List<TypeDeclaration> types = cu.getTypes();
        if (Utils.isNullOrEmpty(types)) {
            types = new ArrayList<TypeDeclaration>();
            cu.setTypes(types);
        }
        types.add(type);
    }

    public static ReferenceType createReferenceType(String name, int arrayCount) {
        return new ReferenceType(new ClassOrInterfaceType(name), arrayCount);
    }

    public static ReferenceType createReferenceType(PrimitiveType type, int arrayCount) {
        return new ReferenceType(type, arrayCount);
    }

    public static void addStmt(BlockStmt block, Statement stmt) {
        List<Statement> stmts = block.getStmts();
        if (Utils.isNullOrEmpty(stmts)) {
            stmts = new ArrayList<Statement>();
            block.setStmts(stmts);
        }
        stmts.add(stmt);
    }

    public static void addStmt(BlockStmt block, Expression expr) {
        ASTHelper.addStmt(block, new ExpressionStmt(expr));
    }

    public static void addMember(TypeDeclaration type, BodyDeclaration decl) {
        List<BodyDeclaration> members = type.getMembers();
        if (Utils.isNullOrEmpty(members)) {
            members = new ArrayList<BodyDeclaration>();
            type.setMembers(members);
        }
        members.add(decl);
    }

    public static <N extends Node> List<N> getNodesByType(Node container, Class<N> clazz) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node child : container.getChildrenNodes()) {
            if (clazz.isInstance(child)) {
                nodes.add((Node)clazz.cast(child));
            }
            nodes.addAll(ASTHelper.getNodesByType(child, clazz));
        }
        return nodes;
    }
}

