/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.umlparser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public class GenericTransformer {
    private EObject element;

    public GenericTransformer(EObject currentEobject) {
        this.element = currentEobject;
    }

    public EObject transform(EClass requestedType) {
        EObject result = requestedType.getEPackage().getEFactoryInstance().create(requestedType);
        try {
            this.copyAllFeatures(this.element, result);
            this.changeReferences(this.element, result);
            ECrossReferenceAdapter cross = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)this.element);
            if (cross != null) {
                cross.unsetTarget((Notifier)this.element);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void copyAllFeatures(EObject source, EObject target) {
        EClass eclass = source.eClass();
        if (eclass != null) {
            EList eAllStructuralFeatures = eclass.getEAllStructuralFeatures();
            for (EStructuralFeature structuralFeature : eAllStructuralFeatures) {
                if (!this.contains(target.eClass(), structuralFeature)) continue;
                this.copyFeature(source, target, structuralFeature);
            }
        }
    }

    private boolean contains(EClass target, EStructuralFeature e) {
        EList features = target.getEAllStructuralFeatures();
        for (EStructuralFeature f : features) {
            if (!f.getName().equals(e.getName())) continue;
            return true;
        }
        return false;
    }

    private void copyFeature(EObject source, EObject target, EStructuralFeature feature) {
        ArrayList<Object> alreadyManaged = new ArrayList<Object>();
        EStructuralFeature targetFeature = this.getFeature(target, feature.getName());
        if (feature.getUpperBound() <= targetFeature.getUpperBound() && feature.getLowerBound() >= targetFeature.getLowerBound() && feature.isChangeable() && !feature.isDerived()) {
            Object value = source.eGet(feature);
            if (feature.isMany() && targetFeature.isMany()) {
                Collection values = (Collection)value;
                if (values != null && !values.isEmpty()) {
                    ArrayList newList = new ArrayList();
                    newList.addAll(values);
                    if (feature instanceof EReference && !((EReference)feature).isContainment()) {
                        this.setFeatureValue(target, targetFeature, newList);
                    } else if (feature instanceof EReference && ((EReference)feature).isContainment()) {
                        ArrayList toTreat = new ArrayList();
                        for (Object o : newList) {
                            if (alreadyManaged.contains(o)) continue;
                            toTreat.add(o);
                            alreadyManaged.add(o);
                        }
                        this.setFeatureValue(target, targetFeature, newList);
                    }
                }
            } else if (!(feature.isMany() || targetFeature.isMany() || value == null || alreadyManaged.contains(value))) {
                alreadyManaged.add(value);
                this.setFeatureValue(target, targetFeature, value);
            }
        }
    }

    protected void setFeatureValue(EObject elementToEdit, EStructuralFeature feature, Object value) {
        boolean many = FeatureMapUtil.isMany((EObject)elementToEdit, (EStructuralFeature)feature);
        if (many) {
            Collection collection = (Collection)elementToEdit.eGet(feature);
            if (value instanceof List) {
                List values = (List)value;
                collection.clear();
                collection.addAll(values);
            } else {
                collection.add(value);
            }
        } else {
            elementToEdit.eSet(feature, value);
        }
    }

    private EStructuralFeature getFeature(EObject eobject, String name) {
        return eobject.eClass().getEStructuralFeature(name);
    }

    private void changeReferences(EObject source, EObject target) {
        ResourceSet resourceSet;
        EObject rootEObject = EcoreUtil.getRootContainer((EObject)source);
        Resource resource = rootEObject.eResource();
        Collection usages = resource == null ? EcoreUtil.UsageCrossReferencer.find((EObject)source, (EObject)rootEObject) : ((resourceSet = resource.getResourceSet()) == null ? EcoreUtil.UsageCrossReferencer.find((EObject)source, (Resource)resource) : EcoreUtil.UsageCrossReferencer.find((EObject)source, (ResourceSet)resourceSet));
        for (EStructuralFeature.Setting setting : usages) {
            if (!setting.getEStructuralFeature().isChangeable()) continue;
            EcoreUtil.replace((EStructuralFeature.Setting)setting, (Object)source, (Object)target);
        }
        EcoreUtil.replace((EObject)source, (EObject)target);
    }
}

