/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.umlparser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.Type;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.ImportedTypeCatalog;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.TypeAnalyser;
import org.eclipse.papyrus.designer.languages.java.reverse.umlparser.UmlUtils;

public class TypeAnalyserAndTranslator
extends TypeAnalyser {
    private List<List<String>> translationList = new ArrayList<List<String>>();
    private static String[] defaultTranslatedType = new String[]{"java.util.List", "java.util.ArrayList", "java.util.Collection", "java.util.OrderedSet"};

    public TypeAnalyserAndTranslator(ImportedTypeCatalog importedType) {
        super(importedType);
        this.initDefaultTranslatedTypes(defaultTranslatedType);
    }

    public TranslatedTypeData getTranslatedTypeData(Type astType) {
        TranslatedTypeData typeData = (TranslatedTypeData)this.getTypeData(astType);
        this.translate(typeData);
        return typeData;
    }

    @Override
    protected TypeAnalyser.TypeData createTypeData() {
        return new TranslatedTypeData();
    }

    private void translate(TranslatedTypeData data) {
        List qname = data.qualifiedName;
        if (this.translationList.contains(qname)) {
            if (data.genericData != null && data.genericData.size() == 1) {
                System.out.println("translate '" + String.valueOf(qname) + "'");
                if (!((TypeAnalyser.TypeData)data.genericData.get((int)0)).isWildcard) {
                    data.isTranslatable = true;
                }
                data.isCollection = true;
            } else if (data.genericData == null) {
                data.isCollection = true;
            }
        } else if (data.arrayCount > 0) {
            data.isCollection = true;
        }
    }

    private void initDefaultTranslatedTypes(String[] defaultTranslatedTypes) {
        int i = 0;
        while (i < defaultTranslatedTypes.length) {
            this.translationList.add(UmlUtils.toQualifiedName(defaultTranslatedTypes[i]));
            ++i;
        }
    }

    public class TranslatedTypeData
    extends TypeAnalyser.TypeData {
        public boolean isTranslatable = false;
        public boolean isCollection = false;

        public List<String> getTranslatedQualifiedName() {
            if (this.isTranslatable) {
                return ((TypeAnalyser.TypeData)this.genericData.get((int)0)).qualifiedName;
            }
            return this.qualifiedName;
        }

        public int getTranslatedUpper() {
            if (this.isCollection) {
                return -1;
            }
            return 1;
        }

        public int getTranslatedLower() {
            if (this.isCollection) {
                return 0;
            }
            return 0;
        }

        public boolean isCollection() {
            return this.isCollection;
        }
    }
}

