/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ref;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.CDefinitions;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.SM2ClassesTransformationCore;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.TransitionGraph;
import org.eclipse.papyrus.designer.transformation.library.statemachine.SMCommon;
import org.eclipse.papyrus.designer.uml.tools.utils.BehaviorUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StateMachineUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.TransitionKind;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class EventTransformation {
    @Extension
    protected CDefinitions cdefs;
    private SM2ClassesTransformationCore core;
    private Class superContext;
    private List<Pseudostate> joins = new ArrayList<Pseudostate>();

    public EventTransformation(SM2ClassesTransformationCore core) {
        this.core = core;
        this.superContext = core.superContext;
    }

    public List<Event> getDeferredEvents(State s) {
        Functions.Function1 _function = it -> it.getEvent();
        return IterableExtensions.toList((Iterable)ListExtensions.map((List)s.getDeferrableTriggers(), (Functions.Function1)_function));
    }

    public String completionEventCheck(String eventName, String stateId) {
        boolean _equals = Objects.equals(eventName, "CompletionEvent");
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(" ");
            _builder.append("&& (currentEvent->associatedState == ");
            _builder.append(stateId, " ");
            _builder.append(")");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        return _builder_1.toString();
    }

    public Operation createEventMethod(String eventName, List<Transition> transitions) {
        boolean _greaterThan_3;
        Operation method = this.superContext.createOwnedOperation("process" + eventName, null, null);
        Functions.Function1 _function = it -> it.getSource();
        List tempSources = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)ListExtensions.map(transitions, (Functions.Function1)_function), State.class));
        ArrayList sources = new ArrayList();
        Consumer<State> _function_1 = it -> {
            boolean _not;
            boolean _contains = sources.contains(it);
            boolean bl = _not = !_contains;
            if (_not) {
                sources.add(it);
            }
        };
        tempSources.forEach(_function_1);
        HashMap map = new HashMap();
        for (State source : sources) {
            boolean _not;
            boolean _tripleNotEquals;
            State _state = source.getContainer().getState();
            boolean bl = _tripleNotEquals = _state != null;
            if (!_tripleNotEquals) continue;
            boolean _containsKey = map.containsKey(source.getContainer().getState());
            boolean bl2 = _not = !_containsKey;
            if (_not) {
                State _state_1 = source.getContainer().getState();
                ArrayList _arrayList = new ArrayList();
                map.put(_state_1, _arrayList);
            }
            ((List)map.get(source.getContainer().getState())).add(source);
        }
        List arraySet = IterableExtensions.toList(map.keySet());
        int size = arraySet.size();
        int i = 0;
        while (i < size) {
            int j = i + 1;
            while (j < size) {
                int _calculateDepth_1;
                boolean _lessEqualsThan;
                int _calculateDepth = SMCommon.calculateDepth((Region)this.core.topRegion, (State)((State)arraySet.get(i)));
                boolean bl = _lessEqualsThan = _calculateDepth <= (_calculateDepth_1 = SMCommon.calculateDepth((Region)this.core.topRegion, (State)((State)arraySet.get(j))));
                if (_lessEqualsThan) {
                    State tmp = (State)arraySet.remove(j);
                    arraySet.add(i, tmp);
                }
                ++j;
            }
            ++i;
        }
        List rootSourceStates = SMCommon.getRootStates((Region)this.core.topRegion, sources);
        ArrayList<Transition> passeds = new ArrayList<Transition>();
        Functions.Function1 _function_2 = it -> {
            String _eventName = StateMachineUtils.eventName((Event)it);
            return Objects.equals(_eventName, eventName);
        };
        int _size = IterableExtensions.size((Iterable)IterableExtensions.filter(this.core.callEvents, (Functions.Function1)_function_2));
        boolean isCallEvent = _size > 0;
        SMCommon.initCondElse();
        StringConcatenation _builder = new StringConcatenation();
        if (isCallEvent) {
            String _upperCase = this.superContext.getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("_GET_CONTROL");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("systemState");
        _builder.append(" = statemachine::SystemStateEnum_t::EVENT_PROCESSING;");
        _builder.newLineIfNotEmpty();
        for (State s : arraySet) {
            boolean _isOrthogonal = s.isOrthogonal();
            if (_isOrthogonal) {
                List<State> _actualStateList = this.getActualStateList((List)map.get(s), transitions);
                for (State sub : _actualStateList) {
                    boolean _greaterThan_1;
                    boolean _greaterThan;
                    Functions.Function1 _function_3 = it -> {
                        Vertex _source = it.getSource();
                        return Objects.equals(_source, sub);
                    };
                    Functions.Function1 _function_4 = it -> {
                        boolean _contains = passeds.contains(it);
                        return !_contains;
                    };
                    int _size_1 = IterableExtensions.size((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(transitions, (Functions.Function1)_function_3), (Functions.Function1)_function_4));
                    boolean bl = _greaterThan = _size_1 > 0;
                    if (!_greaterThan) continue;
                    if (Objects.equals(eventName, "CompletionEvent") && IterableExtensions.size((Iterable)IterableExtensions.filter(transitions, it -> Objects.equals(it.getSource(), sub) && it.getTarget() instanceof Pseudostate && Objects.equals(((Pseudostate)it.getTarget()).getKind(), PseudostateKind.JOIN_LITERAL))) > 0) {
                        Functions.Function1 _function_5 = it -> Objects.equals(it.getSource(), sub) && it.getTarget() instanceof Pseudostate && Objects.equals(((Pseudostate)it.getTarget()).getKind(), PseudostateKind.JOIN_LITERAL);
                        Iterable trans = IterableExtensions.filter(transitions, (Functions.Function1)_function_5);
                        _builder.newLineIfNotEmpty();
                        Functions.Function1 _function_6 = it -> {
                            boolean _contains = this.joins.contains(it.getTarget());
                            return !_contains;
                        };
                        Functions.Function1 _function_7 = it -> it.getTarget();
                        Vertex join = (Vertex)IterableExtensions.head((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)trans, (Functions.Function1)_function_6), (Functions.Function1)_function_7));
                        _builder.newLineIfNotEmpty();
                        Functions.Function1 _function_8 = it -> it.getSource();
                        List sourcesOfJoin = ListExtensions.map((List)join.getIncomings(), (Functions.Function1)_function_8);
                        _builder.newLineIfNotEmpty();
                        String _condElse = SMCommon.condElse();
                        _builder.append(_condElse);
                        _builder.append("if (");
                        boolean _hasElements = false;
                        for (Vertex src : sourcesOfJoin) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)" || ", "");
                            }
                            _builder.append("(currentEvent->associatedState == ");
                            String _upperCase_1 = src.getName().toUpperCase();
                            _builder.append(_upperCase_1);
                            _builder.append("_ID)");
                        }
                        _builder.append(") {");
                        _builder.newLineIfNotEmpty();
                        Functions.Function1 _function_9 = it -> {
                            Vertex _source = it.getSource();
                            return Objects.equals(_source, sub);
                        };
                        Functions.Function1 _function_10 = it -> {
                            boolean _contains = passeds.contains(it);
                            return !_contains;
                        };
                        Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.filter(transitions, (Functions.Function1)_function_9), (Functions.Function1)_function_10);
                        for (Transition t : _filter) {
                            _builder.append("\t");
                            boolean _add = passeds.add(t);
                            _builder.append((Object)_add, "\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            String _generateTransitionCode = this.generateTransitionCode(sub, t);
                            _builder.append(_generateTransitionCode, "\t");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append("}");
                        _builder.newLine();
                        continue;
                    }
                    String _condElse_1 = SMCommon.condElse();
                    _builder.append(_condElse_1);
                    _builder.append("if (");
                    _builder.append("states");
                    _builder.append("[");
                    String _upperCase_2 = s.getName().toUpperCase();
                    _builder.append(_upperCase_2);
                    _builder.append("_ID].");
                    _builder.append("actives");
                    _builder.append("[");
                    int _regionNumber = SMCommon.getRegionNumber((Region)this.core.topRegion, (State)sub);
                    _builder.append((Object)_regionNumber);
                    _builder.append("] == ");
                    String _upperCase_3 = sub.getName().toUpperCase();
                    _builder.append(_upperCase_3);
                    _builder.append("_ID");
                    String _upperCase_4 = sub.getName().toUpperCase();
                    String _plus = _upperCase_4 + "_ID";
                    String _completionEventCheck = this.completionEventCheck(eventName, _plus);
                    _builder.append(_completionEventCheck);
                    _builder.append(") {");
                    _builder.newLineIfNotEmpty();
                    Functions.Function1 _function_11 = it -> {
                        String _name = it.getName();
                        return Objects.equals(_name, eventName);
                    };
                    int _size_2 = IterableExtensions.size((Iterable)IterableExtensions.filter(this.getDeferredEvents(sub), (Functions.Function1)_function_11));
                    boolean bl3 = _greaterThan_1 = _size_2 > 0;
                    if (_greaterThan_1) {
                        _builder.append("\t");
                        _builder.append("systemState", "\t");
                        _builder.append(" = statemachine::SystemStateEnum_t::EVENT_DEFERRED;");
                        _builder.newLineIfNotEmpty();
                    } else {
                        Functions.Function1 _function_12 = it -> {
                            Vertex _source = it.getSource();
                            return Objects.equals(_source, sub);
                        };
                        Functions.Function1 _function_13 = it -> {
                            boolean _contains = passeds.contains(it);
                            return !_contains;
                        };
                        Iterable _filter_1 = IterableExtensions.filter((Iterable)IterableExtensions.filter(transitions, (Functions.Function1)_function_12), (Functions.Function1)_function_13);
                        for (Transition t_1 : _filter_1) {
                            _builder.append("\t");
                            boolean _add_1 = passeds.add(t_1);
                            _builder.append((Object)_add_1, "\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            String _generateTransitionCode_1 = this.generateTransitionCode(sub, t_1);
                            _builder.append(_generateTransitionCode_1, "\t");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                    _builder.append("}");
                    _builder.newLine();
                }
                continue;
            }
            List _get = (List)map.get(s);
            for (State sub_1 : _get) {
                boolean _greaterThan_2;
                String _condElse_2 = SMCommon.condElse();
                _builder.append(_condElse_2);
                _builder.append("if (");
                _builder.append("states");
                _builder.append("[");
                String _upperCase_5 = s.getName().toUpperCase();
                _builder.append(_upperCase_5);
                _builder.append("_ID].");
                _builder.append("actives");
                _builder.append("[0] == ");
                String _upperCase_6 = sub_1.getName().toUpperCase();
                _builder.append(_upperCase_6);
                _builder.append("_ID");
                String _upperCase_7 = sub_1.getName().toUpperCase();
                String _plus_1 = _upperCase_7 + "_ID";
                String _completionEventCheck_1 = this.completionEventCheck(eventName, _plus_1);
                _builder.append(_completionEventCheck_1);
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function_14 = it -> {
                    String _name = it.getName();
                    return Objects.equals(_name, eventName);
                };
                int _size_3 = IterableExtensions.size((Iterable)IterableExtensions.filter(this.getDeferredEvents(sub_1), (Functions.Function1)_function_14));
                boolean bl = _greaterThan_2 = _size_3 > 0;
                if (_greaterThan_2) {
                    _builder.append("\t");
                    _builder.append("systemState", "\t");
                    _builder.append(" = statemachine::SystemStateEnum_t::EVENT_DEFERRED;");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    Functions.Function1 _function_15 = it -> Objects.equals(it.getSource(), sub_1) && it.getGuard() != null;
                    Iterable hasGuards = IterableExtensions.filter(transitions, (Functions.Function1)_function_15);
                    _builder.newLineIfNotEmpty();
                    Functions.Function1 _function_16 = it -> Objects.equals(it.getSource(), sub_1) && it.getGuard() != null;
                    Iterable _filter_2 = IterableExtensions.filter(transitions, (Functions.Function1)_function_16);
                    boolean _hasElements_1 = false;
                    for (Transition t_2 : _filter_2) {
                        if (!_hasElements_1) {
                            _hasElements_1 = true;
                        } else {
                            _builder.appendImmediate((Object)" else ", "\t");
                        }
                        _builder.append("\t");
                        String _generateTransitionCode_2 = this.generateTransitionCode(sub_1, t_2);
                        _builder.append(_generateTransitionCode_2, "\t");
                        _builder.newLineIfNotEmpty();
                    }
                    boolean _isEmpty = IterableExtensions.isEmpty((Iterable)hasGuards);
                    if (_isEmpty) {
                        _builder.append("\t");
                        Functions.Function1 _function_17 = it -> Objects.equals(it.getSource(), sub_1) && it.getGuard() == null;
                        String _generateTransitionCode_3 = this.generateTransitionCode(sub_1, (Transition)IterableExtensions.head((Iterable)IterableExtensions.filter(transitions, (Functions.Function1)_function_17)));
                        _builder.append(_generateTransitionCode_3, "\t");
                        _builder.newLineIfNotEmpty();
                    } else {
                        boolean _tripleNotEquals_1;
                        Functions.Function1 _function_18 = it -> Objects.equals(it.getSource(), sub_1) && it.getGuard() == null;
                        Transition _head = (Transition)IterableExtensions.head((Iterable)IterableExtensions.filter(transitions, (Functions.Function1)_function_18));
                        boolean bl4 = _tripleNotEquals_1 = _head != null;
                        if (_tripleNotEquals_1) {
                            _builder.append("\t");
                            _builder.append("else {");
                            _builder.newLine();
                            _builder.append("\t");
                            _builder.append("\t");
                            Functions.Function1 _function_19 = it -> Objects.equals(it.getSource(), sub_1) && it.getGuard() == null;
                            String _generateTransitionCode_4 = this.generateTransitionCode(sub_1, (Transition)IterableExtensions.head((Iterable)IterableExtensions.filter(transitions, (Functions.Function1)_function_19)));
                            _builder.append(_generateTransitionCode_4, "\t\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("}");
                            _builder.newLine();
                        }
                    }
                }
                _builder.append("}");
                _builder.newLine();
            }
        }
        int _size_4 = rootSourceStates.size();
        boolean bl = _greaterThan_3 = _size_4 > 0;
        if (_greaterThan_3) {
            _builder.append("if (");
            _builder.append("systemState");
            _builder.append(" == statemachine::SystemStateEnum_t::EVENT_PROCESSING");
            String _completionEventCheck_2 = this.completionEventCheck(eventName, "activeStateID");
            _builder.append(_completionEventCheck_2);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("switch(");
            _builder.append("activeStateID", "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            for (State root : rootSourceStates) {
                boolean _greaterThan_4;
                _builder.append("\t\t");
                _builder.append("case ");
                String _upperCase_8 = root.getName().toUpperCase();
                _builder.append(_upperCase_8, "\t\t");
                _builder.append("_ID: ");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function_20 = it -> {
                    String _name = it.getName();
                    return Objects.equals(_name, eventName);
                };
                int _size_5 = IterableExtensions.size((Iterable)IterableExtensions.filter(this.getDeferredEvents(root), (Functions.Function1)_function_20));
                boolean bl5 = _greaterThan_4 = _size_5 > 0;
                if (_greaterThan_4) {
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("systemState", "\t\t\t");
                    _builder.append(" = statemachine::SystemStateEnum_t::EVENT_DEFERRED;");
                    _builder.newLineIfNotEmpty();
                } else {
                    Functions.Function1 _function_21 = it -> {
                        Vertex _source = it.getSource();
                        return Objects.equals(_source, root);
                    };
                    Iterable _filter_3 = IterableExtensions.filter(transitions, (Functions.Function1)_function_21);
                    boolean _hasElements_2 = false;
                    for (Transition t_3 : _filter_3) {
                        if (!_hasElements_2) {
                            _hasElements_2 = true;
                        } else {
                            _builder.appendImmediate((Object)" else ", "\t\t\t");
                        }
                        _builder.append("\t\t");
                        _builder.append("\t");
                        String _generateTransitionCode_5 = this.generateTransitionCode(root, t_3);
                        _builder.append(_generateTransitionCode_5, "\t\t\t");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("break;");
                _builder.newLine();
            }
            _builder.append("\t\t");
            _builder.append("default:");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("//do nothing");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        if (isCallEvent) {
            String _upperCase_9 = this.superContext.getName().toUpperCase();
            _builder.append(_upperCase_9);
            _builder.append("_RELEASE_CONTROL");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
        }
        String body = _builder.toString();
        this.core.createOpaqueBehavior(this.superContext, method, body);
        return method;
    }

    private List<State> getActualStateList(List<State> l, List<Transition> trans) {
        boolean _greaterThan;
        Functions.Function1 _function = it -> it.getTarget() instanceof Pseudostate && Objects.equals(((Pseudostate)it.getTarget()).getKind(), PseudostateKind.JOIN_LITERAL);
        Iterable transComingToJoin = IterableExtensions.filter(trans, (Functions.Function1)_function);
        ArrayList<State> ret = new ArrayList<State>();
        ret.addAll(l);
        int _size = IterableExtensions.size((Iterable)transComingToJoin);
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            ArrayList<Pseudostate> joins = new ArrayList<Pseudostate>();
            Functions.Function1 _function_1 = it -> it.getTarget();
            Consumer<Pseudostate> _function_2 = it -> {
                boolean _not;
                boolean _contains = joins.contains(it);
                boolean bl = _not = !_contains;
                if (_not) {
                    joins.add((Pseudostate)it);
                }
            };
            Iterables.filter((Iterable)IterableExtensions.map((Iterable)transComingToJoin, (Functions.Function1)_function_1), Pseudostate.class).forEach(_function_2);
            Consumer<Pseudostate> _function_3 = it -> {
                Functions.Function1 _function_4 = it_1 -> it_1.getSource();
                List toRemoveds = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)it.getIncomings(), (Functions.Function1)_function_4), State.class));
                toRemoveds.remove(IterableExtensions.head((Iterable)toRemoveds));
                ret.removeAll(toRemoveds);
            };
            joins.forEach(_function_3);
        }
        return ret;
    }

    public String generateTransitionCode(State s, Transition t) {
        StringConcatenation _builder = new StringConcatenation();
        String ret = _builder.toString();
        Constraint _guard = t.getGuard();
        boolean hasGuard = _guard != null;
        Vertex _target = t.getTarget();
        if (_target instanceof State) {
            TransitionKind _kind;
            boolean _equals;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("process");
            _builder_1.append("CompletionEvent");
            _builder_1.append("();");
            String callCompletionEvent = _builder_1.toString();
            Vertex _target_1 = t.getTarget();
            if (_target_1 instanceof FinalState) {
                State composite = t.getTarget().getContainer().getState();
                if (composite == null) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    callCompletionEvent = _builder_2.toString();
                } else {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("if (");
                    EList _regions = composite.getRegions();
                    boolean _hasElements = false;
                    for (Region r : _regions) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder_3.appendImmediate((Object)" && ", "");
                        }
                        _builder_3.append("(");
                        _builder_3.append("states");
                        _builder_3.append("[");
                        String _upperCase = composite.getName().toUpperCase();
                        _builder_3.append(_upperCase);
                        _builder_3.append("_ID].");
                        _builder_3.append("actives");
                        _builder_3.append("[");
                        int _indexOf = composite.getRegions().indexOf((Object)r);
                        _builder_3.append((Object)_indexOf);
                        _builder_3.append("] == ");
                        _builder_3.append("STATE_MAX");
                        _builder_3.append(")");
                    }
                    _builder_3.append(") {");
                    _builder_3.newLineIfNotEmpty();
                    _builder_3.append("\t");
                    _builder_3.append("eventQueue", "\t");
                    _builder_3.append(".push(statemachine::EventPriority_t::PRIORITY_1, NULL, COMPLETIONEVENT_ID, statemachine::EventType_t::COMPLETION_EVENT, ");
                    String _upperCase_1 = composite.getName().toUpperCase();
                    _builder_3.append(_upperCase_1, "\t");
                    _builder_3.append("_ID);");
                    _builder_3.newLineIfNotEmpty();
                    _builder_3.append("}");
                    callCompletionEvent = _builder_3.toString();
                }
            }
            if (_equals = Objects.equals(_kind = t.getKind(), TransitionKind.INTERNAL_LITERAL)) {
                boolean _tripleNotEquals;
                StringConcatenation _builder_4 = new StringConcatenation();
                Behavior _effect = t.getEffect();
                boolean bl = _tripleNotEquals = _effect != null;
                if (_tripleNotEquals) {
                    Behavior _effect_1 = t.getEffect();
                    String _head = (String)IterableExtensions.head((Iterable)((OpaqueBehavior)_effect_1).getBodies());
                    _builder_4.append(_head);
                    _builder_4.newLineIfNotEmpty();
                }
                ret = _builder_4.toString();
            } else {
                TransitionKind _kind_1 = t.getKind();
                boolean _equals_1 = Objects.equals(_kind_1, TransitionKind.LOCAL_LITERAL);
                if (_equals_1) {
                    State parent = null;
                    State child = null;
                    boolean _contains = StateMachineUtils.transitiveSubStates((State)s).contains(t.getTarget());
                    if (_contains) {
                        parent = s;
                        Vertex _target_2 = t.getTarget();
                        State finalChild = child = (State)_target_2;
                        StringConcatenation _builder_5 = new StringConcatenation();
                        String _generateExitingSubStates = this.core.generateExitingSubStates(s, false);
                        _builder_5.append(_generateExitingSubStates);
                        _builder_5.newLineIfNotEmpty();
                        String _transitionEffect = StateMachineUtils.getTransitionEffect((Transition)t);
                        _builder_5.append(_transitionEffect);
                        _builder_5.newLineIfNotEmpty();
                        Vertex _target_3 = t.getTarget();
                        if (_target_3 instanceof FinalState) {
                            Region _container = t.getTarget().getContainer();
                            boolean _equals_2 = Objects.equals(_container, this.core.topRegion);
                            if (_equals_2) {
                                _builder_5.append("activeStateID");
                                _builder_5.append(" = ");
                                _builder_5.append("STATE_MAX");
                                _builder_5.append(";");
                                _builder_5.newLineIfNotEmpty();
                            } else {
                                _builder_5.append("states");
                                _builder_5.append("[");
                                String _upperCase_2 = t.getTarget().getContainer().getState().getName().toUpperCase();
                                _builder_5.append(_upperCase_2);
                                _builder_5.append("_ID].");
                                _builder_5.append("actives");
                                _builder_5.append("[");
                                int _indexOf_1 = t.getTarget().getContainer().getState().getRegions().indexOf((Object)t.getTarget().getContainer());
                                _builder_5.append((Object)_indexOf_1);
                                _builder_5.append("] = ");
                                _builder_5.append("STATE_MAX");
                                _builder_5.append(";");
                                _builder_5.newLineIfNotEmpty();
                            }
                            _builder_5.append(callCompletionEvent);
                            _builder_5.append(";");
                            _builder_5.newLineIfNotEmpty();
                        } else {
                            Functions.Function1 _function = it -> this.core.allSubVertexes((Region)it).contains(finalChild);
                            Region region = (Region)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)parent.getRegions(), (Functions.Function1)_function));
                            _builder_5.newLineIfNotEmpty();
                            String _regionMethodName = this.core.getRegionMethodName(region);
                            _builder_5.append(_regionMethodName);
                            _builder_5.append("(");
                            String _vertexMacroName = this.core.getVertexMacroName((Vertex)child);
                            _builder_5.append(_vertexMacroName);
                            _builder_5.append(");");
                            _builder_5.newLineIfNotEmpty();
                        }
                        ret = _builder_5.toString();
                    } else {
                        Vertex _target_4 = t.getTarget();
                        boolean _contains_1 = StateMachineUtils.transitiveSubStates((State)((State)_target_4)).contains(s);
                        if (_contains_1) {
                            Vertex _target_5 = t.getTarget();
                            parent = (State)_target_5;
                            State finalChild_1 = child = s;
                            StringConcatenation _builder_6 = new StringConcatenation();
                            String _generateExitingSubStates_1 = this.core.generateExitingSubStates(s, false);
                            _builder_6.append(_generateExitingSubStates_1);
                            _builder_6.newLineIfNotEmpty();
                            String _transitionEffect_1 = StateMachineUtils.getTransitionEffect((Transition)t);
                            _builder_6.append(_transitionEffect_1);
                            _builder_6.newLineIfNotEmpty();
                            Vertex _target_6 = t.getTarget();
                            if (_target_6 instanceof FinalState) {
                                Region _container_1 = t.getTarget().getContainer();
                                boolean _equals_3 = Objects.equals(_container_1, this.core.topRegion);
                                if (_equals_3) {
                                    _builder_6.append("activeStateID");
                                    _builder_6.append(" = ");
                                    _builder_6.append("STATE_MAX");
                                    _builder_6.append(";");
                                    _builder_6.newLineIfNotEmpty();
                                } else {
                                    _builder_6.append("states");
                                    _builder_6.append("[");
                                    String _upperCase_3 = t.getTarget().getContainer().getState().getName().toUpperCase();
                                    _builder_6.append(_upperCase_3);
                                    _builder_6.append("_ID].");
                                    _builder_6.append("actives");
                                    _builder_6.append("[");
                                    int _indexOf_2 = t.getTarget().getContainer().getState().getRegions().indexOf((Object)t.getTarget().getContainer());
                                    _builder_6.append((Object)_indexOf_2);
                                    _builder_6.append("] = ");
                                    _builder_6.append("STATE_MAX");
                                    _builder_6.append(";");
                                    _builder_6.newLineIfNotEmpty();
                                }
                                _builder_6.append(callCompletionEvent);
                                _builder_6.append(";");
                                _builder_6.newLineIfNotEmpty();
                            } else {
                                Functions.Function1 _function_1 = it -> this.core.allSubVertexes((Region)it).contains(finalChild_1);
                                Region region_1 = (Region)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)parent.getRegions(), (Functions.Function1)_function_1));
                                _builder_6.newLineIfNotEmpty();
                                String _regionMethodName_1 = this.core.getRegionMethodName(region_1);
                                _builder_6.append(_regionMethodName_1);
                                _builder_6.append("(");
                                String _initialMacroName = this.core.getInitialMacroName(region_1);
                                _builder_6.append(_initialMacroName);
                                _builder_6.append(");");
                                _builder_6.newLineIfNotEmpty();
                            }
                            ret = _builder_6.toString();
                        }
                    }
                } else {
                    StringConcatenation _builder_7 = new StringConcatenation();
                    String _generateBetweenVertex = this.core.pseudostateGenerator.generateBetweenVertex((Vertex)s, t.getTarget(), t);
                    _builder_7.append(_generateBetweenVertex);
                    ret = _builder_7.toString();
                }
            }
            StringConcatenation _builder_8 = new StringConcatenation();
            _builder_8.append("//from ");
            String _name = t.getSource().getName();
            _builder_8.append(_name);
            _builder_8.append(" to ");
            String _name_1 = t.getTarget().getName();
            _builder_8.append(_name_1);
            _builder_8.newLineIfNotEmpty();
            _builder_8.append("if (");
            if (hasGuard) {
                String _guard_1 = this.core.getGuard(t);
                _builder_8.append(_guard_1);
            } else {
                _builder_8.append("true");
            }
            _builder_8.append(") {");
            _builder_8.newLineIfNotEmpty();
            _builder_8.append(ret);
            _builder_8.newLineIfNotEmpty();
            _builder_8.append("systemState");
            _builder_8.append(" = statemachine::SystemStateEnum_t::EVENT_CONSUMED;");
            _builder_8.newLineIfNotEmpty();
            String _generateTransitionCode = this.core.monitoringTransformation.generateTransitionCode(t);
            _builder_8.append(_generateTransitionCode);
            _builder_8.newLineIfNotEmpty();
            _builder_8.append("}");
            ret = _builder_8.toString();
        } else {
            StringConcatenation _builder_9 = new StringConcatenation();
            _builder_9.append("//from ");
            String _name_2 = t.getSource().getName();
            _builder_9.append(_name_2);
            _builder_9.append(" to ");
            String _name_3 = t.getTarget().getName();
            _builder_9.append(_name_3);
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("if (");
            if (hasGuard) {
                String _guard_2 = this.core.getGuard(t);
                _builder_9.append(_guard_2);
            } else {
                _builder_9.append("true");
            }
            _builder_9.append(") {");
            _builder_9.newLineIfNotEmpty();
            String _generateTransitionGraphCode = this.generateTransitionGraphCode(s, t);
            _builder_9.append(_generateTransitionGraphCode);
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("systemState");
            _builder_9.append(" = statemachine::SystemStateEnum_t::EVENT_CONSUMED;");
            _builder_9.newLineIfNotEmpty();
            String _generateTransitionCode_1 = this.core.monitoringTransformation.generateTransitionCode(t);
            _builder_9.append(_generateTransitionCode_1);
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("}");
            ret = _builder_9.toString();
        }
        return ret;
    }

    public int getIndexOfUnguardTransition(Pseudostate junction) {
        Functions.Function1 _function = it -> {
            Constraint _guard = it.getGuard();
            return _guard == null;
        };
        Iterable unguards = IterableExtensions.filter((Iterable)junction.getOutgoings(), (Functions.Function1)_function);
        if (!IterableExtensions.isEmpty((Iterable)unguards)) {
            IterableExtensions.size((Iterable)unguards);
        }
        Transition unguard = (Transition)IterableExtensions.head((Iterable)unguards);
        return junction.getOutgoings().indexOf((Object)unguard);
    }

    public OpaqueBehavior createEventMethod(Event e, List<Transition> transitions) {
        OpaqueBehavior _xblockexpression = null;
        Operation evMethod = this.createEventMethod(StateMachineUtils.eventName((Event)e), transitions);
        OpaqueBehavior _xifexpression = null;
        if (e instanceof CallEvent) {
            Behavior existingMethod;
            boolean _greaterThan;
            OpaqueBehavior _xblockexpression_1 = null;
            Operation op = ((CallEvent)e).getOperation();
            SMCommon.copyParameters((Operation)op, (Operation)evMethod, (boolean)false);
            EList params = evMethod.getOwnedParameters();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("this->process");
            String _eventName = StateMachineUtils.eventName((Event)e);
            _builder.append(_eventName);
            _builder.append("(");
            boolean _hasElements = false;
            for (Parameter p : params) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _name = p.getName();
                _builder.append(_name);
            }
            _builder.append(");");
            Object body = _builder.toString();
            String existingBody = null;
            int _size = op.getMethods().size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan && (existingBody = BehaviorUtils.body((Behavior)(existingMethod = (Behavior)op.getMethods().get(0)), (String)"C++")) == null) {
                existingBody = BehaviorUtils.body((Behavior)existingMethod, (String)"C/C++");
            }
            if (existingBody != null) {
                String _body = body;
                body = _body + "\n// original method code\n" + existingBody;
            }
            _xifexpression = _xblockexpression_1 = this.core.createOpaqueBehavior(this.superContext, op, (String)body);
        } else {
            OpaqueBehavior _xifexpression_1 = null;
            if (e instanceof SignalEvent) {
                boolean _tripleNotEquals_2;
                boolean _tripleNotEquals_1;
                boolean _tripleNotEquals;
                OpaqueBehavior _xblockexpression_2 = null;
                String eName = ((SignalEvent)e).getName().replace("_-_", "_");
                Operation send = this.superContext.createOwnedOperation("send" + eName, null, null);
                Signal _signal = ((SignalEvent)e).getSignal();
                boolean bl = _tripleNotEquals = _signal != null;
                if (_tripleNotEquals) {
                    StereotypeUtil.apply((Element)send.createOwnedParameter("sig", (Type)((SignalEvent)e).getSignal()), Ref.class);
                    StereotypeUtil.apply((Element)evMethod.createOwnedParameter("sig", (Type)((SignalEvent)e).getSignal()), Ref.class);
                }
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("eventQueue");
                _builder.append(".push(statemachine::EventPriority_t::PRIORITY_2, ");
                Signal _signal_1 = ((SignalEvent)e).getSignal();
                boolean bl2 = _tripleNotEquals_1 = _signal_1 != null;
                if (_tripleNotEquals_1) {
                    _builder.append("&sig");
                } else {
                    _builder.append("NULL");
                }
                _builder.append(", ");
                String _upperCase = eName.toUpperCase();
                _builder.append(_upperCase);
                _builder.append("_ID, statemachine::EventType_t::SIGNAL_EVENT, 0");
                Signal _signal_2 = ((SignalEvent)e).getSignal();
                boolean bl3 = _tripleNotEquals_2 = _signal_2 != null;
                if (_tripleNotEquals_2) {
                    _builder.append(", sizeof(");
                    String _cppQualifiedName = CppGenUtils.cgu((Element)this.superContext).cppQualifiedName((NamedElement)((SignalEvent)e).getSignal());
                    _builder.append(_cppQualifiedName);
                    _builder.append(")");
                }
                _builder.append(");");
                _xifexpression_1 = _xblockexpression_2 = this.core.createOpaqueBehavior(this.superContext, send, _builder.toString());
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String generateTransitionGraphCode(State s, Transition t) {
        TransitionGraph graph = this.core.calculateTransitionGraphs(s, t);
        Vertex _target = t.getTarget();
        Pseudostate target = (Pseudostate)_target;
        Functions.Function1 _function = it -> {
            PseudostateKind _kind = it.getKind();
            return Objects.equals(_kind, PseudostateKind.JUNCTION_LITERAL);
        };
        List junctions = IterableExtensions.toList((Iterable)IterableExtensions.filter(graph.P, (Functions.Function1)_function));
        Pseudostate join = null;
        PseudostateKind _kind = target.getKind();
        boolean _equals = Objects.equals(_kind, PseudostateKind.JOIN_LITERAL);
        if (_equals) {
            join = target;
        }
        if (join != null && this.joins.contains(join)) {
            StringConcatenation _builder = new StringConcatenation();
            return _builder.toString();
        }
        this.joins.add(join);
        StringConcatenation _builder_1 = new StringConcatenation();
        String ret = _builder_1.toString();
        ArrayList<Vertex> exits = new ArrayList<Vertex>();
        ArrayList<Vertex> enters = new ArrayList<Vertex>();
        this.calculateExitsEnters(t, exits, enters);
        Vertex cpEx = (Vertex)IterableExtensions.lastOrNull(exits);
        Vertex cpEn = (Vertex)IterableExtensions.lastOrNull(enters);
        StringConcatenation _builder_2 = new StringConcatenation();
        for (Pseudostate junction : junctions) {
            String _name = junction.getName();
            _builder_2.append(_name);
            _builder_2.append(" = ");
            int _indexOfUnguardTransition = this.getIndexOfUnguardTransition(junction);
            _builder_2.append((Object)_indexOfUnguardTransition);
            _builder_2.append(";");
            _builder_2.newLineIfNotEmpty();
            Functions.Function1 _function_1 = it -> {
                Constraint _guard = it.getGuard();
                return _guard != null;
            };
            Iterable _filter = IterableExtensions.filter((Iterable)junction.getOutgoings(), (Functions.Function1)_function_1);
            boolean _hasElements = false;
            for (Transition tr : _filter) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder_2.appendImmediate((Object)" else ", "");
                }
                _builder_2.append("if (");
                String _guard = this.core.getGuard(tr);
                _builder_2.append(_guard);
                _builder_2.append(") {");
                _builder_2.newLineIfNotEmpty();
                _builder_2.append("\t");
                String _name_1 = junction.getName();
                _builder_2.append(_name_1, "\t");
                _builder_2.append(" = ");
                int _indexOf = junction.getOutgoings().indexOf((Object)tr);
                _builder_2.append((Object)_indexOf, "\t");
                _builder_2.append(";");
                _builder_2.newLineIfNotEmpty();
                _builder_2.append("}");
                _builder_2.newLine();
            }
        }
        _builder_2.append(ret);
        _builder_2.newLineIfNotEmpty();
        if (cpEx instanceof State) {
            String _generateExitingSubStates = this.core.generateExitingSubStates((State)cpEx, true);
            _builder_2.append(_generateExitingSubStates);
            _builder_2.newLineIfNotEmpty();
        }
        if (join != null) {
            _builder_2.append("//TODO: concurrency");
            _builder_2.newLine();
            EList _incomings = join.getIncomings();
            for (Transition in : _incomings) {
                String _transitionEffect = StateMachineUtils.getTransitionEffect((Transition)in);
                _builder_2.append(_transitionEffect);
                _builder_2.newLineIfNotEmpty();
            }
        } else {
            String _transitionEffect_1 = StateMachineUtils.getTransitionEffect((Transition)t);
            _builder_2.append(_transitionEffect_1);
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("\t\t");
        }
        String bodyInside = _builder_2.toString();
        Vertex innermost = (Vertex)IterableExtensions.head(enters);
        if (innermost instanceof State) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append(bodyInside);
            _builder_3.newLineIfNotEmpty();
            if (innermost instanceof FinalState) {
                Region _container = ((FinalState)innermost).getContainer();
                boolean _equals_1 = Objects.equals(_container, this.core.topRegion);
                if (_equals_1) {
                    _builder_3.append("activeStateID");
                    _builder_3.append(" = ");
                    _builder_3.append("STATE_MAX");
                    _builder_3.append(";");
                    _builder_3.newLineIfNotEmpty();
                } else {
                    _builder_3.append("states");
                    _builder_3.append("[");
                    _builder_3.append("activeStateID");
                    _builder_3.append("].");
                    _builder_3.append("actives");
                    _builder_3.append("[");
                    int _indexOf_1 = ((FinalState)innermost).getContainer().getState().getRegions().indexOf((Object)((FinalState)innermost).getContainer());
                    _builder_3.append((Object)_indexOf_1);
                    _builder_3.append("] = ");
                    _builder_3.append("STATE_MAX");
                    _builder_3.append(";");
                    _builder_3.newLineIfNotEmpty();
                    String _generateCompletionCall = this.core.generateCompletionCall((State)innermost);
                    _builder_3.append(_generateCompletionCall);
                    _builder_3.newLineIfNotEmpty();
                }
            } else {
                CharSequence _generateEnteringOnSubVertex = this.core.generateEnteringOnSubVertex((State)cpEn, innermost);
                _builder_3.append((Object)_generateEnteringOnSubVertex);
                _builder_3.newLineIfNotEmpty();
                _builder_3.append("\t\t\t");
            }
            bodyInside = _builder_3.toString();
        } else {
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append(bodyInside);
            _builder_4.newLineIfNotEmpty();
            if (cpEn instanceof State) {
                CharSequence _generateEnteringOnSubVertex_1 = this.core.generateEnteringOnSubVertex((State)cpEn, innermost);
                _builder_4.append((Object)_generateEnteringOnSubVertex_1);
                _builder_4.newLineIfNotEmpty();
            } else {
                String _generatePseudo = this.core.pseudostateGenerator.generatePseudo((Pseudostate)innermost);
                _builder_4.append(_generatePseudo);
                _builder_4.newLineIfNotEmpty();
                _builder_4.append("\t\t\t");
            }
            bodyInside = _builder_4.toString();
        }
        StringConcatenation _builder_5 = new StringConcatenation();
        if (join != null) {
            _builder_5.append("if (");
            Functions.Function1 _function_2 = it -> it.getSource();
            List _map = ListExtensions.map((List)join.getIncomings(), (Functions.Function1)_function_2);
            boolean _hasElements_1 = false;
            for (Vertex src : _map) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder_5.appendImmediate((Object)" && ", "");
                }
                _builder_5.append("(");
                _builder_5.append("states");
                _builder_5.append("[");
                String _upperCase = src.getContainer().getState().getName().toUpperCase();
                _builder_5.append(_upperCase);
                _builder_5.append("_ID].");
                _builder_5.append("actives");
                _builder_5.append("[");
                int _indexOf_2 = src.getContainer().getState().getRegions().indexOf((Object)src.getContainer());
                _builder_5.append((Object)_indexOf_2);
                _builder_5.append("] == ");
                String _upperCase_1 = src.getName().toUpperCase();
                _builder_5.append(_upperCase_1);
                _builder_5.append("_ID)");
            }
            _builder_5.append(") {");
            _builder_5.newLineIfNotEmpty();
        }
        _builder_5.append("\t");
        _builder_5.append(bodyInside, "\t");
        _builder_5.newLineIfNotEmpty();
        if (join != null) {
            _builder_5.append("}");
            _builder_5.newLine();
        }
        ret = _builder_5.toString();
        return ret;
    }

    public boolean calculateExitsEnters(Transition t, List<Vertex> exits, List<Vertex> enters) {
        boolean _xblockexpression = false;
        ArrayList<Vertex> tp1 = new ArrayList<Vertex>();
        tp1.addAll(SMCommon.getTransitiveParentStates((Vertex)t.getSource()));
        tp1.add(0, t.getSource());
        ArrayList<Vertex> tp2 = new ArrayList<Vertex>();
        tp2.addAll(SMCommon.getTransitiveParentStates((Vertex)t.getTarget()));
        tp2.add(0, t.getTarget());
        Vertex bound1 = null;
        Vertex bound2 = null;
        for (Vertex v : tp1) {
            Functions.Function1 _function = it -> {
                Region _container = it.getContainer();
                Region _container_1 = v.getContainer();
                return Objects.equals(_container, _container_1);
            };
            Vertex tp = (Vertex)IterableExtensions.head((Iterable)IterableExtensions.filter(tp2, (Functions.Function1)_function));
            if (bound1 != null || bound2 != null || tp == null) continue;
            bound1 = v;
            bound2 = tp;
        }
        int index1 = tp1.indexOf(bound1);
        int index2 = tp2.indexOf(bound2);
        exits.addAll(tp1.subList(0, index1 + 1));
        _xblockexpression = enters.addAll(tp2.subList(0, index2 + 1));
        return _xblockexpression;
    }
}

