/**
 * Copyright (c) 2016, 2021 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *  Van Cam Pham        <VanCam.PHAM@cea.fr>
 *  Ported from C++ code - Bug 568883
 */
package org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine;

import org.eclipse.papyrus.designer.transformation.library.statemachine.SMCodeGeneratorConstants;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

/**
 * Java variant of time-event transformation
 */
@SuppressWarnings("all")
public class TimeEventTransformation {
  @Extension
  protected CDefinitions cdefs;

  private SM2ClassesTransformationCore core;

  private org.eclipse.uml2.uml.Class superContext;

  public TimeEventTransformation(final SM2ClassesTransformationCore core) {
    this.core = core;
    this.superContext = core.superContext;
    this.cdefs = core.cdefs;
  }

  public void createTimeEvents() {
    boolean _isEmpty = this.core.timeEvents.isEmpty();
    if (_isEmpty) {
      return;
    }
    Operation timeEventOp = this.superContext.createOwnedOperation(SMCodeGeneratorConstants.TIME_EVENT_LISTEN_FUNCTION, null, null);
    timeEventOp.createOwnedParameter("id", this.core.intType);
    timeEventOp.createOwnedParameter("duration", this.core.intType);
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("while (!Thread.currentThread().isInterrupted()) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("long startTime = System.currentTimeMillis();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("synchronized (this) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("wait(duration);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} catch (InterruptedException e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("// interruption, exit loop");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("break;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("long endTime = System.currentTimeMillis();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("long timedWaitResult = endTime - startTime;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("boolean commitEvent = false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (timedWaitResult >= duration) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// timeout");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("commitEvent = true;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("timeEventFlags[id] = false;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (commitEvent) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("Event_t event = new Event_t(EventPriority_t.PRIORITY_2, id, EventType_t.TIME_EVENT, id, 0);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("eventQueue.add(event);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    this.core.createOpaqueBehavior(this.superContext, timeEventOp, _builder.toString());
  }
}
