/**
 * Copyright (c) 2022 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.papyrus.designer.transformation.library.xtend;

import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class AMIPull {
  public CharSequence operation_(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _endsWith = operation.getName().endsWith("Poll");
      if (_endsWith) {
        _builder.append("// comment polling function");
        _builder.newLine();
        _builder.append("if (!resultArrived) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// wait for result, condition will be fired upon arrival");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("TimeVal timeVal = TimeVal::current () + timeout;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("m_cond.waitUpto (timeout);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        CharSequence _unmarshall = Marshalling.unmarshall(operation);
        _builder.append(_unmarshall);
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        {
          Type _type = operation.getType();
          boolean _tripleNotEquals = (_type != null);
          if (_tripleNotEquals) {
            _builder.append("return retValue;");
          }
        }
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("// TODO: need suitable constant dimensioning");
        _builder.newLine();
        _builder.append("pBuffer = &buffer[500];  // grows backwards");
        _builder.newLine();
        _builder.append("int operationID = ID_[operation.name/];");
        _builder.newLine();
        _builder.newLine();
        _builder.append("// now marshall in and inout parameters via ASN.1");
        _builder.newLine();
        CharSequence _marshall = Marshalling.marshall(operation);
        _builder.append(_marshall);
        _builder.newLineIfNotEmpty();
        _builder.append("BEncAsnContent (&amp;pBuffer, &amp;operationID);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("pthread_t pt;");
        _builder.newLine();
        _builder.append("pthread_create (&amp;pt, NULL, staticDispatch, (void *) this);");
        _builder.newLine();
        _builder.append("// TODO: add semaphore which assures that subsequent calls to [operation.name/] are not executed before dispatch");
        _builder.newLine();
        _builder.append("// has removed the parameters from the pBuffer stack (pBuffer can be corrupted).");
        _builder.newLine();
        _builder.append("// even worse: buffer will be deallocated even without a 2nd call!");
        _builder.newLine();
      }
    }
    return _builder;
  }
}
