/**
 * Copyright (c) 2015 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.c.codegen.lib;

import com.google.common.collect.Iterables;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.c.codegen.services.UmlOperationServices;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.EStorageClass;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.StorageClass;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class FunctionScript {
  public static final Pattern CLANGUAGE = Pattern.compile("C|C\\/C\\+\\+|c");

  public static CharSequence genFunctionPrototype(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Comment> _ownedComments = operation.getOwnedComments();
      for(final Comment comment : _ownedComments) {
        CharSequence _genComment = CommonScript.genComment(comment);
        _builder.append(_genComment);
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
      }
    }
    CharSequence _genDeclarator = FunctionScript.genDeclarator(operation);
    _builder.append(_genDeclarator);
    CharSequence _genReturnArgumentType = FunctionScript.genReturnArgumentType(operation, true);
    _builder.append(_genReturnArgumentType);
    String _genFunctionDeclarator = FunctionScript.genFunctionDeclarator(operation);
    _builder.append(_genFunctionDeclarator);
    _builder.append("(");
    String _genArgumentDeclarator = FunctionScript.genArgumentDeclarator(operation, true);
    _builder.append(_genArgumentDeclarator);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    return _builder;
  }

  public static CharSequence genFunctionPrototype(final Reception reception) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Comment> _ownedComments = reception.getOwnedComments();
      for(final Comment comment : _ownedComments) {
        CharSequence _genComment = CommonScript.genComment(comment);
        _builder.append(_genComment);
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("void ");
    String _genFunctionDeclarator = FunctionScript.genFunctionDeclarator(reception);
    _builder.append(_genFunctionDeclarator);
    _builder.append("(");
    String _genArgumentDeclarator = FunctionScript.genArgumentDeclarator(reception);
    _builder.append(_genArgumentDeclarator);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    return _builder;
  }

  public static CharSequence genFunctionImplementation(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _genComment = CommonScript.genComment(operation);
    _builder.append(_genComment);
    _builder.newLineIfNotEmpty();
    String _genPrePostConditions = AcslScript.genPrePostConditions(operation);
    _builder.append(_genPrePostConditions);
    _builder.newLineIfNotEmpty();
    CharSequence _genDeclarator = FunctionScript.genDeclarator(operation);
    _builder.append(_genDeclarator);
    CharSequence _genReturnArgumentType = FunctionScript.genReturnArgumentType(operation, false);
    _builder.append(_genReturnArgumentType);
    String _genFunctionDeclarator = FunctionScript.genFunctionDeclarator(operation);
    _builder.append(_genFunctionDeclarator);
    _builder.append("(");
    String _genArgumentDeclarator = FunctionScript.genArgumentDeclarator(operation, false);
    _builder.append(_genArgumentDeclarator);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    {
      Iterable<CallEvent> _filter = Iterables.<CallEvent>filter(operation.getModel().allOwnedElements(), CallEvent.class);
      for(final CallEvent callevent : _filter) {
        {
          Operation _operation = callevent.getOperation();
          boolean _equals = Objects.equals(_operation, operation);
          if (_equals) {
            _builder.append("\t");
            _builder.append("/* it is an operation of a call event : only one event associated with this operation*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _genDeclarator_1 = FunctionScript.genDeclarator(callevent.getOperation());
            _builder.append(_genDeclarator_1, "\t\t");
            String _genCallEventOperationDeclarator = FunctionScript.genCallEventOperationDeclarator(callevent);
            _builder.append(_genCallEventOperationDeclarator, "\t\t");
            _builder.append("(");
            String _genCallArgumentDeclarator = FunctionScript.genCallArgumentDeclarator(callevent.getOperation());
            _builder.append(_genCallArgumentDeclarator, "\t\t");
            _builder.append(");\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("/* original code*/\t\t\t");
            _builder.newLine();
          }
        }
      }
    }
    _builder.append("\t");
    String _body = GenUtils.getBody(operation, FunctionScript.CLANGUAGE);
    _builder.append(_body, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }

  public static CharSequence genFunctionImplementation(final Reception reception) {
    CharSequence _xblockexpression = null;
    {
      String body = "";
      if (((reception.getOwner() instanceof org.eclipse.uml2.uml.Class) && (((org.eclipse.uml2.uml.Class) reception.getOwner()).getClassifierBehavior() instanceof StateMachine))) {
        Element _owner = reception.getOwner();
        final org.eclipse.uml2.uml.Class clazz = ((org.eclipse.uml2.uml.Class) _owner);
        SignalEvent signalEvent = null;
        int i = 0;
        Iterable<Trigger> triggers = Iterables.<Trigger>filter(clazz.getClassifierBehavior().allOwnedElements(), Trigger.class);
        while (((signalEvent == null) && (i < IterableExtensions.size(triggers)))) {
          {
            final Iterable<Trigger> _converted_triggers = (Iterable<Trigger>)triggers;
            final Trigger trigger = ((Trigger[])Conversions.unwrapArray(_converted_triggers, Trigger.class))[i];
            if (((trigger.getEvent() instanceof SignalEvent) && 
              (((SignalEvent) trigger.getEvent()).getSignal() == reception.getSignal()))) {
              Event _event = trigger.getEvent();
              signalEvent = ((SignalEvent) _event);
            }
            i++;
          }
        }
        if ((signalEvent != null)) {
          StringConcatenation _builder = new StringConcatenation();
          String _genSignalEventOperationDeclarator = FunctionScript.genSignalEventOperationDeclarator(signalEvent);
          _builder.append(_genSignalEventOperationDeclarator);
          _builder.append("(self, signal);");
          _builder.newLineIfNotEmpty();
          body = _builder.toString();
        }
      }
      StringConcatenation _builder_1 = new StringConcatenation();
      {
        EList<Comment> _ownedComments = reception.getOwnedComments();
        for(final Comment comment : _ownedComments) {
          CharSequence _genComment = CommonScript.genComment(comment);
          _builder_1.append(_genComment);
          _builder_1.newLineIfNotEmpty();
        }
      }
      _builder_1.append("void ");
      String _genFunctionDeclarator = FunctionScript.genFunctionDeclarator(reception);
      _builder_1.append(_genFunctionDeclarator);
      _builder_1.append("(");
      String _genArgumentDeclarator = FunctionScript.genArgumentDeclarator(reception);
      _builder_1.append(_genArgumentDeclarator);
      _builder_1.append(") {");
      _builder_1.newLineIfNotEmpty();
      _builder_1.append("\t");
      _builder_1.append(body, "\t");
      _builder_1.newLineIfNotEmpty();
      _builder_1.append("}");
      _builder_1.newLine();
      _builder_1.newLine();
      _xblockexpression = _builder_1;
    }
    return _xblockexpression;
  }

  public static CharSequence genCallEventProcessFunctionImplementation(final CallEvent callevent, final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Comment> _ownedComments = callevent.getOwnedComments();
      for(final Comment comment : _ownedComments) {
        CharSequence _genComment = CommonScript.genComment(comment);
        _builder.append(_genComment);
        _builder.newLineIfNotEmpty();
      }
    }
    CharSequence _genDeclarator = FunctionScript.genDeclarator(callevent.getOperation());
    _builder.append(_genDeclarator);
    CharSequence _genReturnArgumentType = FunctionScript.genReturnArgumentType(callevent.getOperation(), false);
    _builder.append(_genReturnArgumentType);
    String _genCallEventOperationDeclarator = FunctionScript.genCallEventOperationDeclarator(callevent);
    _builder.append(_genCallEventOperationDeclarator);
    _builder.append("(");
    String _genArgumentDeclarator = FunctionScript.genArgumentDeclarator(callevent.getOperation(), false);
    _builder.append(_genArgumentDeclarator);
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    String _genProcessMethodBody = StateMachineScript.genProcessMethodBody(callevent, clazz);
    _builder.append(_genProcessMethodBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }

  public static CharSequence genProcessCompletionEventFunctionImplementation(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    _builder.append("void ProcessCompletionEvent(");
    CharSequence _genName = CommonScript.genName(clazz);
    _builder.append(_genName);
    _builder.append("* self){");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    String _genProcessCompletionEventMethodBody = StateMachineScript.genProcessCompletionEventMethodBody(clazz);
    _builder.append(_genProcessCompletionEventMethodBody, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder;
  }

  public static CharSequence genSignalEventProcessFunctionImplementation(final SignalEvent signalEvent, final org.eclipse.uml2.uml.Class clazz) {
    CharSequence _xblockexpression = null;
    {
      boolean triggersClassTransition = false;
      int i = 0;
      final Iterable<Trigger> triggers = Iterables.<Trigger>filter(clazz.allOwnedElements(), Trigger.class);
      while (((!triggersClassTransition) && (i < IterableExtensions.size(triggers)))) {
        {
          if ((((((Trigger[])Conversions.unwrapArray(triggers, Trigger.class))[i]).getEvent() != null) && ((((Trigger[])Conversions.unwrapArray(triggers, Trigger.class))[i]).getEvent() == signalEvent))) {
            triggersClassTransition = true;
          }
          i++;
        }
      }
      CharSequence _xifexpression = null;
      if (triggersClassTransition) {
        StringConcatenation _builder = new StringConcatenation();
        {
          EList<Comment> _ownedComments = signalEvent.getOwnedComments();
          for(final Comment comment : _ownedComments) {
            CharSequence _genComment = CommonScript.genComment(comment);
            _builder.append(_genComment);
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("void ");
        String _genSignalEventOperationDeclarator = FunctionScript.genSignalEventOperationDeclarator(signalEvent);
        _builder.append(_genSignalEventOperationDeclarator);
        _builder.append("(");
        CharSequence _genName = CommonScript.genName(clazz);
        _builder.append(_genName);
        _builder.append("* self, ");
        CharSequence _genName_1 = CommonScript.genName(signalEvent.getSignal());
        _builder.append(_genName_1);
        _builder.append(" *sig) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        String _genProcessMethodBody = StateMachineScript.genProcessMethodBody(signalEvent, clazz);
        _builder.append(_genProcessMethodBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _xifexpression = _builder;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  public static CharSequence genFunctionPrototype(final CallEvent callEvent) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Comment> _ownedComments = callEvent.getOwnedComments();
      for(final Comment comment : _ownedComments) {
        CharSequence _genComment = CommonScript.genComment(comment);
        _builder.append(_genComment);
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
      }
    }
    CharSequence _genDeclarator = FunctionScript.genDeclarator(callEvent.getOperation());
    _builder.append(_genDeclarator);
    CharSequence _genReturnArgumentType = FunctionScript.genReturnArgumentType(callEvent.getOperation(), true);
    _builder.append(_genReturnArgumentType);
    String _genCallEventOperationDeclarator = FunctionScript.genCallEventOperationDeclarator(callEvent);
    _builder.append(_genCallEventOperationDeclarator);
    _builder.append("(");
    String _genArgumentDeclarator = FunctionScript.genArgumentDeclarator(callEvent.getOperation(), true);
    _builder.append(_genArgumentDeclarator);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    return _builder;
  }

  public static CharSequence genFunctionPrototype(final SignalEvent signalEvent, final org.eclipse.uml2.uml.Class clazz) {
    CharSequence _xblockexpression = null;
    {
      boolean triggersClassTransition = false;
      int i = 0;
      final Iterable<Trigger> triggers = Iterables.<Trigger>filter(clazz.allOwnedElements(), Trigger.class);
      while (((!triggersClassTransition) && (i < IterableExtensions.size(triggers)))) {
        {
          if ((((((Trigger[])Conversions.unwrapArray(triggers, Trigger.class))[i]).getEvent() != null) && ((((Trigger[])Conversions.unwrapArray(triggers, Trigger.class))[i]).getEvent() == signalEvent))) {
            triggersClassTransition = true;
          }
          i++;
        }
      }
      CharSequence _xifexpression = null;
      if (triggersClassTransition) {
        StringConcatenation _builder = new StringConcatenation();
        {
          EList<Comment> _ownedComments = signalEvent.getOwnedComments();
          for(final Comment comment : _ownedComments) {
            CharSequence _genComment = CommonScript.genComment(comment);
            _builder.append(_genComment);
            _builder.append(" ");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("void ");
        String _genSignalEventOperationDeclarator = FunctionScript.genSignalEventOperationDeclarator(signalEvent);
        _builder.append(_genSignalEventOperationDeclarator);
        _builder.append("(");
        CharSequence _genName = CommonScript.genName(clazz);
        _builder.append(_genName);
        _builder.append("* self, struct ");
        String _name = signalEvent.getSignal().getName();
        _builder.append(_name);
        _builder.append(" *sig);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xifexpression = _builder;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  public static CharSequence genDeclarator(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _genStorageClass = FunctionScript.genStorageClass(operation);
    _builder.append(_genStorageClass);
    CharSequence _genVolatile = FunctionScript.genVolatile(operation);
    _builder.append(_genVolatile);
    CharSequence _genConstant = FunctionScript.genConstant(operation);
    _builder.append(_genConstant);
    return _builder;
  }

  public static CharSequence genPointer(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasStereotype = GenUtils.hasStereotype(operation, Ptr.class);
      if (_hasStereotype) {
        _builder.append("* ");
      }
    }
    return _builder;
  }

  public static CharSequence genStorageClass(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasStereotype = GenUtils.hasStereotype(operation, StorageClass.class);
      if (_hasStereotype) {
        EStorageClass _storageClass = UMLUtil.<StorageClass>getStereotypeApplication(operation, StorageClass.class).getStorageClass();
        _builder.append(_storageClass);
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public static CharSequence genConstant(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasStereotype = GenUtils.hasStereotype(operation, Const.class);
      if (_hasStereotype) {
        _builder.append("const ");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public static CharSequence genVolatile(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasStereotype = GenUtils.hasStereotype(operation, StorageClass.class);
      if (_hasStereotype) {
        {
          EStorageClass _storageClass = UMLUtil.<StorageClass>getStereotypeApplication(operation, StorageClass.class).getStorageClass();
          boolean _equals = Objects.equals(_storageClass, EStorageClass.VOLATILE);
          if (_equals) {
            _builder.append("volatile ");
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public static String genArgumentDeclarator(final Operation operation, final boolean isHeader) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((!operation.isStatic()) && (!GenUtils.hasStereotype(operation, Create.class)))) {
        String _genClassArgument = FunctionScript.genClassArgument(operation);
        _builder.append(_genClassArgument);
        {
          int _size = UmlOperationServices.getArguments(operation).size();
          boolean _greaterThan = (_size > 0);
          if (_greaterThan) {
            _builder.append(", ");
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    String _genArguments = FunctionScript.genArguments(operation, isHeader);
    _builder.append(_genArguments);
    _builder.newLineIfNotEmpty();
    return _builder.toString().trim();
  }

  public static String genArgumentDeclarator(final Reception reception) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isStatic = reception.isStatic();
      if (_isStatic) {
        String _genArguments = FunctionScript.genArguments(reception);
        _builder.append(_genArguments);
        _builder.newLineIfNotEmpty();
      } else {
        String _genClassArgument = FunctionScript.genClassArgument(reception);
        _builder.append(_genClassArgument);
        _builder.append(", ");
        String _genArguments_1 = FunctionScript.genArguments(reception);
        _builder.append(_genArguments_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder.toString().trim();
  }

  public static String genCallArgumentDeclarator(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((!operation.isStatic()) && (!GenUtils.hasStereotype(operation, Create.class)))) {
        _builder.append("self");
        {
          int _size = UmlOperationServices.getArguments(operation).size();
          boolean _greaterThan = (_size > 0);
          if (_greaterThan) {
            _builder.append(", ");
          }
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
      }
    }
    String _genCallArguments = FunctionScript.genCallArguments(operation);
    _builder.append(_genCallArguments);
    _builder.newLineIfNotEmpty();
    return _builder.toString().trim();
  }

  public static String genFunctionDeclarator(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasStereotype = GenUtils.hasStereotype(operation, Ptr.class);
      if (_hasStereotype) {
        _builder.append("(*");
        CharSequence _genName = FunctionScript.genName(operation);
        _builder.append(_genName);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _genName_1 = FunctionScript.genName(operation);
        _builder.append(_genName_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder.toString().trim();
  }

  public static String genFunctionDeclarator(final Reception reception) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasStereotype = GenUtils.hasStereotype(reception, Ptr.class);
      if (_hasStereotype) {
        _builder.append("(*");
        CharSequence _genName = CommonScript.genName(reception);
        _builder.append(_genName);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _genName_1 = CommonScript.genName(reception);
        _builder.append(_genName_1);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder.toString().trim();
  }

  public static String genCallEventOperationDeclarator(final CallEvent callevent) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _genName = FunctionScript.genName(callevent.getOperation());
    String _plus = ("ProcessCE_" + _genName);
    _builder.append(_plus, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    return _builder.toString().trim();
  }

  public static String genEntryPrototype(final State state) {
    String _xblockexpression = null;
    {
      String _name = state.getName();
      String name = (_name + "_entry");
      StringConcatenation _builder = new StringConcatenation();
      _builder.newLine();
      CharSequence _behaviorDeclaration = BehaviorScript.behaviorDeclaration(name, state.getEntry());
      _builder.append(_behaviorDeclaration);
      _builder.newLineIfNotEmpty();
      _xblockexpression = _builder.toString().trim();
    }
    return _xblockexpression;
  }

  public static String genExitPrototype(final State state) {
    String _xblockexpression = null;
    {
      String _name = state.getName();
      String name = (_name + "_exit");
      StringConcatenation _builder = new StringConcatenation();
      _builder.newLine();
      _builder.append("\t");
      CharSequence _behaviorDeclaration = BehaviorScript.behaviorDeclaration(name, state.getExit());
      _builder.append(_behaviorDeclaration, "\t");
      _builder.append("\t");
      _builder.newLineIfNotEmpty();
      _xblockexpression = _builder.toString().trim();
    }
    return _xblockexpression;
  }

  public static String genDoActivityPrototype(final State state) {
    String _xblockexpression = null;
    {
      String _name = state.getName();
      String name = (_name + "_doActivity");
      StringConcatenation _builder = new StringConcatenation();
      _builder.newLine();
      _builder.append("\t");
      CharSequence _behaviorDeclaration = BehaviorScript.behaviorDeclaration(name, state.getDoActivity());
      _builder.append(_behaviorDeclaration, "\t");
      _builder.append("\t\t");
      _builder.newLineIfNotEmpty();
      _xblockexpression = _builder.toString().trim();
    }
    return _xblockexpression;
  }

  public static String genEntryImplementation(final State state) {
    String _xblockexpression = null;
    {
      String _name = state.getName();
      String name = (_name + "_entry");
      StringConcatenation _builder = new StringConcatenation();
      Behavior _entry = state.getEntry();
      CharSequence _behaviorImplementation = BehaviorScript.behaviorImplementation(name, ((OpaqueBehavior) _entry));
      _builder.append(_behaviorImplementation);
      _builder.newLineIfNotEmpty();
      _xblockexpression = _builder.toString().trim();
    }
    return _xblockexpression;
  }

  public static String genExitImplementation(final State state) {
    String _xblockexpression = null;
    {
      String _name = state.getName();
      String name = (_name + "_exit");
      StringConcatenation _builder = new StringConcatenation();
      _builder.newLine();
      _builder.append("\t");
      Behavior _exit = state.getExit();
      CharSequence _behaviorImplementation = BehaviorScript.behaviorImplementation(name, ((OpaqueBehavior) _exit));
      _builder.append(_behaviorImplementation, "\t");
      _builder.append("\t");
      _builder.newLineIfNotEmpty();
      _xblockexpression = _builder.toString().trim();
    }
    return _xblockexpression;
  }

  public static String genDoActivityImplementation(final State state) {
    String _xblockexpression = null;
    {
      String _name = state.getName();
      String name = (_name + "_doActivity");
      StringConcatenation _builder = new StringConcatenation();
      _builder.newLine();
      _builder.append("\t");
      Behavior _doActivity = state.getDoActivity();
      CharSequence _behaviorImplementation = BehaviorScript.behaviorImplementation(name, ((OpaqueBehavior) _doActivity));
      _builder.append(_behaviorImplementation, "\t");
      _builder.append("\t\t");
      _builder.newLineIfNotEmpty();
      _xblockexpression = _builder.toString().trim();
    }
    return _xblockexpression;
  }

  public static String genSignalEventOperationDeclarator(final SignalEvent signalEvent) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _genName = CommonScript.genName(signalEvent.getSignal());
    String _plus = ("ProcessSE_" + _genName);
    _builder.append(_plus, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    return _builder.toString().trim();
  }

  public static String genClassArgument(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    {
      Namespace _namespace = operation.getNamespace();
      if ((_namespace instanceof Interface)) {
        final Function1<EList<NamedElement>, CharSequence> _function = (EList<NamedElement> it) -> {
          return CommonScript.genName(((NamedElement) it));
        };
        Iterable<CharSequence> _map = IterableExtensions.<EList<NamedElement>, CharSequence>map(InterfaceScript.getInterfaceRealizationClass(operation.getInterface()), _function);
        _builder.append(_map);
        _builder.append(" *self");
        _builder.newLineIfNotEmpty();
      } else {
        CharSequence _genName = CommonScript.genName(operation.getNamespace());
        _builder.append(_genName);
        _builder.append(" *self");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder.toString().trim();
  }

  public static String genClassArgument(final Reception reception) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _genName = CommonScript.genName(reception.getNamespace());
    _builder.append(_genName);
    _builder.append(" *self");
    _builder.newLineIfNotEmpty();
    return _builder.toString().trim();
  }

  public static String genArguments(final Operation operation, final boolean isHeader) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Parameter> _arguments = UmlOperationServices.getArguments(operation);
      boolean _hasElements = false;
      for(final Parameter parameter : _arguments) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        _builder.append(" ");
        String _genType = variableScript.genType(parameter);
        _builder.append(_genType);
        _builder.append(" ");
        CharSequence _genPointer = variableScript.genPointer(parameter);
        _builder.append(_genPointer);
        CharSequence _genName = CommonScript.genName(parameter);
        _builder.append(_genName);
        _builder.append(" ");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder.toString().trim();
  }

  public static String genArguments(final Reception reception) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("struct ");
    CharSequence _genName = CommonScript.genName(reception.getSignal());
    _builder.append(_genName);
    _builder.append(" *signal");
    _builder.newLineIfNotEmpty();
    return _builder.toString().trim();
  }

  public static String genCallArguments(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Parameter> _arguments = UmlOperationServices.getArguments(operation);
      boolean _hasElements = false;
      for(final Parameter parameter : _arguments) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        CharSequence _genName = CommonScript.genName(parameter);
        _builder.append(_genName);
        _builder.append(" ");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder.toString().trim();
  }

  /**
   * Produce return type for function declaration. In case of a constructor, return a pointer to the class struct,
   * unless otherwise specified
   * 
   * @param operation a UML operation
   * @param isHeader if true, generate code for a header file
   */
  public static CharSequence genReturnArgumentType(final Operation operation, final boolean isHeader) {
    StringConcatenation _builder = new StringConcatenation();
    {
      Parameter _returnResult = operation.getReturnResult();
      boolean _tripleNotEquals = (_returnResult != null);
      if (_tripleNotEquals) {
        String _genType = variableScript.genType(operation.getReturnResult());
        _builder.append(_genType);
        CharSequence _genPointer = variableScript.genPointer(operation.getReturnResult());
        _builder.append(_genPointer);
        _builder.newLineIfNotEmpty();
      } else {
        boolean _hasStereotype = GenUtils.hasStereotype(operation, Create.class);
        if (_hasStereotype) {
          CharSequence _genName = CommonScript.genName(operation.getClass_());
          _builder.append(_genName);
          _builder.append("*");
          _builder.newLineIfNotEmpty();
        } else {
          _builder.append("void");
          _builder.newLine();
        }
      }
    }
    return _builder;
  }

  public static CharSequence genName(final Operation operation) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isStatic = operation.isStatic();
      if (_isStatic) {
        String _genVisibility = CommonScript.genVisibility(operation);
        _builder.append(_genVisibility);
        CharSequence _genCoreName = CommonScript.genCoreName(operation);
        _builder.append(_genCoreName);
        _builder.newLineIfNotEmpty();
      } else {
        {
          Namespace _namespace = operation.getNamespace();
          if ((_namespace instanceof Interface)) {
            String _genVisibility_1 = CommonScript.genVisibility(operation);
            _builder.append(_genVisibility_1);
            final Function1<EList<NamedElement>, CharSequence> _function = (EList<NamedElement> it) -> {
              return CommonScript.genName(((NamedElement) it));
            };
            Iterable<CharSequence> _map = IterableExtensions.<EList<NamedElement>, CharSequence>map(InterfaceScript.getInterfaceRealizationClass(operation.getInterface()), _function);
            _builder.append(_map);
            _builder.append("_");
            CharSequence _genCoreName_1 = CommonScript.genCoreName(operation);
            _builder.append(_genCoreName_1);
            _builder.newLineIfNotEmpty();
          } else {
            String _genVisibility_2 = CommonScript.genVisibility(operation);
            _builder.append(_genVisibility_2);
            CharSequence _genName = CommonScript.genName(operation.getNamespace());
            _builder.append(_genName);
            _builder.append("_");
            CharSequence _genCoreName_2 = CommonScript.genCoreName(operation);
            _builder.append(_genCoreName_2);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
}
