/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.visitor;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.PositionUtils;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.CompilationUnit;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.ImportDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.Node;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.PackageDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.TypeParameter;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.AnnotationDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.AnnotationMemberDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.BodyDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.ConstructorDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.EmptyMemberDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.EmptyTypeDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.EnumConstantDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.EnumDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.FieldDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.InitializerDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.MethodDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.ModifierSet;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.MultiTypeParameter;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.Parameter;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.TypeDeclaration;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.VariableDeclarator;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.body.VariableDeclaratorId;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.comments.BlockComment;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.comments.Comment;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.comments.JavadocComment;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.comments.LineComment;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.AnnotationExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.ArrayAccessExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.ArrayCreationExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.ArrayInitializerExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.AssignExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.BinaryExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.BooleanLiteralExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.CastExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.CharLiteralExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.ClassExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.ConditionalExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.DoubleLiteralExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.EnclosedExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.Expression;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.FieldAccessExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.InstanceOfExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.IntegerLiteralExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.IntegerLiteralMinValueExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.LambdaExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.LongLiteralExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.LongLiteralMinValueExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.MarkerAnnotationExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.MemberValuePair;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.MethodCallExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.MethodReferenceExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.NameExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.NormalAnnotationExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.NullLiteralExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.ObjectCreationExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.QualifiedNameExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.SingleMemberAnnotationExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.StringLiteralExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.SuperExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.ThisExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.TypeExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.UnaryExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.VariableDeclarationExpr;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.internal.Utils;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.AssertStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.BlockStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.BreakStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.CatchClause;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.ContinueStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.DoStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.EmptyStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.ExpressionStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.ForStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.ForeachStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.IfStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.LabeledStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.ReturnStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.Statement;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.SwitchEntryStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.SwitchStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.SynchronizedStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.ThrowStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.TryStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.TypeDeclarationStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.stmt.WhileStmt;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.ClassOrInterfaceType;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.IntersectionType;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.PrimitiveType;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.ReferenceType;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.Type;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.UnionType;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.UnknownType;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.VoidType;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.WildcardType;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.visitor.VoidVisitor;

public class DumpVisitor
implements VoidVisitor<Object> {
    private boolean printComments;
    private final SourcePrinter printer = this.createSourcePrinter();

    public DumpVisitor() {
        this(true);
    }

    public DumpVisitor(boolean printComments) {
        this.printComments = printComments;
    }

    protected SourcePrinter createSourcePrinter() {
        return new SourcePrinter("    ");
    }

    public String getSource() {
        return this.printer.getSource();
    }

    private void printModifiers(int modifiers) {
        if (ModifierSet.isPrivate(modifiers)) {
            this.printer.print("private ");
        }
        if (ModifierSet.isProtected(modifiers)) {
            this.printer.print("protected ");
        }
        if (ModifierSet.isPublic(modifiers)) {
            this.printer.print("public ");
        }
        if (ModifierSet.isAbstract(modifiers)) {
            this.printer.print("abstract ");
        }
        if (ModifierSet.isStatic(modifiers)) {
            this.printer.print("static ");
        }
        if (ModifierSet.isFinal(modifiers)) {
            this.printer.print("final ");
        }
        if (ModifierSet.isNative(modifiers)) {
            this.printer.print("native ");
        }
        if (ModifierSet.isStrictfp(modifiers)) {
            this.printer.print("strictfp ");
        }
        if (ModifierSet.isSynchronized(modifiers)) {
            this.printer.print("synchronized ");
        }
        if (ModifierSet.isTransient(modifiers)) {
            this.printer.print("transient ");
        }
        if (ModifierSet.isVolatile(modifiers)) {
            this.printer.print("volatile ");
        }
    }

    private void printMembers(List<BodyDeclaration> members, Object arg) {
        for (BodyDeclaration member : members) {
            this.printer.printLn();
            member.accept(this, arg);
            this.printer.printLn();
        }
    }

    private void printMemberAnnotations(List<AnnotationExpr> annotations, Object arg) {
        if (!Utils.isNullOrEmpty(annotations)) {
            for (AnnotationExpr a : annotations) {
                a.accept(this, arg);
                this.printer.printLn();
            }
        }
    }

    private void printAnnotations(List<AnnotationExpr> annotations, Object arg) {
        if (!Utils.isNullOrEmpty(annotations)) {
            for (AnnotationExpr a : annotations) {
                a.accept(this, arg);
                this.printer.print(" ");
            }
        }
    }

    private void printTypeArgs(List<Type> args, Object arg) {
        if (!Utils.isNullOrEmpty(args)) {
            this.printer.print("<");
            Iterator<Type> i = args.iterator();
            while (i.hasNext()) {
                Type t = i.next();
                t.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
    }

    private void printTypeParameters(List<TypeParameter> args, Object arg) {
        if (!Utils.isNullOrEmpty(args)) {
            this.printer.print("<");
            Iterator<TypeParameter> i = args.iterator();
            while (i.hasNext()) {
                TypeParameter t = i.next();
                t.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
    }

    private void printArguments(List<Expression> args, Object arg) {
        this.printer.print("(");
        if (!Utils.isNullOrEmpty(args)) {
            Iterator<Expression> i = args.iterator();
            while (i.hasNext()) {
                Expression e = i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
    }

    private void printJavadoc(JavadocComment javadoc, Object arg) {
        if (javadoc != null) {
            javadoc.accept(this, arg);
        }
    }

    private void printJavaComment(Comment javacomment, Object arg) {
        if (javacomment != null) {
            javacomment.accept(this, arg);
        }
    }

    @Override
    public void visit(CompilationUnit n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.getPackage() != null) {
            n.getPackage().accept(this, arg);
        }
        if (!Utils.isNullOrEmpty(n.getImports())) {
            for (ImportDeclaration importDeclaration : n.getImports()) {
                importDeclaration.accept(this, arg);
            }
            this.printer.printLn();
        }
        if (!Utils.isNullOrEmpty(n.getTypes())) {
            Iterator<TypeDeclaration> iterator = n.getTypes().iterator();
            while (iterator.hasNext()) {
                iterator.next().accept(this, arg);
                this.printer.printLn();
                if (!iterator.hasNext()) continue;
                this.printer.printLn();
            }
        }
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(PackageDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printAnnotations(n.getAnnotations(), arg);
        this.printer.print("package ");
        n.getName().accept(this, arg);
        this.printer.printLn(";");
        this.printer.printLn();
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(NameExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getName());
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(QualifiedNameExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getQualifier().accept(this, arg);
        this.printer.print(".");
        this.printer.print(n.getName());
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(ImportDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("import ");
        if (n.isStatic()) {
            this.printer.print("static ");
        }
        n.getName().accept(this, arg);
        if (n.isAsterisk()) {
            this.printer.print(".*");
        }
        this.printer.printLn(";");
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(ClassOrInterfaceDeclaration n, Object arg) {
        ClassOrInterfaceType c;
        Iterator<ClassOrInterfaceType> i;
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        if (n.isInterface()) {
            this.printer.print("interface ");
        } else {
            this.printer.print("class ");
        }
        this.printer.print(n.getName());
        this.printTypeParameters(n.getTypeParameters(), arg);
        if (!Utils.isNullOrEmpty(n.getExtends())) {
            this.printer.print(" extends ");
            i = n.getExtends().iterator();
            while (i.hasNext()) {
                c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (!Utils.isNullOrEmpty(n.getImplements())) {
            this.printer.print(" implements ");
            i = n.getImplements().iterator();
            while (i.hasNext()) {
                c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.printLn(" {");
        this.printer.indent();
        if (!Utils.isNullOrEmpty(n.getMembers())) {
            this.printMembers(n.getMembers(), arg);
        }
        this.printOrphanCommentsEnding(n);
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(EmptyTypeDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printer.print(";");
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(JavadocComment n, Object arg) {
        this.printer.print("/**");
        this.printer.print(n.getContent());
        this.printer.printLn("*/");
    }

    @Override
    public void visit(ClassOrInterfaceType n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.getAnnotations() != null) {
            for (AnnotationExpr ae : n.getAnnotations()) {
                ae.accept(this, arg);
                this.printer.print(" ");
            }
        }
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print(n.getName());
        if (n.isUsingDiamondOperator()) {
            this.printer.print("<>");
        } else {
            this.printTypeArgs(n.getTypeArgs(), arg);
        }
    }

    @Override
    public void visit(TypeParameter n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.getAnnotations() != null) {
            for (AnnotationExpr ann : n.getAnnotations()) {
                ann.accept(this, arg);
                this.printer.print(" ");
            }
        }
        this.printer.print(n.getName());
        if (!Utils.isNullOrEmpty(n.getTypeBound())) {
            this.printer.print(" extends ");
            Iterator<ClassOrInterfaceType> i = n.getTypeBound().iterator();
            while (i.hasNext()) {
                ClassOrInterfaceType c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(" & ");
            }
        }
    }

    @Override
    public void visit(PrimitiveType n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (!Utils.isNullOrEmpty(n.getAnnotations())) {
            for (AnnotationExpr ae : n.getAnnotations()) {
                ae.accept(this, arg);
                this.printer.print(" ");
            }
        }
        switch (n.getType()) {
            case Boolean: {
                this.printer.print("boolean");
                break;
            }
            case Byte: {
                this.printer.print("byte");
                break;
            }
            case Char: {
                this.printer.print("char");
                break;
            }
            case Double: {
                this.printer.print("double");
                break;
            }
            case Float: {
                this.printer.print("float");
                break;
            }
            case Int: {
                this.printer.print("int");
                break;
            }
            case Long: {
                this.printer.print("long");
                break;
            }
            case Short: {
                this.printer.print("short");
            }
        }
    }

    @Override
    public void visit(ReferenceType n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (!Utils.isNullOrEmpty(n.getAnnotations())) {
            for (AnnotationExpr ae : n.getAnnotations()) {
                ae.accept(this, arg);
                this.printer.print(" ");
            }
        }
        n.getType().accept(this, arg);
        List<List<AnnotationExpr>> arraysAnnotations = n.getArraysAnnotations();
        int i = 0;
        while (i < n.getArrayCount()) {
            List<AnnotationExpr> annotations;
            if (arraysAnnotations != null && i < arraysAnnotations.size() && !Utils.isNullOrEmpty(annotations = arraysAnnotations.get(i))) {
                for (AnnotationExpr ae : annotations) {
                    this.printer.print(" ");
                    ae.accept(this, arg);
                }
            }
            this.printer.print("[]");
            ++i;
        }
    }

    @Override
    public void visit(IntersectionType n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        boolean isFirst = true;
        for (ReferenceType element : n.getElements()) {
            element.accept(this, arg);
            if (isFirst) {
                isFirst = false;
                continue;
            }
            this.printer.print(" & ");
        }
    }

    @Override
    public void visit(UnionType n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        boolean isFirst = true;
        for (ReferenceType element : n.getElements()) {
            element.accept(this, arg);
            if (isFirst) {
                isFirst = false;
                continue;
            }
            this.printer.print(" | ");
        }
    }

    @Override
    public void visit(WildcardType n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.getAnnotations() != null) {
            for (AnnotationExpr ae : n.getAnnotations()) {
                this.printer.print(" ");
                ae.accept(this, arg);
            }
        }
        this.printer.print("?");
        if (n.getExtends() != null) {
            this.printer.print(" extends ");
            n.getExtends().accept(this, arg);
        }
        if (n.getSuper() != null) {
            this.printer.print(" super ");
            n.getSuper().accept(this, arg);
        }
    }

    @Override
    public void visit(UnknownType n, Object arg) {
    }

    @Override
    public void visit(FieldDeclaration n, Object arg) {
        this.printOrphanCommentsBeforeThisChildNode(n);
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        this.printer.print(" ");
        Iterator<VariableDeclarator> i = n.getVariables().iterator();
        while (i.hasNext()) {
            VariableDeclarator var = i.next();
            var.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
        this.printer.print(";");
    }

    @Override
    public void visit(VariableDeclarator n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getId().accept(this, arg);
        if (n.getInit() != null) {
            this.printer.print(" = ");
            n.getInit().accept(this, arg);
        }
    }

    @Override
    public void visit(VariableDeclaratorId n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getName());
        int i = 0;
        while (i < n.getArrayCount()) {
            this.printer.print("[]");
            ++i;
        }
    }

    @Override
    public void visit(ArrayInitializerExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("{");
        if (!Utils.isNullOrEmpty(n.getValues())) {
            this.printer.print(" ");
            Iterator<Expression> i = n.getValues().iterator();
            while (i.hasNext()) {
                Expression expr = i.next();
                expr.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(" ");
        }
        this.printer.print("}");
    }

    @Override
    public void visit(VoidType n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("void");
    }

    @Override
    public void visit(ArrayAccessExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getName().accept(this, arg);
        this.printer.print("[");
        n.getIndex().accept(this, arg);
        this.printer.print("]");
    }

    @Override
    public void visit(ArrayCreationExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("new ");
        n.getType().accept(this, arg);
        List<List<AnnotationExpr>> arraysAnnotations = n.getArraysAnnotations();
        if (!Utils.isNullOrEmpty(n.getDimensions())) {
            int j = 0;
            for (Expression dim : n.getDimensions()) {
                List<AnnotationExpr> annotations;
                if (arraysAnnotations != null && j < arraysAnnotations.size() && !Utils.isNullOrEmpty(annotations = arraysAnnotations.get(j))) {
                    for (AnnotationExpr ae : annotations) {
                        this.printer.print(" ");
                        ae.accept(this, arg);
                    }
                }
                this.printer.print("[");
                dim.accept(this, arg);
                this.printer.print("]");
                ++j;
            }
            int i = 0;
            while (i < n.getArrayCount()) {
                List<AnnotationExpr> annotations;
                if (arraysAnnotations != null && i < arraysAnnotations.size() && !Utils.isNullOrEmpty(annotations = arraysAnnotations.get(i))) {
                    for (AnnotationExpr ae : annotations) {
                        this.printer.print(" ");
                        ae.accept(this, arg);
                    }
                }
                this.printer.print("[]");
                ++i;
            }
        } else {
            int i = 0;
            while (i < n.getArrayCount()) {
                List<AnnotationExpr> annotations;
                if (arraysAnnotations != null && i < arraysAnnotations.size() && !Utils.isNullOrEmpty(annotations = arraysAnnotations.get(i))) {
                    for (AnnotationExpr ae : annotations) {
                        ae.accept(this, arg);
                        this.printer.print(" ");
                    }
                }
                this.printer.print("[]");
                ++i;
            }
            this.printer.print(" ");
            n.getInitializer().accept(this, arg);
        }
    }

    @Override
    public void visit(AssignExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getTarget().accept(this, arg);
        this.printer.print(" ");
        switch (n.getOperator()) {
            case assign: {
                this.printer.print("=");
                break;
            }
            case and: {
                this.printer.print("&=");
                break;
            }
            case or: {
                this.printer.print("|=");
                break;
            }
            case xor: {
                this.printer.print("^=");
                break;
            }
            case plus: {
                this.printer.print("+=");
                break;
            }
            case minus: {
                this.printer.print("-=");
                break;
            }
            case rem: {
                this.printer.print("%=");
                break;
            }
            case slash: {
                this.printer.print("/=");
                break;
            }
            case star: {
                this.printer.print("*=");
                break;
            }
            case lShift: {
                this.printer.print("<<=");
                break;
            }
            case rSignedShift: {
                this.printer.print(">>=");
                break;
            }
            case rUnsignedShift: {
                this.printer.print(">>>=");
            }
        }
        this.printer.print(" ");
        n.getValue().accept(this, arg);
    }

    @Override
    public void visit(BinaryExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getLeft().accept(this, arg);
        this.printer.print(" ");
        switch (n.getOperator()) {
            case or: {
                this.printer.print("||");
                break;
            }
            case and: {
                this.printer.print("&&");
                break;
            }
            case binOr: {
                this.printer.print("|");
                break;
            }
            case binAnd: {
                this.printer.print("&");
                break;
            }
            case xor: {
                this.printer.print("^");
                break;
            }
            case equals: {
                this.printer.print("==");
                break;
            }
            case notEquals: {
                this.printer.print("!=");
                break;
            }
            case less: {
                this.printer.print("<");
                break;
            }
            case greater: {
                this.printer.print(">");
                break;
            }
            case lessEquals: {
                this.printer.print("<=");
                break;
            }
            case greaterEquals: {
                this.printer.print(">=");
                break;
            }
            case lShift: {
                this.printer.print("<<");
                break;
            }
            case rSignedShift: {
                this.printer.print(">>");
                break;
            }
            case rUnsignedShift: {
                this.printer.print(">>>");
                break;
            }
            case plus: {
                this.printer.print("+");
                break;
            }
            case minus: {
                this.printer.print("-");
                break;
            }
            case times: {
                this.printer.print("*");
                break;
            }
            case divide: {
                this.printer.print("/");
                break;
            }
            case remainder: {
                this.printer.print("%");
            }
        }
        this.printer.print(" ");
        n.getRight().accept(this, arg);
    }

    @Override
    public void visit(CastExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("(");
        n.getType().accept(this, arg);
        this.printer.print(") ");
        n.getExpr().accept(this, arg);
    }

    @Override
    public void visit(ClassExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getType().accept(this, arg);
        this.printer.print(".class");
    }

    @Override
    public void visit(ConditionalExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getCondition().accept(this, arg);
        this.printer.print(" ? ");
        n.getThenExpr().accept(this, arg);
        this.printer.print(" : ");
        n.getElseExpr().accept(this, arg);
    }

    @Override
    public void visit(EnclosedExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("(");
        if (n.getInner() != null) {
            n.getInner().accept(this, arg);
        }
        this.printer.print(")");
    }

    @Override
    public void visit(FieldAccessExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getScope().accept(this, arg);
        this.printer.print(".");
        this.printer.print(n.getField());
    }

    @Override
    public void visit(InstanceOfExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getExpr().accept(this, arg);
        this.printer.print(" instanceof ");
        n.getType().accept(this, arg);
    }

    @Override
    public void visit(CharLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("'");
        this.printer.print(n.getValue());
        this.printer.print("'");
    }

    @Override
    public void visit(DoubleLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(IntegerLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(LongLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(IntegerLiteralMinValueExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(LongLiteralMinValueExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(StringLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("\"");
        this.printer.print(n.getValue());
        this.printer.print("\"");
    }

    @Override
    public void visit(BooleanLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(String.valueOf(n.getValue()));
    }

    @Override
    public void visit(NullLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("null");
    }

    @Override
    public void visit(ThisExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.getClassExpr() != null) {
            n.getClassExpr().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("this");
    }

    @Override
    public void visit(SuperExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.getClassExpr() != null) {
            n.getClassExpr().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("super");
    }

    @Override
    public void visit(MethodCallExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
            this.printer.print(".");
        }
        this.printTypeArgs(n.getTypeArgs(), arg);
        this.printer.print(n.getName());
        this.printArguments(n.getArgs(), arg);
    }

    @Override
    public void visit(ObjectCreationExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("new ");
        this.printTypeArgs(n.getTypeArgs(), arg);
        if (!Utils.isNullOrEmpty(n.getTypeArgs())) {
            this.printer.print(" ");
        }
        n.getType().accept(this, arg);
        this.printArguments(n.getArgs(), arg);
        if (n.getAnonymousClassBody() != null) {
            this.printer.printLn(" {");
            this.printer.indent();
            this.printMembers(n.getAnonymousClassBody(), arg);
            this.printer.unindent();
            this.printer.print("}");
        }
    }

    @Override
    public void visit(UnaryExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        switch (n.getOperator()) {
            case positive: {
                this.printer.print("+");
                break;
            }
            case negative: {
                this.printer.print("-");
                break;
            }
            case inverse: {
                this.printer.print("~");
                break;
            }
            case not: {
                this.printer.print("!");
                break;
            }
            case preIncrement: {
                this.printer.print("++");
                break;
            }
            case preDecrement: {
                this.printer.print("--");
            }
        }
        n.getExpr().accept(this, arg);
        switch (n.getOperator()) {
            case posIncrement: {
                this.printer.print("++");
                break;
            }
            case posDecrement: {
                this.printer.print("--");
            }
        }
    }

    @Override
    public void visit(ConstructorDeclaration n, Object arg) {
        Iterator<Node> i;
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        this.printTypeParameters(n.getTypeParameters(), arg);
        if (!n.getTypeParameters().isEmpty()) {
            this.printer.print(" ");
        }
        this.printer.print(n.getName());
        this.printer.print("(");
        if (!n.getParameters().isEmpty()) {
            i = n.getParameters().iterator();
            while (i.hasNext()) {
                Parameter p = i.next();
                p.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
        if (!Utils.isNullOrEmpty(n.getThrows())) {
            this.printer.print(" throws ");
            i = n.getThrows().iterator();
            while (i.hasNext()) {
                NameExpr name = (NameExpr)i.next();
                name.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(" ");
        n.getBlock().accept(this, arg);
    }

    @Override
    public void visit(MethodDeclaration n, Object arg) {
        this.printOrphanCommentsBeforeThisChildNode(n);
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        if (n.isDefault()) {
            this.printer.print("default ");
        }
        this.printTypeParameters(n.getTypeParameters(), arg);
        if (!Utils.isNullOrEmpty(n.getTypeParameters())) {
            this.printer.print(" ");
        }
        n.getType().accept(this, arg);
        this.printer.print(" ");
        this.printer.print(n.getName());
        this.printer.print("(");
        if (!Utils.isNullOrEmpty(n.getParameters())) {
            Iterator<Parameter> i = n.getParameters().iterator();
            while (i.hasNext()) {
                Parameter p = i.next();
                p.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
        int i = 0;
        while (i < n.getArrayCount()) {
            this.printer.print("[]");
            ++i;
        }
        if (!Utils.isNullOrEmpty(n.getThrows())) {
            this.printer.print(" throws ");
            Iterator<ReferenceType> i2 = n.getThrows().iterator();
            while (i2.hasNext()) {
                ReferenceType name = i2.next();
                name.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (n.getBody() == null) {
            this.printer.print(";");
        } else {
            this.printer.print(" ");
            n.getBody().accept(this, arg);
        }
    }

    @Override
    public void visit(Parameter n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        if (n.getType() != null) {
            n.getType().accept(this, arg);
        }
        if (n.isVarArgs()) {
            this.printer.print("...");
        }
        this.printer.print(" ");
        n.getId().accept(this, arg);
    }

    @Override
    public void visit(MultiTypeParameter n, Object arg) {
        this.printAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        UnionType type = n.getType();
        if (type != null) {
            ((Node)type).accept(this, arg);
        }
        this.printer.print(" ");
        n.getId().accept(this, arg);
    }

    @Override
    public void visit(ExplicitConstructorInvocationStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.isThis()) {
            this.printTypeArgs(n.getTypeArgs(), arg);
            this.printer.print("this");
        } else {
            if (n.getExpr() != null) {
                n.getExpr().accept(this, arg);
                this.printer.print(".");
            }
            this.printTypeArgs(n.getTypeArgs(), arg);
            this.printer.print("super");
        }
        this.printArguments(n.getArgs(), arg);
        this.printer.print(";");
    }

    @Override
    public void visit(VariableDeclarationExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        this.printer.print(" ");
        Iterator<VariableDeclarator> i = n.getVars().iterator();
        while (i.hasNext()) {
            VariableDeclarator v = i.next();
            v.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
    }

    @Override
    public void visit(TypeDeclarationStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getTypeDeclaration().accept(this, arg);
    }

    @Override
    public void visit(AssertStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("assert ");
        n.getCheck().accept(this, arg);
        if (n.getMessage() != null) {
            this.printer.print(" : ");
            n.getMessage().accept(this, arg);
        }
        this.printer.print(";");
    }

    @Override
    public void visit(BlockStmt n, Object arg) {
        this.printOrphanCommentsBeforeThisChildNode(n);
        this.printJavaComment(n.getComment(), arg);
        this.printer.printLn("{");
        if (n.getStmts() != null) {
            this.printer.indent();
            for (Statement s : n.getStmts()) {
                s.accept(this, arg);
                this.printer.printLn();
            }
            this.printer.unindent();
        }
        this.printOrphanCommentsEnding(n);
        this.printer.print("}");
    }

    @Override
    public void visit(LabeledStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getLabel());
        this.printer.print(": ");
        n.getStmt().accept(this, arg);
    }

    @Override
    public void visit(EmptyStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(";");
    }

    @Override
    public void visit(ExpressionStmt n, Object arg) {
        this.printOrphanCommentsBeforeThisChildNode(n);
        this.printJavaComment(n.getComment(), arg);
        n.getExpression().accept(this, arg);
        this.printer.print(";");
    }

    @Override
    public void visit(SwitchStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("switch(");
        n.getSelector().accept(this, arg);
        this.printer.printLn(") {");
        if (n.getEntries() != null) {
            this.printer.indent();
            for (SwitchEntryStmt e : n.getEntries()) {
                e.accept(this, arg);
            }
            this.printer.unindent();
        }
        this.printer.print("}");
    }

    @Override
    public void visit(SwitchEntryStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.getLabel() != null) {
            this.printer.print("case ");
            n.getLabel().accept(this, arg);
            this.printer.print(":");
        } else {
            this.printer.print("default:");
        }
        this.printer.printLn();
        this.printer.indent();
        if (n.getStmts() != null) {
            for (Statement s : n.getStmts()) {
                s.accept(this, arg);
                this.printer.printLn();
            }
        }
        this.printer.unindent();
    }

    @Override
    public void visit(BreakStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("break");
        if (n.getId() != null) {
            this.printer.print(" ");
            this.printer.print(n.getId());
        }
        this.printer.print(";");
    }

    @Override
    public void visit(ReturnStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("return");
        if (n.getExpr() != null) {
            this.printer.print(" ");
            n.getExpr().accept(this, arg);
        }
        this.printer.print(";");
    }

    @Override
    public void visit(EnumDeclaration n, Object arg) {
        Iterator<Node> i;
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        this.printer.print("enum ");
        this.printer.print(n.getName());
        if (!n.getImplements().isEmpty()) {
            this.printer.print(" implements ");
            i = n.getImplements().iterator();
            while (i.hasNext()) {
                ClassOrInterfaceType c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.printLn(" {");
        this.printer.indent();
        if (n.getEntries() != null) {
            this.printer.printLn();
            i = n.getEntries().iterator();
            while (i.hasNext()) {
                EnumConstantDeclaration e = (EnumConstantDeclaration)i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (!n.getMembers().isEmpty()) {
            this.printer.printLn(";");
            this.printMembers(n.getMembers(), arg);
        } else if (!n.getEntries().isEmpty()) {
            this.printer.printLn();
        }
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(EnumConstantDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printer.print(n.getName());
        if (n.getArgs() != null) {
            this.printArguments(n.getArgs(), arg);
        }
        if (!n.getClassBody().isEmpty()) {
            this.printer.printLn(" {");
            this.printer.indent();
            this.printMembers(n.getClassBody(), arg);
            this.printer.unindent();
            this.printer.printLn("}");
        }
    }

    @Override
    public void visit(EmptyMemberDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printer.print(";");
    }

    @Override
    public void visit(InitializerDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        if (n.isStatic()) {
            this.printer.print("static ");
        }
        n.getBlock().accept(this, arg);
    }

    @Override
    public void visit(IfStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("if (");
        n.getCondition().accept(this, arg);
        boolean thenBlock = n.getThenStmt() instanceof BlockStmt;
        if (thenBlock) {
            this.printer.print(") ");
        } else {
            this.printer.printLn(")");
            this.printer.indent();
        }
        n.getThenStmt().accept(this, arg);
        if (!thenBlock) {
            this.printer.unindent();
        }
        if (n.getElseStmt() != null) {
            if (thenBlock) {
                this.printer.print(" ");
            } else {
                this.printer.printLn();
            }
            boolean elseIf = n.getElseStmt() instanceof IfStmt;
            boolean elseBlock = n.getElseStmt() instanceof BlockStmt;
            if (elseIf || elseBlock) {
                this.printer.print("else ");
            } else {
                this.printer.printLn("else");
                this.printer.indent();
            }
            n.getElseStmt().accept(this, arg);
            if (!elseIf && !elseBlock) {
                this.printer.unindent();
            }
        }
    }

    @Override
    public void visit(WhileStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("while (");
        n.getCondition().accept(this, arg);
        this.printer.print(") ");
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(ContinueStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("continue");
        if (n.getId() != null) {
            this.printer.print(" ");
            this.printer.print(n.getId());
        }
        this.printer.print(";");
    }

    @Override
    public void visit(DoStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("do ");
        n.getBody().accept(this, arg);
        this.printer.print(" while (");
        n.getCondition().accept(this, arg);
        this.printer.print(");");
    }

    @Override
    public void visit(ForeachStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("for (");
        n.getVariable().accept(this, arg);
        this.printer.print(" : ");
        n.getIterable().accept(this, arg);
        this.printer.print(") ");
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(ForStmt n, Object arg) {
        Expression e;
        Iterator<Expression> i;
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("for (");
        if (n.getInit() != null) {
            i = n.getInit().iterator();
            while (i.hasNext()) {
                e = i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print("; ");
        if (n.getCompare() != null) {
            n.getCompare().accept(this, arg);
        }
        this.printer.print("; ");
        if (n.getUpdate() != null) {
            i = n.getUpdate().iterator();
            while (i.hasNext()) {
                e = i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(") ");
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(ThrowStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("throw ");
        n.getExpr().accept(this, arg);
        this.printer.print(";");
    }

    @Override
    public void visit(SynchronizedStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("synchronized (");
        n.getExpr().accept(this, arg);
        this.printer.print(") ");
        n.getBlock().accept(this, arg);
    }

    @Override
    public void visit(TryStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("try ");
        if (!n.getResources().isEmpty()) {
            this.printer.print("(");
            Iterator<VariableDeclarationExpr> resources = n.getResources().iterator();
            boolean first = true;
            while (resources.hasNext()) {
                this.visit(resources.next(), arg);
                if (resources.hasNext()) {
                    this.printer.print(";");
                    this.printer.printLn();
                    if (first) {
                        this.printer.indent();
                    }
                }
                first = false;
            }
            if (n.getResources().size() > 1) {
                this.printer.unindent();
            }
            this.printer.print(") ");
        }
        n.getTryBlock().accept(this, arg);
        if (n.getCatchs() != null) {
            for (CatchClause c : n.getCatchs()) {
                c.accept(this, arg);
            }
        }
        if (n.getFinallyBlock() != null) {
            this.printer.print(" finally ");
            n.getFinallyBlock().accept(this, arg);
        }
    }

    @Override
    public void visit(CatchClause n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(" catch (");
        n.getParam().accept(this, arg);
        this.printer.print(") ");
        n.getCatchBlock().accept(this, arg);
    }

    @Override
    public void visit(AnnotationDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        this.printer.print("@interface ");
        this.printer.print(n.getName());
        this.printer.printLn(" {");
        this.printer.indent();
        if (n.getMembers() != null) {
            this.printMembers(n.getMembers(), arg);
        }
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(AnnotationMemberDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        this.printer.print(" ");
        this.printer.print(n.getName());
        this.printer.print("()");
        if (n.getDefaultValue() != null) {
            this.printer.print(" default ");
            n.getDefaultValue().accept(this, arg);
        }
        this.printer.print(";");
    }

    @Override
    public void visit(MarkerAnnotationExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("@");
        n.getName().accept(this, arg);
    }

    @Override
    public void visit(SingleMemberAnnotationExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("@");
        n.getName().accept(this, arg);
        this.printer.print("(");
        n.getMemberValue().accept(this, arg);
        this.printer.print(")");
    }

    @Override
    public void visit(NormalAnnotationExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("@");
        n.getName().accept(this, arg);
        this.printer.print("(");
        if (n.getPairs() != null) {
            Iterator<MemberValuePair> i = n.getPairs().iterator();
            while (i.hasNext()) {
                MemberValuePair m = i.next();
                m.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
    }

    @Override
    public void visit(MemberValuePair n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getName());
        this.printer.print(" = ");
        n.getValue().accept(this, arg);
    }

    @Override
    public void visit(LineComment n, Object arg) {
        if (!this.printComments) {
            return;
        }
        this.printer.print("//");
        String tmp = n.getContent();
        tmp = tmp.replace('\r', ' ');
        tmp = tmp.replace('\n', ' ');
        this.printer.printLn(tmp);
    }

    @Override
    public void visit(BlockComment n, Object arg) {
        if (!this.printComments) {
            return;
        }
        this.printer.print("/*");
        this.printer.print(n.getContent());
        this.printer.printLn("*/");
    }

    @Override
    public void visit(LambdaExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        List<Parameter> parameters = n.getParameters();
        boolean printPar = false;
        printPar = n.isParametersEnclosed();
        if (printPar) {
            this.printer.print("(");
        }
        if (parameters != null) {
            Iterator<Parameter> i = parameters.iterator();
            while (i.hasNext()) {
                Parameter p = i.next();
                p.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (printPar) {
            this.printer.print(")");
        }
        this.printer.print(" -> ");
        Statement body = n.getBody();
        if (body instanceof ExpressionStmt) {
            ((ExpressionStmt)body).getExpression().accept(this, arg);
        } else {
            body.accept(this, arg);
        }
    }

    @Override
    public void visit(MethodReferenceExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        Expression scope = n.getScope();
        String identifier = n.getIdentifier();
        if (scope != null) {
            n.getScope().accept(this, arg);
        }
        this.printer.print("::");
        if (!n.getTypeParameters().isEmpty()) {
            this.printer.print("<");
            Iterator<TypeParameter> i = n.getTypeParameters().iterator();
            while (i.hasNext()) {
                TypeParameter p = i.next();
                p.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
        if (identifier != null) {
            this.printer.print(identifier);
        }
    }

    @Override
    public void visit(TypeExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.getType() != null) {
            n.getType().accept(this, arg);
        }
    }

    private void printOrphanCommentsBeforeThisChildNode(Node node) {
        if (node instanceof Comment) {
            return;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return;
        }
        LinkedList<Node> everything = new LinkedList<Node>();
        everything.addAll(parent.getChildrenNodes());
        PositionUtils.sortByBeginPosition(everything);
        int positionOfTheChild = -1;
        int i = 0;
        while (i < everything.size()) {
            if (everything.get(i) == node) {
                positionOfTheChild = i;
            }
            ++i;
        }
        if (positionOfTheChild == -1) {
            throw new RuntimeException("My index not found!!! " + String.valueOf(node));
        }
        int positionOfPreviousChild = -1;
        int i2 = positionOfTheChild - 1;
        while (i2 >= 0 && positionOfPreviousChild == -1) {
            if (!(everything.get(i2) instanceof Comment)) {
                positionOfPreviousChild = i2;
            }
            --i2;
        }
        i2 = positionOfPreviousChild + 1;
        while (i2 < positionOfTheChild) {
            Node nodeToPrint = (Node)everything.get(i2);
            if (!(nodeToPrint instanceof Comment)) {
                throw new RuntimeException("Expected comment, instead " + String.valueOf(nodeToPrint.getClass()) + ". Position of previous child: " + positionOfPreviousChild + ", position of child " + positionOfTheChild);
            }
            nodeToPrint.accept(this, null);
            ++i2;
        }
    }

    private void printOrphanCommentsEnding(Node node) {
        LinkedList<Node> everything = new LinkedList<Node>();
        everything.addAll(node.getChildrenNodes());
        PositionUtils.sortByBeginPosition(everything);
        if (everything.isEmpty()) {
            return;
        }
        int commentsAtEnd = 0;
        boolean findingComments = true;
        while (findingComments && commentsAtEnd < everything.size()) {
            Node last = (Node)everything.get(everything.size() - 1 - commentsAtEnd);
            findingComments = last instanceof Comment;
            if (!findingComments) continue;
            ++commentsAtEnd;
        }
        int i = 0;
        while (i < commentsAtEnd) {
            ((Node)everything.get(everything.size() - commentsAtEnd + i)).accept(this, null);
            ++i;
        }
    }

    public static class SourcePrinter {
        private final String indentation;
        private int level = 0;
        private boolean indented = false;
        private final StringBuilder buf = new StringBuilder();

        public SourcePrinter(String indentation) {
            this.indentation = indentation;
        }

        public void indent() {
            ++this.level;
        }

        public void unindent() {
            --this.level;
        }

        private void makeIndent() {
            int i = 0;
            while (i < this.level) {
                this.buf.append(this.indentation);
                ++i;
            }
        }

        public void print(String arg) {
            if (!this.indented) {
                this.makeIndent();
                this.indented = true;
            }
            this.buf.append(arg);
        }

        public void printLn(String arg) {
            this.print(arg);
            this.printLn();
        }

        public void printLn() {
            this.buf.append(System.getProperty("line.separator"));
            this.indented = false;
        }

        public String getSource() {
            return this.buf.toString();
        }

        public String toString() {
            return this.getSource();
        }
    }
}

