/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.fcm.profile.utils;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.designer.components.FCM.Port;
import org.eclipse.papyrus.designer.components.FCM.PortKind;
import org.eclipse.papyrus.designer.components.FCM.TemplatePort;
import org.eclipse.papyrus.designer.components.fcm.profile.IMappingRule;
import org.eclipse.papyrus.designer.components.fcm.profile.ITemplateMappingRule;
import org.eclipse.papyrus.designer.transformation.base.utils.MapUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Type;

public class PortMapUtil {
    private static final String S_FORMAT = "%s";
    public static final String rootModelName = "root";
    public static final String MAPPING_RULE_ID = "fcmPortMappingRule";

    public static Class getDerivedClass(Port port, String prefix) {
        Type type = MapUtil.getOrCreateDerivedType((Element)port.getBase_Port(), (String)(prefix + S_FORMAT), (Type)port.getType(), (MapUtil.ECreateKind)MapUtil.ECreateKind.NONE);
        return type instanceof Class ? (Class)type : null;
    }

    public static Class getDerivedClass(Port port, String prefix, boolean update) {
        return update ? PortMapUtil.getOrCreateDerivedClass(port, prefix) : PortMapUtil.getDerivedClass(port, prefix);
    }

    public static Interface getDerivedInterface(Port port, String prefix) {
        Type type = MapUtil.getOrCreateDerivedType((Element)port.getBase_Port(), (String)(prefix + S_FORMAT), (Type)port.getType(), (MapUtil.ECreateKind)MapUtil.ECreateKind.NONE);
        return type instanceof Interface ? (Interface)type : null;
    }

    public static Interface getDerivedInterface(Port port, String prefix, boolean update) {
        return update ? PortMapUtil.getOrCreateDerivedInterface(port, prefix) : PortMapUtil.getDerivedInterface(port, prefix);
    }

    public static Class getOrCreateDerivedClass(Port port, String prefix) {
        Type type = MapUtil.getOrCreateDerivedType((Element)port.getBase_Port(), (String)(prefix + S_FORMAT), (Type)port.getType(), (MapUtil.ECreateKind)MapUtil.ECreateKind.CLASS);
        return type instanceof Class ? (Class)type : null;
    }

    public static Interface getOrCreateDerivedInterface(Port port, String prefix) {
        Type type = MapUtil.getOrCreateDerivedType((Element)port.getBase_Port(), (String)(prefix + S_FORMAT), (Type)port.getType(), (MapUtil.ECreateKind)MapUtil.ECreateKind.INTERFACE);
        return type instanceof Interface ? (Interface)type : null;
    }

    public static Type getDerivedType(Port port) {
        String ruleName;
        IMappingRule mappingRule;
        if (port.getBase_Port() == null) {
            return null;
        }
        PortKind portKind = port.getKind();
        if (portKind != null && (mappingRule = PortMapUtil.getMappingRule(ruleName = portKind.isExtendedPort() ? "ExtendedPort" : portKind.getBase_Class().getName())) != null) {
            return mappingRule.calcDerivedType(port, false);
        }
        return null;
    }

    public static IMappingRule getMappingRule(String portKindName) {
        IConfigurationElement[] configElements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configElements = reg.getConfigurationElementsFor("org.eclipse.papyrus.designer.components.fcm.profile.fcmPortMappingRule");
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                Object obj;
                String extPortKindName = configElement.getAttribute("portKindName");
                if (extPortKindName.equals(portKindName) && (obj = configElement.createExecutableExtension("class")) instanceof IMappingRule) {
                    return (IMappingRule)obj;
                }
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        return null;
    }

    public static IMappingRule getMappingRule(Port port) {
        if (port.getBase_Port() == null) {
            return null;
        }
        PortKind portKind = port.getKind();
        if (portKind == null) {
            return null;
        }
        if (portKind.getBase_Class() != null) {
            String ruleName;
            String string = ruleName = portKind.isExtendedPort() ? "ExtendedPort" : portKind.getBase_Class().getName();
            if (port instanceof TemplatePort) {
                ruleName = "TemplatePort";
            }
            return PortMapUtil.getMappingRule(ruleName);
        }
        return null;
    }

    public static PortKind getBoundType(Port port) {
        if (port.getBase_Port() == null) {
            return null;
        }
        String ruleName = "TemplatePort";
        IMappingRule mappingRule = PortMapUtil.getMappingRule(ruleName);
        if (mappingRule instanceof ITemplateMappingRule) {
            return ((ITemplateMappingRule)mappingRule).getBoundType(port);
        }
        return null;
    }

    public static void update(Port port) {
        IMappingRule mappingRule = PortMapUtil.getMappingRule(port);
        if (mappingRule != null) {
            Type type = mappingRule.calcDerivedType(port, true);
            port.getBase_Port().setType(type);
            if (mappingRule instanceof ITemplateMappingRule) {
                ((ITemplateMappingRule)mappingRule).updateBinding(port);
            }
        }
    }

    public static boolean needsUpdate(Port port) {
        IMappingRule mappingRule = PortMapUtil.getMappingRule(port);
        if (mappingRule != null) {
            return mappingRule.needsUpdate(port);
        }
        return false;
    }
}

