/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.jdt.project;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.AbstractSettings;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangProjectSupport;
import org.eclipse.papyrus.designer.languages.java.jdt.project.Activator;
import org.eclipse.papyrus.designer.languages.java.jdt.project.Messages;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Package;

public class JavaProjectSupport
implements ILangProjectSupport {
    private static final String ORG_ECLIPSE_JDT_LAUNCHING_JRE_CONTAINER = "org.eclipse.jdt.launching.JRE_CONTAINER";

    public IProject createProject(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            if (!project.exists()) {
                project.create((IProgressMonitor)monitor);
                project.open((IProgressMonitor)monitor);
            }
            IProjectDescription description = project.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
            project.setDescription(description, null);
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IFolder binFolder = project.getFolder("bin");
            if (!binFolder.exists()) {
                binFolder.create(false, true, null);
            }
            javaProject.setOutputLocation(binFolder.getFullPath(), null);
            IFolder sourceFolder = project.getFolder("src");
            if (!sourceFolder.exists()) {
                sourceFolder.create(false, true, null);
            }
            IClasspathEntry[] entries = new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)new Path(ORG_ECLIPSE_JDT_LAUNCHING_JRE_CONTAINER)), JavaCore.newSourceEntry((IPath)javaProject.getPackageFragmentRoot((IResource)sourceFolder).getPath())};
            javaProject.setRawClasspath(entries, null);
            project.refreshLocal(2, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().error(Messages.JavaProjectSupport_COULD_NOT_CREATE, (Throwable)e);
        }
        if (project == null || !project.exists()) {
            throw new RuntimeException(Messages.JavaProjectSupport_COULD_NOT_CREATE);
        }
        return project;
    }

    public IProject createProject(String projectName, Package modelRoot) {
        return this.createProject(projectName);
    }

    public void setSettings(IProject project, AbstractSettings settings) {
    }

    public AbstractSettings initialConfigurationData() {
        return null;
    }

    public void gatherConfigData(Classifier implementation, AbstractSettings settings) {
    }
}

