/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.uml.domain.services.properties.ILogger;
import org.eclipse.papyrus.uml.domain.services.properties.UMLUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class PropertiesUMLServices {
    public static final String EMPTY = "";
    public static final String SPACE = " ";
    private static final String STANDARD_METACLASS = "StandardProfile::Metaclass";
    private static final String UNKNOWN_LOCATION = "Unknown";
    private final ILogger logger;

    public PropertiesUMLServices(ILogger logger) {
        this.logger = logger;
    }

    public String getLocation(Package umlPackage) {
        URI uri;
        Objects.requireNonNull(umlPackage, "None location on Null Package.");
        String location = UNKNOWN_LOCATION;
        if (umlPackage.eIsProxy()) {
            location = EcoreUtil.getURI((EObject)umlPackage).trimFragment().toString();
        } else if (umlPackage.eResource() != null && (uri = umlPackage.eResource().getURI()) != null) {
            location = uri.toString();
        }
        return location;
    }

    public Integer convertStringToInteger(Object fromObject) {
        Integer stringToInteger = null;
        if (fromObject instanceof String) {
            String newString = ((String)fromObject).replaceAll(SPACE, EMPTY);
            try {
                stringToInteger = Integer.parseInt(newString);
            }
            catch (Exception ex) {
                this.logger.log(ex.getMessage(), ILogger.ILogLevel.ERROR);
            }
        }
        return stringToInteger;
    }

    public Integer convertStringToIUnlimitedNatural(Object fromObject) {
        Integer stringToIUnlimitedNatural = 0;
        if (fromObject instanceof String) {
            String newString = ((String)fromObject).replaceAll(SPACE, EMPTY);
            if (newString.equals("*")) {
                stringToIUnlimitedNatural = -1;
            } else {
                try {
                    stringToIUnlimitedNatural = Integer.parseInt(newString);
                }
                catch (Exception ex) {
                    this.logger.log(ex.getMessage(), ILogger.ILogLevel.ERROR);
                    return null;
                }
            }
        }
        return stringToIUnlimitedNatural;
    }

    public Double convertStringToReal(Object fromObject) {
        Double stringToReal = null;
        if (fromObject instanceof String) {
            String newString = ((String)fromObject).replaceAll(SPACE, EMPTY);
            try {
                stringToReal = Double.parseDouble(newString);
            }
            catch (NumberFormatException ex) {
                this.logger.log(ex.getMessage(), ILogger.ILogLevel.ERROR);
                return null;
            }
        }
        return stringToReal;
    }

    public String convertUnlimitedNaturalToString(Object fromObject) {
        String unlimitedNaturalAsString = EMPTY;
        if (fromObject instanceof Integer) {
            unlimitedNaturalAsString = (Integer)fromObject == -1 ? "*" : Integer.toString((Integer)fromObject);
        }
        return unlimitedNaturalAsString;
    }

    public List<Boolean> getBooleanEnumerations(Element obj) {
        return Arrays.asList(Boolean.TRUE, Boolean.FALSE);
    }

    public boolean isMetaclass(Element obj) {
        if (obj instanceof Class) {
            Stereotype stereotype = UMLUtil.getAppliedStereotype(obj, STANDARD_METACLASS, false);
            return stereotype != null;
        }
        return false;
    }

    public boolean isAttachedToResource(Element obj) {
        boolean result = false;
        if (obj != null) {
            result = obj.eResource() != null;
        }
        return result;
    }

    public boolean hasEAnnotation(EObject obj) {
        if (obj instanceof EModelElement) {
            EModelElement modelElement = (EModelElement)obj;
            return modelElement.getEAnnotation("PapyrusVersion") != null;
        }
        return false;
    }

    public List<Comment> getAllAppliedComments(EObject obj) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        if (obj instanceof Element) {
            Element element = (Element)obj;
            ECrossReferenceAdapter crossReferenceAdapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)element);
            List collect = crossReferenceAdapter.getInverseReferences((EObject)element, UMLPackage.eINSTANCE.getComment_AnnotatedElement(), true).stream().map(EStructuralFeature.Setting::getEObject).filter(Comment.class::isInstance).map(Comment.class::cast).collect(Collectors.toList());
            comments.addAll(collect);
        }
        return comments;
    }
}

