/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.dev.tools.handlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.model2doc.dev.tools.Activator;
import org.eclipse.papyrus.model2doc.dev.tools.handlers.AbstractZipFileHandler;
import org.eclipse.papyrus.model2doc.dev.tools.utils.ZipUtils;

public class UnzipDocxFileHandler
extends AbstractZipFileHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        for (URI uri : this.getSelectedFileURI()) {
            String docxFileLocation = UnzipDocxFileHandler.getOSPathFromURI(uri);
            try {
                ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(docxFileLocation));
                String outputFolder = UnzipDocxFileHandler.getOSPathFromURI(uri.trimFileExtension());
                File f = new File(outputFolder);
                ZipUtils.extract(zipInputStream, f);
                UnzipDocxFileHandler.refreshWorkspace();
                UnzipDocxFileHandler.formatAllXMLFiles(f);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
        try {
            Activator.log.info("Refresh workspace");
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.log.error("Exception during workspace refresh", (Throwable)e);
        }
        return null;
    }

    private static final void formatAllXMLFiles(File folder) {
        for (File current : UnzipDocxFileHandler.getAllOwnedFiles(folder)) {
            String path = current.getAbsolutePath();
            UnzipDocxFileHandler.formatXMLFile(path);
        }
    }

    private static final List<File> getAllOwnedFiles(File folder) {
        ArrayList<File> files = new ArrayList<File>();
        List<File> tmp = Arrays.asList(folder.listFiles());
        files.addAll(tmp);
        for (File current : tmp) {
            if (!current.isDirectory()) continue;
            files.addAll(UnzipDocxFileHandler.getAllOwnedFiles(current));
        }
        return files;
    }

    @Override
    protected String getTemplateExtension() {
        return "dotx";
    }

    @Override
    protected String getFileExtension() {
        return "docx";
    }
}

