/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.structure2document.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Document;
import org.eclipse.papyrus.model2doc.emf.structure2document.Activator;
import org.eclipse.papyrus.model2doc.emf.structure2document.generator.IStructure2DocumentGenerator;

public final class Structure2DocumentRegistry {
    private final String EXTENSION_ID = "org.eclipse.papyrus.model2doc.emf.structure2document.documentgenerator";
    private static final String GENERATOR = "generator";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String ID_ATTRIBUTE = "id";
    private Map<String, IStructure2DocumentGenerator> generators = new HashMap<String, IStructure2DocumentGenerator>();
    public static final Structure2DocumentRegistry INSTANCE = new Structure2DocumentRegistry();

    private Structure2DocumentRegistry() {
        this.readContribution();
    }

    private void readContribution() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.model2doc.emf.structure2document.documentgenerator");
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            if (GENERATOR.equals(iConfigurationElement.getName())) {
                this.readDocumentStructureGeneratorContribution(iConfigurationElement);
            }
            ++n2;
        }
    }

    private void readDocumentStructureGeneratorContribution(IConfigurationElement iConfigurationElement) {
        Assert.isTrue((boolean)GENERATOR.equals(iConfigurationElement.getName()));
        String registeredId = iConfigurationElement.getAttribute(ID_ATTRIBUTE);
        IStructure2DocumentGenerator generator = null;
        try {
            generator = (IStructure2DocumentGenerator)iConfigurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
        }
        catch (CoreException e) {
            Activator.log.error(NLS.bind((String)"The generator {0} can't be loaded.", (Object)iConfigurationElement.getAttribute(CLASS_ATTRIBUTE)), (Throwable)e);
        }
        if (generator != null) {
            String expectedId;
            if (registeredId == null || registeredId.isEmpty()) {
                Activator.log.warn(NLS.bind((String)"The contributed generator {0} is ignored because you don't define id for it in your extension point contribution {1}", (Object)generator.toString(), (Object)"org.eclipse.papyrus.model2doc.emf.structure2document.documentgenerator/generator"));
            }
            if (!registeredId.equals(expectedId = generator.getGeneratorId())) {
                ArrayList<String> messageParameters = new ArrayList<String>();
                messageParameters.add(generator.toString());
                messageParameters.add(registeredId);
                messageParameters.add(expectedId);
                Activator.log.warn(NLS.bind((String)"The generator {0} is declared with the id {1} is the extension point contribution, but it should be {2} as declared inside it. We ignore it.", (Object[])messageParameters.toArray()));
                return;
            }
            if (this.generators.containsKey(registeredId)) {
                ArrayList<String> messageParameters = new ArrayList<String>();
                messageParameters.add(this.generators.get(registeredId).toString());
                messageParameters.add(generator.toString());
                messageParameters.add(registeredId);
                Activator.log.warn(NLS.bind((String)"The generators {0} and {1} are regitered with the same id {3}. We ignore the second one", (Object[])messageParameters.toArray()));
                return;
            }
            this.generators.put(registeredId, generator);
        }
    }

    public final IStructure2DocumentGenerator getGenerator(String generatorId) {
        Assert.isNotNull((Object)generatorId);
        IStructure2DocumentGenerator generator = this.generators.get(generatorId);
        if (generator == null) {
            Activator.log.warn(NLS.bind((String)"The is no generator registered with the id {0}", (Object)generatorId));
        }
        return generator;
    }

    public IStructure2DocumentGenerator getGenerator(Document document) {
        Assert.isNotNull((Object)document);
        IDocumentGeneratorConfiguration conf = document.getDocumentGeneratorConfiguration();
        if (conf != null) {
            return this.getGenerator(conf.getDocumentGeneratorId());
        }
        return null;
    }

    public List<IStructure2DocumentGenerator> getAvailableGenerators(Document document) {
        ArrayList<IStructure2DocumentGenerator> generators = new ArrayList<IStructure2DocumentGenerator>();
        for (IStructure2DocumentGenerator current : this.generators.values()) {
            if (!current.handles(document)) continue;
            generators.add(current);
        }
        return Collections.unmodifiableList(generators);
    }

    public List<IStructure2DocumentGenerator> getAllRegistredGenerators() {
        return Collections.unmodifiableList(new ArrayList<IStructure2DocumentGenerator>(this.generators.values()));
    }
}

