/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.util;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.UnoRuntime;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.odt.Activator;
import org.eclipse.papyrus.model2doc.odt.internal.util.PropertyUtil;

public class PropertySetUtil {
    private PropertySetUtil() {
    }

    public static Object getPropertyValue(Object object, String propertyName) {
        Object propertyValue = null;
        XPropertySet propertySet = null;
        propertySet = object instanceof XPropertySet ? (XPropertySet)object : (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
        if (propertySet != null) {
            try {
                propertyValue = propertySet.getPropertyValue(propertyName);
            }
            catch (Exception e) {
                propertyValue = "Not available : exception generated";
            }
        }
        return propertyValue;
    }

    public static void setProperty(Object object, String propertyName, Object propertyValue) {
        XPropertySet propertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
        if (propertySet != null) {
            try {
                propertySet.setPropertyValue(propertyName, propertyValue);
            }
            catch (IllegalArgumentException e) {
                Activator.log.error("Property " + propertyName + " argument is illegal", (Throwable)e);
            }
            catch (PropertyVetoException | UnknownPropertyException | WrappedTargetException e) {
                Activator.log.error("Could not set property " + propertyName, e);
            }
        }
    }

    public static final void displayPropertySet(XPropertySet propertySet, String relativeObjectName) {
        Assert.isNotNull((Object)propertySet);
        Assert.isNotNull((Object)relativeObjectName);
        System.out.println(NLS.bind((String)"-----------------------properties of {0}--------------------", (Object)relativeObjectName));
        XPropertySetInfo set12 = propertySet.getPropertySetInfo();
        Property[] propertyArray = set12.getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property tmp = propertyArray[n2];
            System.out.println("prop Name " + tmp.Name);
            System.out.println("prop attr " + tmp.Attributes);
            System.out.println("prop type " + String.valueOf(tmp.Type));
            System.out.println("prop value " + String.valueOf(PropertySetUtil.getPropertyValue(propertySet, tmp.Name)));
            System.out.println("\n");
            ++n2;
        }
    }

    public static final void displayPropertySet(Object object, String relativeObjectName) {
        XPropertySet propertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
        PropertySetUtil.displayPropertySet(propertySet, relativeObjectName);
    }

    public static final void copyPropertySet(XPropertySet source, XPropertySet target) {
        XPropertySetInfo pSetInfo = source.getPropertySetInfo();
        Property[] propertyArray = pSetInfo.getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property tmp = propertyArray[n2];
            if (!PropertyUtil.isReadOnly(tmp)) {
                String propName = tmp.Name;
                try {
                    target.setPropertyValue(propName, PropertySetUtil.getPropertyValue(source, propName));
                }
                catch (PropertyVetoException | UnknownPropertyException | IllegalArgumentException | WrappedTargetException e) {
                    Activator.log.error(NLS.bind((String)"An error occured during the copy of a propertySet, for the property {0}", (Object)propName), e);
                }
            }
            ++n2;
        }
    }
}

