/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.trace.capture;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.moka.trace.Activator;
import org.eclipse.papyrus.moka.trace.interfaces.capture.ICaptureServiceFactory;

public class CaptureServiceRegistry {
    public static final CaptureServiceRegistry INSTANCE = new CaptureServiceRegistry();
    private static final String EXTENSION_POINT = "org.eclipse.papyrus.moka.trace.capture";
    private static final String CLASS_PROPERTY_NAME = "class";
    private static final String NAME_PROPERTY_NAME = "name";
    private static final String ID_PROPERTY_NAME = "id";
    private Map<String, ICaptureServiceFactory> services = this.getRegisteredCaptureEngine();

    private CaptureServiceRegistry() {
    }

    public Map<String, ICaptureServiceFactory> getCaptureServices() {
        return this.services;
    }

    public ICaptureServiceFactory getCaptureService(String captureID) {
        return this.services.get(captureID);
    }

    private Map<String, ICaptureServiceFactory> getRegisteredCaptureEngine() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] config = registry.getConfigurationElementsFor(EXTENSION_POINT);
        HashMap<String, ICaptureServiceFactory> captures = new HashMap<String, ICaptureServiceFactory>();
        int i = 0;
        while (i < config.length) {
            try {
                ICaptureServiceFactory engine = (ICaptureServiceFactory)config[i].createExecutableExtension(CLASS_PROPERTY_NAME);
                String engineName = config[i].getAttribute(NAME_PROPERTY_NAME);
                engine.setName(engineName);
                String engineId = config[i].getAttribute(ID_PROPERTY_NAME);
                engine.setId(engineId);
                captures.put(engineId, engine);
            }
            catch (CoreException e) {
                Activator.getDefault().logger.error("Could not create class for " + config[i].getAttribute(CLASS_PROPERTY_NAME), (Throwable)e);
            }
            ++i;
        }
        return captures;
    }
}

