/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.target;

import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.papyrus.moka.debug.target.DebugElementStatus;
import org.eclipse.papyrus.moka.debug.target.ExecutionEngineDebugElement;
import org.eclipse.papyrus.moka.debug.target.ExecutionEngineStackFrame;
import org.eclipse.papyrus.moka.debug.target.IExecutionEngineDebugTarget;
import org.eclipse.papyrus.moka.debug.target.IExecutionEngineDebugTargetClient;
import org.eclipse.papyrus.moka.debug.target.IExecutionEngineThread;
import org.eclipse.papyrus.moka.kernel.SuspensionReasons;

public class ExecutionEngineThread
extends ExecutionEngineDebugElement
implements IExecutionEngineThread {
    public static final String MODEL_ID = "org.eclipse.papyrus.moka.kernel.debug.model";
    private String id;
    private SuspensionReasons suspensionReason;
    private ExecutionEngineStackFrame stackFrame;

    public ExecutionEngineThread(IDebugTarget target) {
        super(target);
        this.status = DebugElementStatus.RUNNING;
        this.statusLock = new ReentrantLock(true);
        this.stackFrame = new ExecutionEngineStackFrame(this);
    }

    public boolean canResume() {
        return this.getStatus().equals((Object)DebugElementStatus.SUSPENDED);
    }

    public void resume() throws DebugException {
        IExecutionEngineDebugTargetClient client;
        IExecutionEngineDebugTarget target = (IExecutionEngineDebugTarget)this.getDebugTarget();
        if (target != null && (client = target.getClient()) != null) {
            client.fireResumeThreadEvent(this);
            this.suspensionReason = SuspensionReasons.NONE;
        }
    }

    public boolean canSuspend() {
        return this.getStatus().equals((Object)DebugElementStatus.RUNNING);
    }

    public boolean isSuspended() {
        return this.getStatus().equals((Object)DebugElementStatus.SUSPENDED);
    }

    public void suspend() throws DebugException {
        IExecutionEngineDebugTargetClient client;
        IExecutionEngineDebugTarget target = (IExecutionEngineDebugTarget)this.getDebugTarget();
        if (target != null && (client = target.getClient()) != null) {
            client.fireSuspendThreadEvent(this);
            this.setStatus(DebugElementStatus.SUSPENDED);
        }
    }

    @Override
    public void handleSuspendEvent(int supensionDetail) {
        if (this.canSuspend()) {
            this.setStatus(DebugElementStatus.SUSPENDED);
            this.fireSuspendEvent(supensionDetail);
        }
    }

    public boolean canTerminate() {
        return this.getStatus().equals((Object)DebugElementStatus.RUNNING) || this.getStatus().equals((Object)DebugElementStatus.SUSPENDED);
    }

    public boolean isTerminated() {
        return this.getStatus().equals((Object)DebugElementStatus.TERMINATED);
    }

    public void terminate() throws DebugException {
        IExecutionEngineDebugTargetClient client;
        IExecutionEngineDebugTarget target = (IExecutionEngineDebugTarget)this.getDebugTarget();
        if (target != null && (client = target.getClient()) != null) {
            if (this.isSuspended()) {
                this.resume();
            }
            client.fireTerminateThreadEvent(this);
        }
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepOver() {
        return false;
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return false;
    }

    public void stepInto() throws DebugException {
    }

    public void stepOver() throws DebugException {
    }

    public void stepReturn() throws DebugException {
    }

    @Override
    public String getModelIdentifier() {
        return MODEL_ID;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspended()) {
            return new IStackFrame[]{this.stackFrame};
        }
        return new IStackFrame[0];
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        ExecutionEngineStackFrame top = null;
        if (this.isSuspended()) {
            top = this.stackFrame;
        }
        return top;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public String getName() throws DebugException {
        return this.id;
    }

    public IBreakpoint[] getBreakpoints() {
        return null;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    @Override
    public SuspensionReasons getSuspensionReason() {
        return this.suspensionReason;
    }

    public void setSuspensionReason(SuspensionReasons suspensionReason) {
        this.suspensionReason = suspensionReason;
    }
}

