/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.engine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.papyrus.moka.debug.engine.IDebuggableExecutionEngine;
import org.eclipse.papyrus.moka.debug.engine.IDebuggableExecutionEngineThread;
import org.eclipse.papyrus.moka.debug.engine.IsTargetThreadCondition;
import org.eclipse.papyrus.moka.debug.service.IDebugService;
import org.eclipse.papyrus.moka.engine.schedulable.AbstractScheduledExecutionEngine;
import org.eclipse.papyrus.moka.kernel.engine.EngineConfiguration;
import org.eclipse.papyrus.moka.kernel.engine.ExecutionEngineException;
import org.eclipse.papyrus.moka.kernel.engine.ExecutionEngineStatus;
import org.eclipse.papyrus.moka.kernel.service.ServiceRegistry;

public abstract class AbstractDebuggableExecutionEngine<ThreadType, ContextType>
extends AbstractScheduledExecutionEngine
implements IDebuggableExecutionEngine<ThreadType, ContextType> {
    protected Map<String, IDebuggableExecutionEngineThread<ThreadType, ContextType>> debuggableThread = new HashMap<String, IDebuggableExecutionEngineThread<ThreadType, ContextType>>();
    protected ReentrantLock debuggableThreadLock = new ReentrantLock(true);

    public void run(EngineConfiguration<?> configuration, SubMonitor monitor) throws ExecutionEngineException {
        this.setStatus(ExecutionEngineStatus.INITIALIZING);
        this.init(configuration, monitor);
        this.setStatus(ExecutionEngineStatus.RUNNING);
        try {
            this.start(monitor);
        }
        finally {
            this.fireTerminateExecutionEvent();
            this.setStatus(ExecutionEngineStatus.DISPOSING);
            this.dispose(monitor);
            this.setStatus(ExecutionEngineStatus.TERMINATED);
        }
    }

    @Override
    public boolean addDebugThread(IDebuggableExecutionEngineThread<ThreadType, ContextType> t) {
        boolean added = false;
        if (t != null) {
            if (!this.debuggableThreadLock.isHeldByCurrentThread()) {
                this.debuggableThreadLock.lock();
            }
            this.debuggableThread.put(t.getID(), t);
            added = this.debuggableThread.containsKey(t.getID());
            if (this.debuggableThreadLock.isHeldByCurrentThread()) {
                this.debuggableThreadLock.unlock();
            }
        }
        return added;
    }

    @Override
    public boolean removeDebugThread(IDebuggableExecutionEngineThread<ThreadType, ContextType> t) {
        boolean removed = false;
        if (t != null) {
            if (!this.debuggableThreadLock.isHeldByCurrentThread()) {
                this.debuggableThreadLock.lock();
            }
            boolean bl = removed = this.debuggableThread.remove(t.getID()) != null;
            if (this.debuggableThreadLock.isHeldByCurrentThread()) {
                this.debuggableThreadLock.unlock();
            }
        }
        return removed;
    }

    public boolean isSuspended() {
        return this.getStatus().equals((Object)ExecutionEngineStatus.SUSPENDED);
    }

    public boolean canSuspend() {
        return this.getStatus().equals((Object)ExecutionEngineStatus.RUNNING);
    }

    public void suspend() throws DebugException {
        this.getController().getExecutionLoop().suspend();
        this.setStatus(ExecutionEngineStatus.SUSPENDED);
    }

    public boolean canResume() {
        return this.getStatus().equals((Object)ExecutionEngineStatus.SUSPENDED);
    }

    public void resume() throws DebugException {
        this.getController().getExecutionLoop().resume();
        this.setStatus(ExecutionEngineStatus.RUNNING);
    }

    public boolean canTerminate() {
        return !this.isTerminated() || this.isSuspended();
    }

    public boolean isTerminated() {
        return this.getStatus().equals((Object)ExecutionEngineStatus.TERMINATED);
    }

    public void terminate() throws DebugException {
        this.getController().getExecutionLoop().terminate();
        if (!this.debuggableThreadLock.isHeldByCurrentThread()) {
            this.debuggableThreadLock.lock();
        }
        this.debuggableThread.clear();
        if (this.debuggableThreadLock.isHeldByCurrentThread()) {
            this.debuggableThreadLock.unlock();
        }
        this.setStatus(ExecutionEngineStatus.TERMINATED);
    }

    private void fireTerminateExecutionEvent() {
        IDebugService<ThreadType, ContextType> service = this.getDebugService();
        if (service != null) {
            service.fireTerminateEngineEvent();
        }
    }

    @Override
    public final IDebugService<ThreadType, ContextType> getDebugService() {
        IDebugService debugService = null;
        Iterator it = ServiceRegistry.getInstance().getService(IDebugService.class).iterator();
        if (it.hasNext()) {
            debugService = (IDebugService)it.next();
        }
        return debugService;
    }

    @Override
    public IDebuggableExecutionEngineThread<ThreadType, ContextType> getThread(String identifier) {
        IDebuggableExecutionEngineThread<ThreadType, ContextType> thread = null;
        if (!this.debuggableThreadLock.isHeldByCurrentThread()) {
            this.debuggableThreadLock.lock();
        }
        thread = this.debuggableThread.get(identifier);
        if (this.debuggableThreadLock.isHeldByCurrentThread()) {
            this.debuggableThreadLock.unlock();
        }
        return thread;
    }

    @Override
    public void suspendThread(IDebuggableExecutionEngineThread<ThreadType, ContextType> debuggableThread) {
        this.controller.getExecutionLoop().suspend(new IsTargetThreadCondition<ThreadType>(debuggableThread.getThread()));
    }

    @Override
    public void resumeThread(IDebuggableExecutionEngineThread<ThreadType, ContextType> debuggableThread) {
        this.controller.getExecutionLoop().resume(new IsTargetThreadCondition<ThreadType>(debuggableThread.getThread()));
    }

    @Override
    public void terminateThread(IDebuggableExecutionEngineThread<ThreadType, ContextType> debuggableThread) {
        this.controller.getExecutionLoop().terminate(new IsTargetThreadCondition<ThreadType>(debuggableThread.getThread()));
    }
}

