/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.kernel.engine;

import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.kernel.engine.EngineConfiguration;
import org.eclipse.papyrus.moka.kernel.engine.ExecutionEngineException;
import org.eclipse.papyrus.moka.kernel.engine.ExecutionEngineStatus;
import org.eclipse.papyrus.moka.kernel.engine.IExecutionEngine;
import org.eclipse.papyrus.moka.kernel.service.IExecutionEngineService;
import org.eclipse.papyrus.moka.kernel.service.ServiceOperatingMode;
import org.eclipse.papyrus.moka.kernel.service.ServiceRegistry;

public abstract class AbstractExecutionEngine
implements IExecutionEngine {
    private static final String INITIALIZATION_TASK = "Initialize execution engine resources";
    private static final String DISPOSE_TASK = "Dispose execution engine resources";
    protected String identifier;
    protected EngineConfiguration<?> configuration;
    protected ExecutionEngineStatus status = ExecutionEngineStatus.NONE;
    protected ReentrantLock statusLock = new ReentrantLock(true);

    @Override
    public void setID(String id) {
        this.identifier = id;
    }

    @Override
    public String getID() {
        return this.identifier;
    }

    protected void setStatus(ExecutionEngineStatus s) {
        this.statusLock.lock();
        this.status = s;
        this.statusLock.unlock();
    }

    protected ExecutionEngineStatus getStatus() {
        ExecutionEngineStatus s = null;
        this.statusLock.lock();
        s = this.status;
        this.statusLock.unlock();
        return s;
    }

    @Override
    public EngineConfiguration<?> getConfiguration() {
        return this.configuration;
    }

    @Override
    public void run(EngineConfiguration<?> configuration, SubMonitor monitor) throws ExecutionEngineException {
        this.setStatus(ExecutionEngineStatus.INITIALIZING);
        this.init(configuration, monitor);
        this.setStatus(ExecutionEngineStatus.RUNNING);
        this.start(monitor);
        this.setStatus(ExecutionEngineStatus.DISPOSING);
        this.dispose(monitor);
        this.setStatus(ExecutionEngineStatus.TERMINATED);
    }

    protected void init(EngineConfiguration<? extends EObject> configuration, SubMonitor monitor) {
        this.configuration = configuration;
        if (configuration.getMode().equals((Object)ServiceOperatingMode.NORMAL)) {
            ServiceRegistry registry = ServiceRegistry.getInstance();
            registry.loadServices(this);
            Collection<IExecutionEngineService<IExecutionEngine>> services = registry.getAllServices();
            SubMonitor progress = monitor.split(services.size());
            progress.subTask(INITIALIZATION_TASK);
            for (IExecutionEngineService<IExecutionEngine> service : services) {
                service.init(this);
                progress.worked(1);
            }
        }
    }

    protected abstract void start(SubMonitor var1) throws ExecutionEngineException;

    protected void dispose(SubMonitor monitor) {
        if (this.configuration.getMode().equals((Object)ServiceOperatingMode.NORMAL)) {
            ServiceRegistry registry = ServiceRegistry.getInstance();
            Collection<IExecutionEngineService<IExecutionEngine>> services = registry.getAllServices();
            SubMonitor progress = monitor.split(services.size());
            progress.subTask(DISPOSE_TASK);
            for (IExecutionEngineService<IExecutionEngine> service : services) {
                service.dispose(this);
                progress.worked(1);
            }
            registry.clear();
        }
    }

    public boolean canTerminate() {
        return false;
    }

    public boolean isTerminated() {
        return this.getStatus().equals((Object)ExecutionEngineStatus.TERMINATED);
    }

    public void terminate() throws DebugException {
    }
}

