/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.pssm.statemachines;

import org.eclipse.papyrus.moka.fuml.commonbehavior.IEventOccurrence;
import org.eclipse.papyrus.moka.fuml.loci.ChoiceStrategy;
import org.eclipse.papyrus.moka.pssm.profiling.VertexActivationProfiler;
import org.eclipse.papyrus.moka.pssm.statemachines.ConnectionPointActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.IRegionActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.ITransitionActivation;
import org.eclipse.papyrus.moka.pssm.statemachines.TransitionMetadata;
import org.eclipse.papyrus.moka.pssm.statemachines.VertexActivation;

public class ExitPointPseudostateActivation
extends ConnectionPointActivation {
    @Override
    public boolean isEnterable(ITransitionActivation enteringTransition, boolean staticCheck) {
        int i = 0;
        boolean isReady = super.isEnterable(enteringTransition, staticCheck);
        while (isReady && i < this.incomingTransitionActivations.size()) {
            ITransitionActivation transitionActivation = (ITransitionActivation)this.incomingTransitionActivations.get(i);
            if (enteringTransition != transitionActivation) {
                isReady = transitionActivation.isTraversed(staticCheck);
            }
            ++i;
        }
        return isReady;
    }

    @Override
    public boolean canPropagateExecution(ITransitionActivation enteringTransition, IEventOccurrence eventOccurrence, IRegionActivation leastCommonAncestor) {
        enteringTransition.setAnalyticalStatus(TransitionMetadata.TRAVERSED);
        boolean propagate = true;
        if (this.isEnterable(enteringTransition, true)) {
            this.evaluateAllGuards(eventOccurrence);
            if (this.outgoingTransitionActivations.size() > 0) {
                propagate = false;
                if (this.fireableTransitions.size() > 0) {
                    int i = 0;
                    while (!propagate && i < this.fireableTransitions.size()) {
                        propagate = ((ITransitionActivation)this.fireableTransitions.get(i)).canPropagateExecution(eventOccurrence);
                        ++i;
                    }
                }
            }
            this.tagIncomingTransitions(TransitionMetadata.NONE, true);
        }
        return propagate;
    }

    @Override
    public void enter(ITransitionActivation enteringTransition, IEventOccurrence eventOccurrence, IRegionActivation leastCommonAncestor) {
        if (this.fireableTransitions.size() > 0) {
            ITransitionActivation selectedTransitionActivation = null;
            if (this.fireableTransitions.size() == 1) {
                selectedTransitionActivation = (ITransitionActivation)this.fireableTransitions.get(0);
            } else {
                ChoiceStrategy choiceStrategy = (ChoiceStrategy)this.getExecutionLocus().getFactory().getStrategy("choice");
                int chosenIndex = choiceStrategy.choose(Integer.valueOf(this.fireableTransitions.size()));
                selectedTransitionActivation = (ITransitionActivation)this.fireableTransitions.get(chosenIndex - 1);
            }
            super.enter(enteringTransition, eventOccurrence, null);
            VertexActivation vertexActivation = this.getParentVertexActivation();
            if (vertexActivation != null) {
                IRegionActivation iRegionActivation = null;
                IEventOccurrence iEventOccurrence = eventOccurrence;
                ITransitionActivation iTransitionActivation = enteringTransition;
                VertexActivation vertexActivation2 = vertexActivation;
                try {
                    vertexActivation2.exit(iTransitionActivation, iEventOccurrence, iRegionActivation);
                }
                finally {
                    VertexActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_pssm_profiling_VertexActivationProfiler$3$a1d3df7a(vertexActivation2, iTransitionActivation, iEventOccurrence, iRegionActivation);
                }
            }
            selectedTransitionActivation.fire(eventOccurrence);
        }
    }
}

