/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.languages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.robotics.assertions.languages.ExpressionLanguagesHelper;
import org.eclipse.papyrus.robotics.assertions.languages.IExpressionLanguage;
import org.eclipse.papyrus.robotics.assertions.profile.assertions.Assertion;
import org.eclipse.papyrus.robotics.assertions.profile.assertions.Contract;
import org.eclipse.papyrus.robotics.assertions.profile.assertions.Property;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentInstance;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentOrSystem;
import org.eclipse.papyrus.robotics.profile.robotics.components.System;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class AssertionsHelper {
    public static boolean isGlobalEvaluationAssertion(Assertion assertion) {
        String language = AssertionsHelper.getAssertionLanguage(assertion);
        IExpressionLanguage langImpl = ExpressionLanguagesHelper.getExpressionLanguageByName(language);
        return langImpl != null && langImpl.isGlobalEvaluation();
    }

    public static IExpressionLanguage getGlobalEvaluationAssertion(Assertion assertion) {
        String language = AssertionsHelper.getAssertionLanguage(assertion);
        IExpressionLanguage langImpl = ExpressionLanguagesHelper.getExpressionLanguageByName(language);
        if (langImpl != null && langImpl.isGlobalEvaluation()) {
            return langImpl;
        }
        return null;
    }

    public static String getAssertionLanguage(Assertion assertion) {
        Constraint constraint = assertion.getBase_Constraint();
        if (!(constraint.getSpecification() instanceof OpaqueExpression)) {
            return null;
        }
        OpaqueExpression opaque = (OpaqueExpression)constraint.getSpecification();
        if (opaque.getLanguages() == null || opaque.getLanguages().isEmpty()) {
            return null;
        }
        String language = (String)opaque.getLanguages().get(0);
        return language;
    }

    public static EObject getContractContext(Contract contract) {
        Element owner = contract.getBase_Comment().getOwner();
        return owner;
    }

    public static List<Contract> getCompDefinitionContracts(ComponentOrSystem compDefinition) {
        ArrayList<Contract> contracts = new ArrayList<Contract>();
        TreeIterator it = compDefinition.getBase_Class().eAllContents();
        while (it.hasNext()) {
            EObject eo = (EObject)it.next();
            Contract contract = (Contract)UMLUtil.getStereotypeApplication((Element)((Element)eo), Contract.class);
            if (contract == null) continue;
            contracts.add(contract);
        }
        return contracts;
    }

    public static List<Contract> getSystemContracts(System system) {
        ArrayList<Contract> contracts = new ArrayList<Contract>();
        TreeIterator it = system.getBase_Class().eAllContents();
        while (it.hasNext()) {
            EObject eo = (EObject)it.next();
            Contract contract = (Contract)UMLUtil.getStereotypeApplication((Element)((Element)eo), Contract.class);
            if (contract == null) continue;
            contracts.add(contract);
        }
        return contracts;
    }

    public static Object evaluateConstraint(EObject userSelection, Constraint constraint) {
        if (constraint.getSpecification() instanceof OpaqueExpression) {
            Namespace context = constraint.getContext();
            if (userSelection != null && userSelection instanceof ComponentInstance) {
                context = userSelection;
            }
            return AssertionsHelper.evaluateOpaqueExpression((EObject)context, (OpaqueExpression)constraint.getSpecification());
        }
        return constraint.getSpecification().stringValue();
    }

    public static Object evaluateValueSpecification(EObject context, ValueSpecification valueSpecification) {
        if (valueSpecification instanceof OpaqueExpression) {
            return AssertionsHelper.evaluateOpaqueExpression(context, (OpaqueExpression)valueSpecification);
        }
        return valueSpecification.stringValue();
    }

    public static Object evaluateOpaqueExpression(EObject context, OpaqueExpression opaqueExpression) {
        int indexOfLangBody = -1;
        String langName = null;
        int i = 0;
        while (i < opaqueExpression.getLanguages().size() && indexOfLangBody == -1) {
            langName = (String)opaqueExpression.getLanguages().get(i);
            if (ExpressionLanguagesHelper.getExpressionLanguageByName(langName) != null && opaqueExpression.getBodies().size() > i) {
                indexOfLangBody = i;
            }
            ++i;
        }
        if (indexOfLangBody != -1) {
            IExpressionLanguage lang = ExpressionLanguagesHelper.getExpressionLanguageByName(langName);
            Object result = lang.evaluate(context, (String)opaqueExpression.getBodies().get(indexOfLangBody));
            return result;
        }
        if (opaqueExpression.getBodies().size() > 0) {
            return opaqueExpression.getBodies().get(0);
        }
        return null;
    }

    public static Map<String, ValueSpecification> getProperties(EObject context) {
        HashMap<String, ValueSpecification> properties = new HashMap<String, ValueSpecification>();
        TreeIterator it = context.eAllContents();
        while (it.hasNext()) {
            EObject eo = (EObject)it.next();
            Property property = (Property)UMLUtil.getStereotypeApplication((Element)((Element)eo), Property.class);
            if (property == null) continue;
            String name = property.getBase_Property().getName();
            ValueSpecification vs = property.getBase_Property().getDefaultValue();
            properties.put(name, vs);
        }
        return properties;
    }
}

