/**
 * Copyright (c) 2020 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 */
package org.eclipse.papyrus.robotics.codegen.common.component;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.robotics.codegen.common.utils.ActivityUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.Activity;
import org.eclipse.papyrus.robotics.profile.robotics.functions.Function;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * Create a template for the implementation class that needs to be filled
 * by a developer.
 */
@SuppressWarnings("all")
public abstract class CodeSkeleton {
  public static String POSTFIX = "_impl";

  protected org.eclipse.uml2.uml.Class component;

  public CodeSkeleton(final org.eclipse.uml2.uml.Class component) {
    this.component = component;
  }

  public void createSkeleton() {
    org.eclipse.uml2.uml.Package _nearestPackage = this.component.getNearestPackage();
    String _name = this.component.getName();
    String _plus = (_name + CodeSkeleton.POSTFIX);
    final org.eclipse.uml2.uml.Class skeleton = _nearestPackage.createOwnedClass(_plus, false);
    final Comment comment = skeleton.createOwnedComment();
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("This is a skeleton class generated for component ");
    String _name_1 = this.component.getName();
    _builder.append(_name_1);
    _builder.newLineIfNotEmpty();
    _builder.append("Copy it into the source folder as an initial base (or copy parts");
    _builder.newLine();
    _builder.append("of it whenever you add modify the component).");
    _builder.newLine();
    comment.setBody(_builder.toString());
    skeleton.createGeneralization(this.component);
    this.addConstrOp(skeleton);
    List<Activity> _activities = ActivityUtils.getActivities(this.component);
    for (final Activity activity : _activities) {
      EList<Function> _functions = activity.getFunctions();
      for (final Function function : _functions) {
        boolean _isCodeInModel = function.isCodeInModel();
        boolean _not = (!_isCodeInModel);
        if (_not) {
          this.moveFunction(skeleton, function);
        }
      }
    }
  }

  public abstract Operation addConstrOp(final org.eclipse.uml2.uml.Class skeleton);

  /**
   * Move function from generated code into skeleton (empty declaration)
   */
  public boolean moveFunction(final org.eclipse.uml2.uml.Class skeleton, final Function function) {
    boolean _xifexpression = false;
    org.eclipse.uml2.uml.Class _base_Class = function.getBase_Class();
    if ((_base_Class instanceof Behavior)) {
      boolean _xblockexpression = false;
      {
        org.eclipse.uml2.uml.Class _base_Class_1 = function.getBase_Class();
        final Behavior ob = ((Behavior) _base_Class_1);
        skeleton.getOwnedBehaviors().add(ob);
        BehavioralFeature _specification = ob.getSpecification();
        _xblockexpression = skeleton.getOwnedOperations().add(((Operation) _specification));
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }
}
