/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.codegen.common.utils;

import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.uml.tools.utils.ConnectorUtil;
import org.eclipse.papyrus.robotics.codegen.common.component.CodeSkeleton;
import org.eclipse.papyrus.robotics.core.utils.FunctionUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.Activity;
import org.eclipse.papyrus.robotics.profile.robotics.components.ActivityPort;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentDefinition;
import org.eclipse.papyrus.robotics.profile.robotics.components.PeriodicTimer;
import org.eclipse.papyrus.robotics.profile.robotics.functions.Function;
import org.eclipse.papyrus.robotics.profile.robotics.functions.FunctionKind;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class ActivityUtils {
    public static List<Activity> getActivities(Class component) {
        ComponentDefinition cd = (ComponentDefinition)UMLUtil.getStereotypeApplication((Element)component, ComponentDefinition.class);
        return cd.getActivities();
    }

    public static ActivityPort getActivityForPort(Class component, Port componentPortUml) {
        Port activityPortUml = ActivityUtils.getActivityForPortUml(component, componentPortUml);
        if (activityPortUml != null) {
            return (ActivityPort)UMLUtil.getStereotypeApplication((Element)activityPortUml, ActivityPort.class);
        }
        return null;
    }

    public static Class getActivity(Class component, Port componentPortUml) {
        Port activityPortUml = ActivityUtils.getActivityForPortUml(component, componentPortUml);
        if (activityPortUml != null) {
            return activityPortUml.getClass_();
        }
        return null;
    }

    public static Port getActivityForPortUml(Class component, Port componentPortUml) {
        try {
            List<Activity> _activities = ActivityUtils.getActivities(component);
            for (Activity activity : _activities) {
                Class activityCl = activity.getBase_Class();
                EList _ownedConnectors = component.getOwnedConnectors();
                for (Connector connector : _ownedConnectors) {
                    boolean _connectsPort = ConnectorUtil.connectsPort((Connector)connector, (Port)componentPortUml);
                    if (!_connectsPort) continue;
                    ConnectorEnd end1 = (ConnectorEnd)connector.getEnds().get(0);
                    ConnectorEnd end2 = (ConnectorEnd)connector.getEnds().get(1);
                    if (Objects.equals(end1.getRole(), null) || Objects.equals(end2.getRole(), null)) {
                        String _format = String.format("Internal connector <%s> to an activity does not target a port", ConnectorUtil.getConnectorInfo((Connector)connector));
                        throw new TransformationException(_format);
                    }
                    if (end1.getRole() != null && Objects.equals(end1.getRole().getOwner(), activityCl)) {
                        ConnectableElement _role = end1.getRole();
                        return (Port)_role;
                    }
                    if (end2.getRole() == null || !Objects.equals(end2.getRole().getOwner(), activityCl)) continue;
                    ConnectableElement _role_1 = end2.getRole();
                    return (Port)_role_1;
                }
            }
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static boolean hasExternalCode(Class component) {
        List<Activity> _activities = ActivityUtils.getActivities(component);
        for (Activity activity : _activities) {
            EList _functions = activity.getFunctions();
            for (Function function : _functions) {
                boolean _not;
                boolean _isCodeInModel = function.isCodeInModel();
                boolean bl = _not = !_isCodeInModel;
                if (!_not) continue;
                return true;
            }
        }
        return false;
    }

    public static String getPostfix(Class component) {
        boolean _hasExternalCode = ActivityUtils.hasExternalCode(component);
        if (_hasExternalCode) {
            return CodeSkeleton.POSTFIX;
        }
        return "";
    }

    public static boolean hasPeriodicActivities(Class component) {
        List<Activity> _activities = ActivityUtils.getActivities(component);
        for (Activity activity : _activities) {
            boolean _greaterThan;
            int _size = FunctionUtils.getFunctions((Activity)activity, (FunctionKind)FunctionKind.PERIODIC).size();
            boolean bl = _greaterThan = _size > 0;
            if (!_greaterThan) continue;
            return true;
        }
        return false;
    }

    public static String getPeriod(Activity activity) {
        try {
            EList _nestedClassifiers = activity.getBase_Class().getNestedClassifiers();
            for (Classifier cl : _nestedClassifiers) {
                PeriodicTimer pt = (PeriodicTimer)UMLUtil.getStereotypeApplication((Element)cl, PeriodicTimer.class);
                if (pt == null) continue;
                if (pt.getPeriod() == null || pt.getPeriod().length() == 0) {
                    Element owner = activity.getBase_Class().getOwner();
                    String componentName = "undefined";
                    if (owner instanceof NamedElement) {
                        componentName = ((NamedElement)owner).getName();
                    }
                    String _format = String.format("Activity '%s' of component '%s' defines a periodic timer, but the timer has no configured length", activity.getBase_Class().getName(), componentName);
                    throw new TransformationException(_format);
                }
                return pt.getPeriod();
            }
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

