/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.faultinjection.ui.decoration;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.infra.services.decoration.util.Decoration;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForHandlers;
import org.eclipse.papyrus.robotics.faultinjection.FIElement;
import org.eclipse.papyrus.robotics.faultinjection.FaultList;
import org.eclipse.papyrus.robotics.faultinjection.ui.Activator;
import org.eclipse.papyrus.robotics.faultinjection.ui.decoration.FIMarker;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;

public class FIDecorationUtils {
    public static void addDecoration(FIElement element, ExecutionEvent event) {
        try {
            DecorationService decorationService = (DecorationService)ServiceUtilsForHandlers.getInstance().getService(DecorationService.class, (Object)event);
            FIMarker marker = new FIMarker(element, decorationService);
            decorationService.addDecoration((IPapyrusMarker)marker, element.getPort());
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public static void removeDecorations(Element anyElement, ExecutionEvent event) {
        try {
            DecorationService decorationService = (DecorationService)ServiceUtilsForHandlers.getInstance().getService(DecorationService.class, (Object)event);
            ArrayList<String> removalList = new ArrayList<String>();
            for (Decoration d : decorationService.getDecorations().values()) {
                if (d.getType() != "org.eclipse.papyrus.robotics.faultinjection") continue;
                removalList.add(d.getId());
            }
            for (String id : removalList) {
                decorationService.removeDecoration(id);
            }
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public static void addDecorations(FaultList list, ExecutionEvent event) {
        try {
            DecorationService decorationService = (DecorationService)ServiceUtilsForHandlers.getInstance().getService(DecorationService.class, (Object)event);
            for (FIElement element : list.getElements()) {
                EObject port = element.getPort();
                if (!(port instanceof Port)) continue;
                FIMarker marker = new FIMarker(element, decorationService);
                decorationService.addDecoration((IPapyrusMarker)marker, port);
            }
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
    }
}

