/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.faultinjection.ui.menu.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.robotics.core.menu.EnhancedPopupMenu;
import org.eclipse.papyrus.robotics.faultinjection.FIElement;
import org.eclipse.papyrus.robotics.faultinjection.Fault;
import org.eclipse.papyrus.robotics.faultinjection.FaultList;
import org.eclipse.papyrus.robotics.faultinjection.FaultinjectionFactory;
import org.eclipse.papyrus.robotics.faultinjection.FaultinjectionPackage;
import org.eclipse.papyrus.robotics.faultinjection.ui.decoration.FIDecorationUtils;
import org.eclipse.papyrus.robotics.faultinjection.ui.utils.FaultInjectionUtils;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

public class NewFaultHandler
extends CmdHandler {
    public boolean isEnabled() {
        this.updateSelectedEObject();
        return FaultInjectionUtils.getFaultInjectionResource(this.selectedEObject) != null;
    }

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        if (this.selectedEObject instanceof Port) {
            IStructuredSelection selection = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            View view = null;
            for (Object currentObject : selection.toList()) {
                GraphicalEditPart editPart;
                if (!(currentObject instanceof GraphicalEditPart) || !((editPart = (GraphicalEditPart)currentObject).getModel() instanceof View)) continue;
                view = (View)editPart.getModel();
            }
            final View parentView = view != null ? ViewUtil.getContainerView(view) : null;
            final FaultList faultList = FaultInjectionUtils.getFaultList((Element)this.selectedEObject);
            if (faultList != null) {
                Object menuResult;
                ArrayList<Object> menuItems = new ArrayList<Object>();
                menuItems.add(new EnhancedPopupMenu.Disabled((Object)"Choose fault type"));
                menuItems.add(new EnhancedPopupMenu.Separator());
                EClass faultEC = FaultinjectionPackage.eINSTANCE.getFault();
                for (EClassifier cl : FaultinjectionPackage.eINSTANCE.getEClassifiers()) {
                    EClass ecl;
                    if (!(cl instanceof EClass) || !(ecl = (EClass)cl).getEAllSuperTypes().contains((Object)faultEC)) continue;
                    menuItems.add(ecl);
                }
                EnhancedPopupMenu popupMenuEvent = new EnhancedPopupMenu(menuItems, (ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof EClass) {
                            return ((EClass)element).getName();
                        }
                        if (element instanceof String) {
                            return (String)element;
                        }
                        return "";
                    }
                });
                if (popupMenuEvent.show((Control)Display.getCurrent().getActiveShell()) && (menuResult = popupMenuEvent.getSubResult()) instanceof EClass) {
                    final Fault fault = (Fault)FaultinjectionFactory.eINSTANCE.create((EClass)menuResult);
                    final TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)this.selectedEObject);
                    final RecordingCommand addSabotageFault = new RecordingCommand(ted, "Add fault"){

                        protected void doExecute() {
                            faultList.getElements().add((Object)fault);
                            fault.setPort(NewFaultHandler.this.selectedEObject);
                            if (parentView != null && parentView.getElement() instanceof Property) {
                                fault.setComponent(parentView.getElement());
                            } else {
                                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot obtain part", (String)"Component reference remains unset, please select a port of a part within an assembly diagram");
                            }
                            FIDecorationUtils.addDecoration((FIElement)fault, event);
                        }
                    };
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ted.getCommandStack().execute((Command)addSabotageFault);
                        }
                    });
                }
            }
        }
        return null;
    }
}

