/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.common.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.designer.languages.common.base.file.ProtSection;
import org.eclipse.papyrus.robotics.codegen.common.utils.ComponentUtils;
import org.eclipse.papyrus.robotics.codegen.common.utils.PackageTools;
import org.eclipse.papyrus.robotics.codegen.common.utils.TopicUtils;
import org.eclipse.papyrus.robotics.core.utils.InstanceUtils;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.core.utils.PortUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.common.launch.ConfigYAML;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.SequencerUtils;
import org.eclipse.papyrus.robotics.ros2.codegen.common.utils.SkillUtils;
import org.eclipse.papyrus.robotics.ros2.preferences.Ros2Distributions;
import org.eclipse.papyrus.uml.tools.utils.ConnectorUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class LaunchScript {
    public static CharSequence createLaunchScriptSingle(Class system, Property part, boolean addSequencer) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("from launch import LaunchDescription");
        _builder.newLine();
        if (addSequencer) {
            _builder.append("from launch_ros.descriptions import ParameterFile");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("from launch_ros.actions import ");
        if (addSequencer || InstanceUtils.isLifecycle((Property)part)) {
            _builder.append("Lifecycle");
        }
        _builder.append("Node");
        _builder.newLineIfNotEmpty();
        _builder.append("from ament_index_python.packages import get_package_share_directory");
        _builder.newLine();
        _builder.newLine();
        _builder.append("share_dir = get_package_share_directory('");
        String _pkgName = PackageTools.pkgName((Package)system.getNearestPackage());
        _builder.append(_pkgName);
        _builder.append("')");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# ");
        String _protSection = ProtSection.protSection((String)"imports");
        _builder.append(_protSection);
        _builder.newLineIfNotEmpty();
        _builder.append("# ");
        String _protSection_1 = ProtSection.protSection();
        _builder.append(_protSection_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("def generate_entity():");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# define empty user parameter (eventually redefined in the protected section afterwards)");
        _builder.newLine();
        _builder.append("\t");
        if (!addSequencer) {
            String _name = part.getName();
            _builder.append(_name, "\t");
        } else {
            String _sequencerName = SequencerUtils.getSequencerName(system);
            _builder.append(_sequencerName, "\t");
        }
        _builder.append("_custom_params = {}");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# ");
        String _protSection_2 = ProtSection.protSection((String)"parameters");
        _builder.append(_protSection_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("# ");
        String _protSection_3 = ProtSection.protSection();
        _builder.append(_protSection_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# Add the actions to the launch description.");
        _builder.newLine();
        if (!addSequencer) {
            _builder.append("\t");
            Type _type = part.getType();
            Class component = (Class)_type;
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return ");
            boolean _isLifecycle = InstanceUtils.isLifecycle((Property)part);
            if (_isLifecycle) {
                _builder.append("Lifecycle");
            }
            _builder.append("Node(");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            Ros2Distributions.RDLiteral _rosDistro = Ros2Distributions.getRosDistro();
            boolean _equals = Objects.equals(_rosDistro, Ros2Distributions.RDLiteral.ELOQUENT);
            if (_equals) {
                _builder.append("node_");
            }
            _builder.append("name='");
            String _name_1 = part.getName();
            _builder.append(_name_1, "\t\t");
            _builder.append("',");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("package='");
            String _pkgName_1 = PackageTools.pkgName((Package)component.getNearestPackage());
            _builder.append(_pkgName_1, "\t\t");
            _builder.append("', ");
            Ros2Distributions.RDLiteral _rosDistro_1 = Ros2Distributions.getRosDistro();
            boolean _equals_1 = Objects.equals(_rosDistro_1, Ros2Distributions.RDLiteral.ELOQUENT);
            if (_equals_1) {
                _builder.append("node_");
            }
            _builder.append("executable='");
            String _name_2 = component.getName();
            _builder.append(_name_2, "\t\t");
            boolean _isRegistered = ComponentUtils.isRegistered((Class)component);
            if (_isRegistered) {
                _builder.append("_main");
            }
            _builder.append("',");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("namespace='',");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("remappings=[");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            ArrayList<String> _remaps = LaunchScript.remaps(system, part);
            boolean _hasElements = false;
            for (String remap : _remaps) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t\t\t");
                }
                _builder.append(remap, "\t\t\t");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("],");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("parameters=[share_dir+'/launch/cfg/param.yaml', ");
            String _name_3 = part.getName();
            _builder.append(_name_3, "\t\t");
            _builder.append("_custom_params],");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("output='screen',");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("emulate_tty=True\t# assure that RCLCPP output gets flushed");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(")");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("return LifecycleNode(");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            Ros2Distributions.RDLiteral _rosDistro_2 = Ros2Distributions.getRosDistro();
            boolean _equals_2 = Objects.equals(_rosDistro_2, Ros2Distributions.RDLiteral.ELOQUENT);
            if (_equals_2) {
                _builder.append("node_");
            }
            _builder.append("name='");
            String _sequencerName_1 = SequencerUtils.getSequencerName(system);
            _builder.append(_sequencerName_1, "\t\t");
            _builder.append("',");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("package='bt_sequencer', ");
            Ros2Distributions.RDLiteral _rosDistro_3 = Ros2Distributions.getRosDistro();
            boolean _equals_3 = Objects.equals(_rosDistro_3, Ros2Distributions.RDLiteral.ELOQUENT);
            if (_equals_3) {
                _builder.append("node_");
            }
            _builder.append("executable='bt_sequencer',");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("namespace='',");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("parameters=[ParameterFile(share_dir+'/launch/cfg/param.yaml', allow_substs=True), ");
            String _sequencerName_2 = SequencerUtils.getSequencerName(system);
            _builder.append(_sequencerName_2, "\t\t");
            _builder.append("_custom_params],");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("output='screen',");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("emulate_tty=True\t# assure that RCLCPP output gets flushed");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(")");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("def generate_launch_description():");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# Launch Description");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ld = LaunchDescription()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ld.add_entity(generate_entity())");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# ");
        String _protSection_4 = ProtSection.protSection((String)"post-launch");
        _builder.append(_protSection_4, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("# ");
        String _protSection_5 = ProtSection.protSection();
        _builder.append(_protSection_5, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return ld");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence createLaunchScript(Class system, List<Property> parts, boolean addSequencer, boolean activate) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("import launch.actions");
        _builder.newLine();
        _builder.append("import launch_ros");
        _builder.newLine();
        _builder.append("import lifecycle_msgs.msg");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import sys");
        _builder.newLine();
        _builder.append("import os.path");
        _builder.newLine();
        _builder.newLine();
        _builder.append("from launch_ros.events.lifecycle import ChangeState");
        _builder.newLine();
        _builder.append("from launch import LaunchDescription");
        _builder.newLine();
        _builder.append("from ament_index_python.packages import get_package_share_directory");
        _builder.newLine();
        _builder.newLine();
        _builder.append("share_dir = get_package_share_directory('");
        String _pkgName = PackageTools.pkgName((Package)system.getNearestPackage());
        _builder.append(_pkgName);
        _builder.append("')");
        _builder.newLineIfNotEmpty();
        _builder.append("# generated scripts are in launch folder");
        _builder.newLine();
        _builder.append("sys.path.append(os.path.join(share_dir, 'launch'))");
        _builder.newLine();
        _builder.append("# load launch scripts for each instance");
        _builder.newLine();
        for (Property part : parts) {
            _builder.append("import launch_");
            String _name = part.getName();
            _builder.append(_name);
            _builder.newLineIfNotEmpty();
        }
        if (addSequencer) {
            _builder.append("import launch_");
            String _sequencerName = SequencerUtils.getSequencerName(system);
            _builder.append(_sequencerName);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("# ");
        String _protSection = ProtSection.protSection((String)"imports");
        _builder.append(_protSection);
        _builder.newLineIfNotEmpty();
        _builder.append("# ");
        String _protSection_1 = ProtSection.protSection();
        _builder.append(_protSection_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("def generate_launch_description():");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# Launch Description");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ld = launch.LaunchDescription()");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# call entity creation for each instance");
        _builder.newLine();
        for (Property part_1 : parts) {
            _builder.append("\t");
            String _name_1 = part_1.getName();
            _builder.append(_name_1, "\t");
            _builder.append("_node = launch_");
            String _name_2 = part_1.getName();
            _builder.append(_name_2, "\t");
            _builder.append(".generate_entity()");
            _builder.newLineIfNotEmpty();
        }
        if (addSequencer) {
            _builder.append("\t");
            String _sequencerName_1 = SequencerUtils.getSequencerName(system);
            _builder.append(_sequencerName_1, "\t");
            _builder.append("_node = launch_");
            Iterator<Property> _sequencerName_2 = SequencerUtils.getSequencerName(system);
            _builder.append((String)((Object)_sequencerName_2), "\t");
            _builder.append(".generate_entity()");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("# now add all obtained entities to the launch description");
        _builder.newLine();
        for (Property part_2 : parts) {
            _builder.append("\t");
            _builder.append("ld.add_entity(");
            String _name_3 = part_2.getName();
            _builder.append(_name_3, "\t");
            _builder.append("_node)");
            _builder.newLineIfNotEmpty();
        }
        if (addSequencer) {
            _builder.append("\t");
            _builder.append("ld.add_entity(");
            String _sequencerName_3 = SequencerUtils.getSequencerName(system);
            _builder.append(_sequencerName_3, "\t");
            _builder.append("_node)");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        if (activate) {
            _builder.append("\t");
            _builder.append("# transition to configure after startup");
            _builder.newLine();
            for (Property part_3 : parts) {
                boolean _isLifecycle = InstanceUtils.isLifecycle((Property)part_3);
                if (!_isLifecycle) continue;
                _builder.append("\t");
                CharSequence _generateConfig = LaunchScript.generateConfig(part_3.getName());
                _builder.append((Object)_generateConfig, "\t");
                _builder.newLineIfNotEmpty();
            }
            if (addSequencer) {
                _builder.append("\t");
                CharSequence _generateConfig_1 = LaunchScript.generateConfig(SequencerUtils.getSequencerName(system));
                _builder.append((Object)_generateConfig_1, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("\t");
            _builder.append("# transition to activate, once inactive");
            _builder.newLine();
            for (Property part_4 : parts) {
                boolean _isLifecycle_1 = InstanceUtils.isLifecycle((Property)part_4);
                if (!_isLifecycle_1) continue;
                _builder.append("\t");
                CharSequence _generateActivation = LaunchScript.generateActivation(part_4.getName());
                _builder.append((Object)_generateActivation, "\t");
                _builder.newLineIfNotEmpty();
            }
            if (addSequencer) {
                _builder.append("\t");
                CharSequence _generateActivation_1 = LaunchScript.generateActivation(SequencerUtils.getSequencerName(system));
                _builder.append((Object)_generateActivation_1, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# ");
        String _protSection_2 = ProtSection.protSection((String)"post-launch");
        _builder.append(_protSection_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("# ");
        String _protSection_3 = ProtSection.protSection();
        _builder.append(_protSection_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return ld");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence generateConfig(String name) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("configure_");
        _builder.append(name);
        _builder.append(" = launch.actions.RegisterEventHandler(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("launch.event_handlers.on_process_start.OnProcessStart(");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("target_action=");
        _builder.append(name, "\t\t");
        _builder.append("_node,");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("on_start=[");
        _builder.newLine();
        _builder.append(" \t\t\t");
        _builder.append("launch.actions.EmitEvent(");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("event=launch_ros.events.lifecycle.ChangeState(");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("lifecycle_node_matcher=launch.events.matches_action(");
        _builder.append(name, "\t\t\t\t\t");
        _builder.append("_node),");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t");
        _builder.append("transition_id=lifecycle_msgs.msg.Transition.TRANSITION_CONFIGURE");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append(")");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(")");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("]");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(")");
        _builder.newLine();
        _builder.append(")");
        _builder.newLine();
        _builder.append("ld.add_entity(configure_");
        _builder.append(name);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence generateActivation(String name) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("activate_");
        _builder.append(name);
        _builder.append(" = launch.actions.RegisterEventHandler(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("launch_ros.event_handlers.OnStateTransition(");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("target_lifecycle_node=");
        _builder.append(name, "\t\t");
        _builder.append("_node,");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("start_state='configuring', goal_state='inactive',");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("entities=[");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("launch.actions.EmitEvent(");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("event=launch_ros.events.lifecycle.ChangeState(");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("lifecycle_node_matcher=launch.events.matches_action(");
        _builder.append(name, "\t\t\t\t\t");
        _builder.append("_node),");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t");
        _builder.append("transition_id=lifecycle_msgs.msg.Transition.TRANSITION_ACTIVATE");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append(")");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(")");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("]");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(")");
        _builder.newLine();
        _builder.append(")");
        _builder.newLine();
        _builder.append("ld.add_entity(activate_");
        _builder.append(name);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence createLaunchScriptXML(Class system) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<launch>");
        _builder.newLine();
        List _compInstanceList = InstanceUtils.getCompInstanceList((Class)system);
        for (Property part : _compInstanceList) {
            _builder.append("\t");
            Type _type = part.getType();
            Class component = (Class)_type;
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("<node pkg=\"");
            String _pkgName = PackageTools.pkgName((Package)component.getNearestPackage());
            _builder.append(_pkgName, "\t");
            _builder.append("\" exec=\"");
            String _name = component.getName();
            _builder.append(_name, "\t");
            _builder.append("\" name=\"");
            String _name_1 = part.getName();
            _builder.append(_name_1, "\t");
            _builder.append("\" respawn=\"false\" output=\"screen\">");
            _builder.newLineIfNotEmpty();
            ArrayList<String> _remapsXML = LaunchScript.remapsXML(system, part);
            for (String remap : _remapsXML) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append(remap, "\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("<param from=\"$(find-pkg-share ");
            String _pkgName_1 = PackageTools.pkgName((Package)component.getNearestPackage());
            _builder.append(_pkgName_1, "\t\t");
            _builder.append(")/launch/cfg/param.yaml\"/>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("</node>");
            _builder.newLine();
        }
        _builder.append("</launch>");
        _builder.newLine();
        return _builder;
    }

    public static ArrayList<String> remapsXML(Class system, Property part) {
        ArrayList<String> remaps = new ArrayList<String>();
        Type _type = part.getType();
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)((Class)_type));
        for (Port port : _allPorts) {
            String to;
            boolean _notEquals;
            ConnectorEnd oppositeEnd = LaunchScript.getOpposite(system, part, port);
            if (oppositeEnd == null) continue;
            String from = TopicUtils.getTopic((Port)port);
            boolean bl = _notEquals = !Objects.equals(from, to = TopicUtils.getTopic((Property)part, (Port)port, (ConnectorEnd)oppositeEnd));
            if (!_notEquals) continue;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("<remap from=\"");
            _builder.append(from);
            _builder.append("\" to=\"");
            _builder.append(to);
            _builder.append("\"/>");
            remaps.add(_builder.toString());
        }
        return remaps;
    }

    public static CharSequence remapsCmd(Class system, Property part) {
        StringConcatenation _builder = new StringConcatenation();
        Type _type = part.getType();
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)((Class)_type));
        boolean _hasElements = false;
        for (Port port : _allPorts) {
            boolean _notEquals;
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" ", "");
            }
            ConnectorEnd oppositeEnd = LaunchScript.getOpposite(system, part, port);
            _builder.newLineIfNotEmpty();
            if (oppositeEnd == null) continue;
            String from = TopicUtils.getTopic((Port)port);
            _builder.newLineIfNotEmpty();
            String to = TopicUtils.getTopic((Property)part, (Port)port, (ConnectorEnd)oppositeEnd);
            _builder.newLineIfNotEmpty();
            boolean bl = _notEquals = !Objects.equals(from, to);
            if (!_notEquals) continue;
            _builder.append("-r ");
            String _topic = TopicUtils.getTopic((Port)port);
            _builder.append(_topic);
            _builder.append(":=");
            String _topic_1 = TopicUtils.getTopic((Property)part, (Port)port, (ConnectorEnd)oppositeEnd);
            _builder.append(_topic_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static ArrayList<String> remaps(Class system, Property part) {
        ArrayList<String> remaps = new ArrayList<String>();
        Type _type = part.getType();
        EList _allPorts = PortUtils.getAllPorts((EncapsulatedClassifier)((Class)_type));
        for (Port port : _allPorts) {
            boolean _not;
            String to;
            ConnectorEnd oppositeEnd = LaunchScript.getOpposite(system, part, port);
            if (oppositeEnd == null || InteractionUtils.getCommObject((Port)port) == null) continue;
            String from = TopicUtils.getTopic((Port)port);
            boolean _equals = from.equals(to = TopicUtils.getTopic((Property)part, (Port)port, (ConnectorEnd)oppositeEnd));
            boolean bl = _not = !_equals;
            if (!_not) continue;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("('");
            _builder.append(from);
            _builder.append("', '");
            _builder.append(to);
            _builder.append("')");
            remaps.add(_builder.toString());
        }
        return remaps;
    }

    public static ConnectorEnd getOpposite(Class system, Property part, Port port) {
        EList _ownedConnectors = system.getOwnedConnectors();
        for (Connector connector : _ownedConnectors) {
            ConnectorEnd end;
            boolean _connectsPort = ConnectorUtil.connectsPort((Connector)connector, (Port)port);
            if (!_connectsPort || (end = ConnectorUtil.connEndNotPart((Connector)connector, (Property)part)) == null) continue;
            return end;
        }
        return null;
    }

    public static void generateLaunch(IPFileSystemAccess fileAccess, Class system) {
        List parts = InstanceUtils.getCompInstanceList((Class)system);
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(SkillUtils.getUniqueSkills(system));
        boolean addSequencer = !_isNullOrEmpty;
        fileAccess.generateFile("launch/launch.py", LaunchScript.createLaunchScript(system, parts, addSequencer, false).toString());
        fileAccess.generateFile("launch/activate.py", LaunchScript.createLaunchScript(system, parts, addSequencer, true).toString());
        for (Property part : parts) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("launch/launch_");
            String _name = part.getName();
            _builder.append(_name);
            _builder.append(".py");
            fileAccess.generateFile(_builder.toString(), LaunchScript.createLaunchScriptSingle(system, part, false).toString());
            boolean _isLifecycle = InstanceUtils.isLifecycle((Property)part);
            if (!_isLifecycle) continue;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("launch/activate_");
            String _name_1 = part.getName();
            _builder_1.append(_name_1);
            _builder_1.append(".py");
            fileAccess.generateFile(_builder_1.toString(), LaunchScript.createLaunchScript(system, Collections.singletonList(part), false, true).toString());
        }
        boolean _since = Ros2Distributions.since((Ros2Distributions.RDLiteral)Ros2Distributions.getRosDistro(), (Ros2Distributions.RDLiteral)Ros2Distributions.RDLiteral.GALACTIC);
        if (_since) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("launch/");
            String _name = system.getName();
            _builder.append(_name);
            _builder.append(".launch");
            fileAccess.generateFile(_builder.toString(), LaunchScript.createLaunchScriptXML(system).toString());
        }
        if (addSequencer) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("launch/launch_");
            String _sequencerName = SequencerUtils.getSequencerName(system);
            _builder_1.append(_sequencerName);
            _builder_1.append(".py");
            fileAccess.generateFile(_builder_1.toString(), LaunchScript.createLaunchScriptSingle(system, null, true).toString());
        }
        fileAccess.generateFile("launch/cfg/param.yaml", ConfigYAML.createParameterFile(system).toString());
    }
}

