// --------------------------------------------------------
// Copyright (c)
//
// contributions by Ansgar
//                  ansgar.radermacher@cea.fr
// maintained by    CEA LIST
//                  info-list@cea.fr

// --------------------------------------------------------
// Code generated by Papyrus C++
// --------------------------------------------------------

#define addClientCompdef_AddClient_impl_BODY

/************************************************************
 AddClient_impl class body
 ************************************************************/

// include associated header file
#include "addClientCompdef/AddClient_impl.h"

// Derived includes directives
#include "rclcpp/rclcpp.hpp"

using namespace std::chrono_literals;

namespace addClientCompdef {

// static attributes (if any)

/**
 * 
 * @param options 
 */
AddClient_impl::AddClient_impl(rclcpp::NodeOptions /*in*/options) :
    AddClient(options) {
}

/**
 * 
 */
void AddClient_impl::fOnActivate() {
  RCLCPP_INFO(get_logger(), "on activate, call \"add\" in a new thread");
  std::thread { std::bind(&AddClient_impl::fCallAdd, this) }.detach();
}

/**
 * 
 */
void AddClient_impl::fCallAdd() {
  auto request = std::make_shared<simple_msgs::srv::AddServiceDef::Request>();
  request->x = 2;
  request->y = 3;

  RCLCPP_INFO(get_logger(), "doing request");

  // use a call in which the future is polled first
  auto result_future = useAdd_client_->async_send_request(request);

  if (result_future.wait_for(std::chrono::seconds(5s))
      != std::future_status::ready) {
    RCLCPP_ERROR(get_logger(),
        "service call failed. This happens, since the call is executed within the periodic timer call");
  } else {
    auto result = result_future.get();
    RCLCPP_INFO(get_logger(), "result via polling = %d", result->sum);
  }

  // now make a call referencing a callback (by calling a member function, a lambda would have been
  // possible as well)
  useAdd_client_->async_send_request(request,
      std::bind(&AddClient_impl::fResultCallback, this, std::placeholders::_1));
}

/**
 * 
 * @param future 
 */
void AddClient_impl::fResultCallback(
    rclcpp::Client<simple_msgs::srv::AddServiceDef>::SharedFuture /*in*/future) {
  auto result = future.get();
  RCLCPP_INFO(get_logger(), "result via callback = %d", result->sum);
}

/**
 * 
 */
void AddClient_impl::fPeriodic() {
  RCLCPP_INFO(get_logger(), "periodic, call \"add\" directly");
  fCallAdd();
}

} // of namespace addClientCompdef

/************************************************************
 End of AddClient_impl class body
 ************************************************************/
