/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.preferences.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PathEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.papyrus.robotics.ros2.preferences.Ros2Distributions;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class Ros2CodeGenPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    protected ComboFieldEditor distroEditor;
    protected PathEditor pathEditor;

    public Ros2CodeGenPreferencePage() {
        super(1);
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.papyrus.robotics.ros2.preferences");
        this.setPreferenceStore((IPreferenceStore)store);
        this.setDescription("This preferences page allows to customize ROS 2 C++ code generation/reverse");
    }

    public void addTextField(String name, String label, Document currentDoc) {
        Group txtGroup = new Group(this.getFieldEditorParent(), 16);
        txtGroup.setLayout((Layout)new FillLayout());
        txtGroup.setText(label);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        txtGroup.setLayoutData((Object)gd);
        SourceViewer txtViewer = new SourceViewer((Composite)txtGroup, null, 2818);
        txtViewer.setDocument((IDocument)currentDoc);
        String content = this.getPreferenceStore().getString(name);
        currentDoc.set(content);
    }

    public void createFieldEditors() {
        ArrayList<String[]> distributions = new ArrayList<String[]>();
        Ros2Distributions.RDLiteral[] rDLiteralArray = Ros2Distributions.RDLiteral.values();
        int n = rDLiteralArray.length;
        int n2 = 0;
        while (n2 < n) {
            Ros2Distributions.RDLiteral lit = rDLiteralArray[n2];
            if (lit != Ros2Distributions.RDLiteral.UNKNOWN) {
                String name = Ros2Distributions.getDistroName((Ros2Distributions.RDLiteral)lit);
                distributions.add(new String[]{name, name});
            }
            ++n2;
        }
        Composite parent = this.getFieldEditorParent();
        this.distroEditor = new ComboFieldEditor("rosDistro", "ROS 2 distribution", (String[][])distributions.toArray((T[])new String[2][0]), parent);
        this.addField((FieldEditor)this.distroEditor);
        this.pathEditor = new PathEditor("rosSetupPath", "List of paths (that must contain a setup.bash file) to source", "select a directory with a ROS 2 setup.bash", parent);
        this.addField((FieldEditor)this.pathEditor);
        this.addField((FieldEditor)new StringFieldEditor("colcon-options", "colcon build options", parent));
        this.addField((FieldEditor)new StringFieldEditor("colcon-packages", "colcon switch to select a certain package (or set thereof)", parent));
        this.addField((FieldEditor)new StringFieldEditor("author-name", "author name, if no information in model", parent));
        this.addField((FieldEditor)new StringFieldEditor("author-mail", "author mail, if no information in model", parent));
        this.addField((FieldEditor)new StringFieldEditor("maintainer-name", "maintainer name, if no information in model", parent));
        this.addField((FieldEditor)new StringFieldEditor("maintainer-mail", "maintainer mail, if no information in model", parent));
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.distroEditor) {
            Composite parent = this.getFieldEditorParent();
            String oldDistro = (String)event.getOldValue();
            String newDistro = (String)event.getNewValue();
            int i = 0;
            String[] stringArray = this.pathEditor.getListControl(parent).getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.contains(oldDistro)) {
                    String newPath = item.replaceAll(oldDistro, newDistro);
                    this.pathEditor.getListControl(parent).setItem(i, newPath);
                }
                ++i;
                ++n2;
            }
        }
    }

    public void init(IWorkbench workbench) {
    }
}

