/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.safety.riskanalysis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum HazardType implements Enumerator
{
    MECHANICAL(0, "Mechanical", "Mechanical"),
    ELECTRICAL(1, "Electrical", "Electrical"),
    NOISE(2, "Noise", "Noise"),
    VIBRATION(3, "Vibration", "Vibration"),
    RADIATION(4, "Radiation", "Radiation"),
    MATERIAL_SUBSTANCE(5, "MaterialSubstance", "MaterialSubstance"),
    ERGONOMIC(6, "Ergonomic", "Ergonomic"),
    ENVIRONMENT_WORKSPACE(7, "EnvironmentWorkspace", "EnvironmentWorkspace"),
    COMBINATION(8, "Combination", "Combination"),
    OTHER(9, "Other", "Other");

    public static final int MECHANICAL_VALUE = 0;
    public static final int ELECTRICAL_VALUE = 1;
    public static final int NOISE_VALUE = 2;
    public static final int VIBRATION_VALUE = 3;
    public static final int RADIATION_VALUE = 4;
    public static final int MATERIAL_SUBSTANCE_VALUE = 5;
    public static final int ERGONOMIC_VALUE = 6;
    public static final int ENVIRONMENT_WORKSPACE_VALUE = 7;
    public static final int COMBINATION_VALUE = 8;
    public static final int OTHER_VALUE = 9;
    private static final HazardType[] VALUES_ARRAY;
    public static final List<HazardType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new HazardType[]{MECHANICAL, ELECTRICAL, NOISE, VIBRATION, RADIATION, MATERIAL_SUBSTANCE, ERGONOMIC, ENVIRONMENT_WORKSPACE, COMBINATION, OTHER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static HazardType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HazardType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HazardType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            HazardType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static HazardType get(int value) {
        switch (value) {
            case 0: {
                return MECHANICAL;
            }
            case 1: {
                return ELECTRICAL;
            }
            case 2: {
                return NOISE;
            }
            case 3: {
                return VIBRATION;
            }
            case 4: {
                return RADIATION;
            }
            case 5: {
                return MATERIAL_SUBSTANCE;
            }
            case 6: {
                return ERGONOMIC;
            }
            case 7: {
                return ENVIRONMENT_WORKSPACE;
            }
            case 8: {
                return COMBINATION;
            }
            case 9: {
                return OTHER;
            }
        }
        return null;
    }

    private HazardType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

