/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.safety.riskanalysis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RiskLevel implements Enumerator
{
    NEGLIGIBLE_RISK(0, "NegligibleRisk", "NegligibleRisk"),
    VERY_LOW_RISK(1, "VeryLowRisk", "VeryLowRisk"),
    LOW_RISK(2, "LowRisk", "LowRisk"),
    SIGNIFICANT_RISK(3, "SignificantRisk", "SignificantRisk"),
    HIGH_RISK(4, "HighRisk", "HighRisk"),
    VERY_HIGH_RISK(5, "VeryHighRisk", "VeryHighRisk");

    public static final int NEGLIGIBLE_RISK_VALUE = 0;
    public static final int VERY_LOW_RISK_VALUE = 1;
    public static final int LOW_RISK_VALUE = 2;
    public static final int SIGNIFICANT_RISK_VALUE = 3;
    public static final int HIGH_RISK_VALUE = 4;
    public static final int VERY_HIGH_RISK_VALUE = 5;
    private static final RiskLevel[] VALUES_ARRAY;
    public static final List<RiskLevel> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RiskLevel[]{NEGLIGIBLE_RISK, VERY_LOW_RISK, LOW_RISK, SIGNIFICANT_RISK, HIGH_RISK, VERY_HIGH_RISK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RiskLevel get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RiskLevel result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RiskLevel getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RiskLevel result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RiskLevel get(int value) {
        switch (value) {
            case 0: {
                return NEGLIGIBLE_RISK;
            }
            case 1: {
                return VERY_LOW_RISK;
            }
            case 2: {
                return LOW_RISK;
            }
            case 3: {
                return SIGNIFICANT_RISK;
            }
            case 4: {
                return HIGH_RISK;
            }
            case 5: {
                return VERY_HIGH_RISK;
            }
        }
        return null;
    }

    private RiskLevel(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

