/**
 * Copyright (c) 2020 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 */
package org.eclipse.papyrus.robotics.codegen.common.utils;

import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.designer.languages.common.profile.CommonProfileResource;
import org.eclipse.papyrus.designer.languages.cpp.profile.CppProfileResource;
import org.eclipse.papyrus.designer.transformation.base.utils.ApplyProfileUtils;
import org.eclipse.papyrus.designer.transformation.profile.TrafoProfileResource;
import org.eclipse.uml2.uml.Element;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class ApplyProfiles {
  public static void applyCppProfile(final Element element) {
    try {
      ApplyProfileUtils.applyProfile(element, CppProfileResource.PROFILE_PATH_URI);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }

  public static void applyCommonProfile(final Element element) {
    try {
      ApplyProfileUtils.applyProfile(element, CommonProfileResource.PROFILE_PATH_URI);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }

  public static void applyStdProfile(final Element element) {
    try {
      ApplyProfileUtils.applyProfile(element, URI.createURI("pathmap://UML_PROFILES/Standard.profile.uml"));
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }

  public static void applyTrafoProfile(final Element element) {
    try {
      ApplyProfileUtils.applyProfile(element, TrafoProfileResource.PROFILE_PATH_URI);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
}
