/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.faultinjection.ui.menu.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.robotics.faultinjection.FIElement;
import org.eclipse.papyrus.robotics.faultinjection.FaultList;
import org.eclipse.papyrus.robotics.faultinjection.FaultinjectionFactory;
import org.eclipse.papyrus.robotics.faultinjection.Readout;
import org.eclipse.papyrus.robotics.faultinjection.ui.Messages;
import org.eclipse.papyrus.robotics.faultinjection.ui.decoration.FIDecorationUtils;
import org.eclipse.papyrus.robotics.faultinjection.ui.utils.FaultInjectionUtils;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

public class NewObservationHandler
extends CmdHandler {
    public boolean isEnabled() {
        this.updateSelectedEObject();
        return FaultInjectionUtils.getFaultInjectionResource(this.selectedEObject) != null;
    }

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        if (this.selectedEObject instanceof Port) {
            IStructuredSelection selection = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            View view = null;
            for (Object currentObject : selection.toList()) {
                GraphicalEditPart editPart;
                if (!(currentObject instanceof GraphicalEditPart) || !((editPart = (GraphicalEditPart)currentObject).getModel() instanceof View)) continue;
                view = (View)editPart.getModel();
            }
            final View parentView = view != null ? ViewUtil.getContainerView(view) : null;
            final FaultList faultList = FaultInjectionUtils.getFaultList((Element)this.selectedEObject);
            if (faultList != null) {
                final Readout readout = FaultinjectionFactory.eINSTANCE.createReadout();
                final TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)this.selectedEObject);
                final RecordingCommand addSabotageFault = new RecordingCommand(ted, "Add readout"){

                    protected void doExecute() {
                        faultList.getElements().add((Object)readout);
                        readout.setPort(NewObservationHandler.this.selectedEObject);
                        if (parentView != null && parentView.getElement() instanceof Property) {
                            readout.setComponent(parentView.getElement());
                        } else {
                            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.NewObservationHandler_CANNOT_OBTAIN_PART, (String)Messages.NewObservationHandler_REF_REMAINS_UNSET);
                        }
                        FIDecorationUtils.addDecoration((FIElement)readout, event);
                    }
                };
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ted.getCommandStack().execute((Command)addSabotageFault);
                    }
                });
            }
        }
        return null;
    }
}

