/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.ros2.codegen.common.builder;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.papyrus.robotics.ros2.base.EnvironmentUtils;
import org.eclipse.papyrus.robotics.ros2.preferences.Ros2PreferenceUtils;

public class ColconProcessBuilder {
    private static final String BUILD = "build";
    private static final String COLCON = "colcon";
    ProcessBuilder pb = new ProcessBuilder(new String[0]);

    public ColconProcessBuilder(String pkgName) {
        String colcon = EnvironmentUtils.getFromPath((String)COLCON);
        if (colcon == null) {
            colcon = COLCON;
        }
        this.pb.command().add(colcon);
        this.pb.command().add(BUILD);
        this.pb.command().add(Ros2PreferenceUtils.getColconOptions());
        this.pb.command().add(Ros2PreferenceUtils.getColconPackageOptions());
        this.pb.command().add(pkgName);
        File wsLocation = new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        this.pb.directory(wsLocation);
        Map localEnv = EnvironmentUtils.getenv();
        Map<String, String> pbEnv = this.pb.environment();
        for (String key : localEnv.keySet()) {
            pbEnv.put(key, (String)localEnv.get(key));
        }
    }

    public Process start() throws IOException {
        return this.pb.start();
    }

    public ProcessBuilder getProcessBuilder() {
        return this.pb;
    }
}

