/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml16.portsandflows;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FeatureDirectionKind implements Enumerator
{
    PROVIDED(0, "provided", "provided"),
    PROVIDED_REQUIRED(1, "providedRequired", "providedRequired"),
    REQUIRED(2, "required", "required");

    public static final int PROVIDED_VALUE = 0;
    public static final int PROVIDED_REQUIRED_VALUE = 1;
    public static final int REQUIRED_VALUE = 2;
    private static final FeatureDirectionKind[] VALUES_ARRAY;
    public static final List<FeatureDirectionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FeatureDirectionKind[]{PROVIDED, PROVIDED_REQUIRED, REQUIRED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FeatureDirectionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FeatureDirectionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FeatureDirectionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FeatureDirectionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FeatureDirectionKind get(int value) {
        switch (value) {
            case 0: {
                return PROVIDED;
            }
            case 1: {
                return PROVIDED_REQUIRED;
            }
            case 2: {
                return REQUIRED;
            }
        }
        return null;
    }

    private FeatureDirectionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

