/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.ui;

import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeManager;
import org.eclipse.papyrus.infra.services.controlmode.ControlModePlugin;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class CreateModelFragmentDialog
extends ResourceDialog {
    static final String DIALOG_SETTINGS = "CreateModelFragmentDialog";
    static final String SETTING_CREATE_SHARD = "createShard";
    private static final String DIALOG_TITLE = Messages.getString("CreateModelFragmentDialog.dialog.title");
    private URI uri;
    private Resource currentResource;
    private EObject objectToControl;
    private String defaultName;
    private Button shardButton;
    private boolean createShard;
    private ControlDecoration controlDecoration;

    public CreateModelFragmentDialog(Shell parent, Resource theCurrentResource, String defaultName) {
        super(parent, DIALOG_TITLE, 8192);
        this.currentResource = theCurrentResource;
        this.defaultName = defaultName;
    }

    public CreateModelFragmentDialog(Shell parent, EObject objectToControl, String defaultName) {
        this(parent, objectToControl.eResource(), defaultName);
        this.objectToControl = objectToControl;
    }

    protected void prepareBrowseWorkspaceButton(Button browseWorkspaceButton) {
        browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IFile file = null;
                String path = URI.createURI((String)CreateModelFragmentDialog.this.computeDefaultURI()).lastSegment();
                file = WorkspaceResourceDialog.openNewFile((Shell)CreateModelFragmentDialog.this.getShell(), null, null, (IPath)(path != null ? new Path(path) : null), null);
                if (file != null) {
                    CreateModelFragmentDialog.this.uriField.setText(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true).toString());
                }
            }
        });
    }

    public String computeDefaultURI() {
        String ext = this.currentResource.getURI().fileExtension();
        URI uri = this.currentResource.getURI().trimSegments(1);
        uri = uri.appendSegment(this.defaultName).appendFileExtension(ext);
        return uri.toString();
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.uriField.setText(this.computeDefaultURI());
        this.loadDialogState();
        if (this.objectToControl != null && !ControlModeManager.getInstance().canCreateSubmodel(this.objectToControl)) {
            this.shardButton.setSelection(false);
            this.shardButton.setEnabled(false);
            this.createShard = true;
        }
        this.validateDialog();
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        Control[] superContents = result.getChildren();
        this.shardButton = new Button(result, 32);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.uriField, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100, -10);
        this.shardButton.setLayoutData((Object)data);
        Control separator = superContents[superContents.length - 1];
        ((FormData)separator.getLayoutData()).top.control = this.shardButton;
        this.shardButton.setText(Messages.getString("CreateModelFragmentDialog.submodel.checkbox"));
        this.shardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateModelFragmentDialog.this.createShard = !CreateModelFragmentDialog.this.shardButton.getSelection();
                CreateModelFragmentDialog.this.validateDialog();
            }
        });
        this.uriField.addModifyListener(__ -> {
            boolean bl = this.validateDialog();
        });
        this.controlDecoration = new ControlDecoration((Control)this.uriField, 16512);
        Control buttonComposite = superContents[0];
        result.setTabList(new Control[]{this.uriField, buttonComposite, this.shardButton});
        return result;
    }

    protected boolean processResources() {
        this.uri = URI.createURI((String)this.getURIText());
        this.saveDialogState();
        return true;
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean isCreateShard() {
        return this.createShard;
    }

    private void loadDialogState() {
        IDialogSettings settings = DialogSettings.getOrCreateSection((IDialogSettings)ControlModePlugin.getDefault().getDialogSettings(), (String)DIALOG_SETTINGS);
        this.loadDialogState(settings);
    }

    protected void loadDialogState(IDialogSettings settings) {
        this.createShard = settings.getBoolean(SETTING_CREATE_SHARD);
        this.shardButton.setSelection(!this.createShard);
    }

    private void saveDialogState() {
        IDialogSettings settings = DialogSettings.getOrCreateSection((IDialogSettings)ControlModePlugin.getDefault().getDialogSettings(), (String)DIALOG_SETTINGS);
        this.saveDialogState(settings);
    }

    protected void saveDialogState(IDialogSettings settings) {
        if (this.shardButton.isEnabled()) {
            settings.put(SETTING_CREATE_SHARD, this.createShard);
        }
    }

    protected boolean validateDialog() {
        Diagnostic diagnostic = this.diagnosticDialog();
        switch (diagnostic.getSeverity()) {
            case 4: {
                FieldDecoration error = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
                this.controlDecoration.setImage(error.getImage());
                this.controlDecoration.showHoverText(diagnostic.getMessage());
                this.controlDecoration.setDescriptionText(diagnostic.getMessage());
                this.controlDecoration.show();
                this.getButton(0).setEnabled(false);
                break;
            }
            case 2: {
                FieldDecoration warning = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
                this.controlDecoration.setImage(warning.getImage());
                this.controlDecoration.showHoverText(diagnostic.getMessage());
                this.controlDecoration.setDescriptionText(diagnostic.getMessage());
                this.controlDecoration.show();
                this.getButton(0).setEnabled(true);
                break;
            }
            default: {
                this.controlDecoration.hide();
                this.getButton(0).setEnabled(true);
            }
        }
        return diagnostic.getSeverity() != 4;
    }

    protected Diagnostic diagnosticDialog() {
        URI uri = this.getURIs().stream().findAny().orElse(null);
        Diagnostic diagnostic = Diagnostic.OK_INSTANCE;
        if (uri != null && this.objectToControl != null) {
            ControlModeRequest request = ControlModeRequest.createUIControlModelRequest(TransactionUtil.getEditingDomain((EObject)this.objectToControl), this.objectToControl, uri);
            diagnostic = ControlModeManager.getInstance().approveRequest(request);
        }
        if (diagnostic.getSeverity() == 0 && new ResourceSetImpl().getURIConverter().exists(uri, Collections.emptyMap())) {
            diagnostic = new BasicDiagnostic(2, "org.eclipse.papyrus.infra.services.controlmode", 0, Messages.getString("CreateModelFragmentDialog.dialog.warning.alreadyexist"), null);
        }
        return diagnostic;
    }
}

